/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.threatintelligence.model.IndicatorType;
import com.oracle.bmc.threatintelligence.model.SortOrder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummarizeIndicatorsDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="indicatorType")
    private final IndicatorType indicatorType;
    @JsonProperty(value="indicatorValue")
    private final String indicatorValue;
    @JsonProperty(value="threatTypes")
    private final List<String> threatTypes;
    @JsonProperty(value="confidenceGreaterThanOrEqualTo")
    private final Integer confidenceGreaterThanOrEqualTo;
    @JsonProperty(value="timeUpdatedGreaterThanOrEqualTo")
    private final Date timeUpdatedGreaterThanOrEqualTo;
    @JsonProperty(value="timeUpdatedLessThan")
    private final Date timeUpdatedLessThan;
    @JsonProperty(value="timeLastSeenGreaterThanOrEqualTo")
    private final Date timeLastSeenGreaterThanOrEqualTo;
    @JsonProperty(value="timeLastSeenLessThan")
    private final Date timeLastSeenLessThan;
    @JsonProperty(value="timeCreatedGreaterThanOrEqualTo")
    private final Date timeCreatedGreaterThanOrEqualTo;
    @JsonProperty(value="timeCreatedLessThan")
    private final Date timeCreatedLessThan;
    @JsonProperty(value="indicatorSeenBy")
    private final String indicatorSeenBy;
    @JsonProperty(value="malware")
    private final String malware;
    @JsonProperty(value="threatActor")
    private final String threatActor;
    @JsonProperty(value="sortOrder")
    private final SortOrder sortOrder;
    @JsonProperty(value="sortBy")
    private final SortBy sortBy;

    @Deprecated
    @ConstructorProperties(value={"indicatorType", "indicatorValue", "threatTypes", "confidenceGreaterThanOrEqualTo", "timeUpdatedGreaterThanOrEqualTo", "timeUpdatedLessThan", "timeLastSeenGreaterThanOrEqualTo", "timeLastSeenLessThan", "timeCreatedGreaterThanOrEqualTo", "timeCreatedLessThan", "indicatorSeenBy", "malware", "threatActor", "sortOrder", "sortBy"})
    public SummarizeIndicatorsDetails(IndicatorType indicatorType, String indicatorValue, List<String> threatTypes, Integer confidenceGreaterThanOrEqualTo, Date timeUpdatedGreaterThanOrEqualTo, Date timeUpdatedLessThan, Date timeLastSeenGreaterThanOrEqualTo, Date timeLastSeenLessThan, Date timeCreatedGreaterThanOrEqualTo, Date timeCreatedLessThan, String indicatorSeenBy, String malware, String threatActor, SortOrder sortOrder, SortBy sortBy) {
        this.indicatorType = indicatorType;
        this.indicatorValue = indicatorValue;
        this.threatTypes = threatTypes;
        this.confidenceGreaterThanOrEqualTo = confidenceGreaterThanOrEqualTo;
        this.timeUpdatedGreaterThanOrEqualTo = timeUpdatedGreaterThanOrEqualTo;
        this.timeUpdatedLessThan = timeUpdatedLessThan;
        this.timeLastSeenGreaterThanOrEqualTo = timeLastSeenGreaterThanOrEqualTo;
        this.timeLastSeenLessThan = timeLastSeenLessThan;
        this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
        this.timeCreatedLessThan = timeCreatedLessThan;
        this.indicatorSeenBy = indicatorSeenBy;
        this.malware = malware;
        this.threatActor = threatActor;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public IndicatorType getIndicatorType() {
        return this.indicatorType;
    }

    public String getIndicatorValue() {
        return this.indicatorValue;
    }

    public List<String> getThreatTypes() {
        return this.threatTypes;
    }

    public Integer getConfidenceGreaterThanOrEqualTo() {
        return this.confidenceGreaterThanOrEqualTo;
    }

    public Date getTimeUpdatedGreaterThanOrEqualTo() {
        return this.timeUpdatedGreaterThanOrEqualTo;
    }

    public Date getTimeUpdatedLessThan() {
        return this.timeUpdatedLessThan;
    }

    public Date getTimeLastSeenGreaterThanOrEqualTo() {
        return this.timeLastSeenGreaterThanOrEqualTo;
    }

    public Date getTimeLastSeenLessThan() {
        return this.timeLastSeenLessThan;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public String getIndicatorSeenBy() {
        return this.indicatorSeenBy;
    }

    public String getMalware() {
        return this.malware;
    }

    public String getThreatActor() {
        return this.threatActor;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummarizeIndicatorsDetails(");
        sb.append("super=").append(super.toString());
        sb.append("indicatorType=").append(String.valueOf((Object)this.indicatorType));
        sb.append(", indicatorValue=").append(String.valueOf(this.indicatorValue));
        sb.append(", threatTypes=").append(String.valueOf(this.threatTypes));
        sb.append(", confidenceGreaterThanOrEqualTo=").append(String.valueOf(this.confidenceGreaterThanOrEqualTo));
        sb.append(", timeUpdatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeUpdatedGreaterThanOrEqualTo));
        sb.append(", timeUpdatedLessThan=").append(String.valueOf(this.timeUpdatedLessThan));
        sb.append(", timeLastSeenGreaterThanOrEqualTo=").append(String.valueOf(this.timeLastSeenGreaterThanOrEqualTo));
        sb.append(", timeLastSeenLessThan=").append(String.valueOf(this.timeLastSeenLessThan));
        sb.append(", timeCreatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCreatedGreaterThanOrEqualTo));
        sb.append(", timeCreatedLessThan=").append(String.valueOf(this.timeCreatedLessThan));
        sb.append(", indicatorSeenBy=").append(String.valueOf(this.indicatorSeenBy));
        sb.append(", malware=").append(String.valueOf(this.malware));
        sb.append(", threatActor=").append(String.valueOf(this.threatActor));
        sb.append(", sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(", sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeIndicatorsDetails)) {
            return false;
        }
        SummarizeIndicatorsDetails other = (SummarizeIndicatorsDetails)((Object)o);
        return Objects.equals((Object)this.indicatorType, (Object)other.indicatorType) && Objects.equals(this.indicatorValue, other.indicatorValue) && Objects.equals(this.threatTypes, other.threatTypes) && Objects.equals(this.confidenceGreaterThanOrEqualTo, other.confidenceGreaterThanOrEqualTo) && Objects.equals(this.timeUpdatedGreaterThanOrEqualTo, other.timeUpdatedGreaterThanOrEqualTo) && Objects.equals(this.timeUpdatedLessThan, other.timeUpdatedLessThan) && Objects.equals(this.timeLastSeenGreaterThanOrEqualTo, other.timeLastSeenGreaterThanOrEqualTo) && Objects.equals(this.timeLastSeenLessThan, other.timeLastSeenLessThan) && Objects.equals(this.timeCreatedGreaterThanOrEqualTo, other.timeCreatedGreaterThanOrEqualTo) && Objects.equals(this.timeCreatedLessThan, other.timeCreatedLessThan) && Objects.equals(this.indicatorSeenBy, other.indicatorSeenBy) && Objects.equals(this.malware, other.malware) && Objects.equals(this.threatActor, other.threatActor) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.indicatorType == null ? 43 : this.indicatorType.hashCode());
        result = result * 59 + (this.indicatorValue == null ? 43 : this.indicatorValue.hashCode());
        result = result * 59 + (this.threatTypes == null ? 43 : this.threatTypes.hashCode());
        result = result * 59 + (this.confidenceGreaterThanOrEqualTo == null ? 43 : this.confidenceGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUpdatedGreaterThanOrEqualTo == null ? 43 : this.timeUpdatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUpdatedLessThan == null ? 43 : this.timeUpdatedLessThan.hashCode());
        result = result * 59 + (this.timeLastSeenGreaterThanOrEqualTo == null ? 43 : this.timeLastSeenGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLastSeenLessThan == null ? 43 : this.timeLastSeenLessThan.hashCode());
        result = result * 59 + (this.timeCreatedGreaterThanOrEqualTo == null ? 43 : this.timeCreatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeCreatedLessThan == null ? 43 : this.timeCreatedLessThan.hashCode());
        result = result * 59 + (this.indicatorSeenBy == null ? 43 : this.indicatorSeenBy.hashCode());
        result = result * 59 + (this.malware == null ? 43 : this.malware.hashCode());
        result = result * 59 + (this.threatActor == null ? 43 : this.threatActor.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SortBy implements BmcEnum
    {
        Confidence("CONFIDENCE"),
        Timecreated("TIMECREATED"),
        Timeupdated("TIMEUPDATED"),
        Timelastseen("TIMELASTSEEN");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="indicatorType")
        private IndicatorType indicatorType;
        @JsonProperty(value="indicatorValue")
        private String indicatorValue;
        @JsonProperty(value="threatTypes")
        private List<String> threatTypes;
        @JsonProperty(value="confidenceGreaterThanOrEqualTo")
        private Integer confidenceGreaterThanOrEqualTo;
        @JsonProperty(value="timeUpdatedGreaterThanOrEqualTo")
        private Date timeUpdatedGreaterThanOrEqualTo;
        @JsonProperty(value="timeUpdatedLessThan")
        private Date timeUpdatedLessThan;
        @JsonProperty(value="timeLastSeenGreaterThanOrEqualTo")
        private Date timeLastSeenGreaterThanOrEqualTo;
        @JsonProperty(value="timeLastSeenLessThan")
        private Date timeLastSeenLessThan;
        @JsonProperty(value="timeCreatedGreaterThanOrEqualTo")
        private Date timeCreatedGreaterThanOrEqualTo;
        @JsonProperty(value="timeCreatedLessThan")
        private Date timeCreatedLessThan;
        @JsonProperty(value="indicatorSeenBy")
        private String indicatorSeenBy;
        @JsonProperty(value="malware")
        private String malware;
        @JsonProperty(value="threatActor")
        private String threatActor;
        @JsonProperty(value="sortOrder")
        private SortOrder sortOrder;
        @JsonProperty(value="sortBy")
        private SortBy sortBy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder indicatorType(IndicatorType indicatorType) {
            this.indicatorType = indicatorType;
            this.__explicitlySet__.add("indicatorType");
            return this;
        }

        public Builder indicatorValue(String indicatorValue) {
            this.indicatorValue = indicatorValue;
            this.__explicitlySet__.add("indicatorValue");
            return this;
        }

        public Builder threatTypes(List<String> threatTypes) {
            this.threatTypes = threatTypes;
            this.__explicitlySet__.add("threatTypes");
            return this;
        }

        public Builder confidenceGreaterThanOrEqualTo(Integer confidenceGreaterThanOrEqualTo) {
            this.confidenceGreaterThanOrEqualTo = confidenceGreaterThanOrEqualTo;
            this.__explicitlySet__.add("confidenceGreaterThanOrEqualTo");
            return this;
        }

        public Builder timeUpdatedGreaterThanOrEqualTo(Date timeUpdatedGreaterThanOrEqualTo) {
            this.timeUpdatedGreaterThanOrEqualTo = timeUpdatedGreaterThanOrEqualTo;
            this.__explicitlySet__.add("timeUpdatedGreaterThanOrEqualTo");
            return this;
        }

        public Builder timeUpdatedLessThan(Date timeUpdatedLessThan) {
            this.timeUpdatedLessThan = timeUpdatedLessThan;
            this.__explicitlySet__.add("timeUpdatedLessThan");
            return this;
        }

        public Builder timeLastSeenGreaterThanOrEqualTo(Date timeLastSeenGreaterThanOrEqualTo) {
            this.timeLastSeenGreaterThanOrEqualTo = timeLastSeenGreaterThanOrEqualTo;
            this.__explicitlySet__.add("timeLastSeenGreaterThanOrEqualTo");
            return this;
        }

        public Builder timeLastSeenLessThan(Date timeLastSeenLessThan) {
            this.timeLastSeenLessThan = timeLastSeenLessThan;
            this.__explicitlySet__.add("timeLastSeenLessThan");
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            this.__explicitlySet__.add("timeCreatedGreaterThanOrEqualTo");
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            this.__explicitlySet__.add("timeCreatedLessThan");
            return this;
        }

        public Builder indicatorSeenBy(String indicatorSeenBy) {
            this.indicatorSeenBy = indicatorSeenBy;
            this.__explicitlySet__.add("indicatorSeenBy");
            return this;
        }

        public Builder malware(String malware) {
            this.malware = malware;
            this.__explicitlySet__.add("malware");
            return this;
        }

        public Builder threatActor(String threatActor) {
            this.threatActor = threatActor;
            this.__explicitlySet__.add("threatActor");
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            this.__explicitlySet__.add("sortOrder");
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            this.__explicitlySet__.add("sortBy");
            return this;
        }

        public SummarizeIndicatorsDetails build() {
            SummarizeIndicatorsDetails model = new SummarizeIndicatorsDetails(this.indicatorType, this.indicatorValue, this.threatTypes, this.confidenceGreaterThanOrEqualTo, this.timeUpdatedGreaterThanOrEqualTo, this.timeUpdatedLessThan, this.timeLastSeenGreaterThanOrEqualTo, this.timeLastSeenLessThan, this.timeCreatedGreaterThanOrEqualTo, this.timeCreatedLessThan, this.indicatorSeenBy, this.malware, this.threatActor, this.sortOrder, this.sortBy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummarizeIndicatorsDetails model) {
            if (model.wasPropertyExplicitlySet("indicatorType")) {
                this.indicatorType(model.getIndicatorType());
            }
            if (model.wasPropertyExplicitlySet("indicatorValue")) {
                this.indicatorValue(model.getIndicatorValue());
            }
            if (model.wasPropertyExplicitlySet("threatTypes")) {
                this.threatTypes(model.getThreatTypes());
            }
            if (model.wasPropertyExplicitlySet("confidenceGreaterThanOrEqualTo")) {
                this.confidenceGreaterThanOrEqualTo(model.getConfidenceGreaterThanOrEqualTo());
            }
            if (model.wasPropertyExplicitlySet("timeUpdatedGreaterThanOrEqualTo")) {
                this.timeUpdatedGreaterThanOrEqualTo(model.getTimeUpdatedGreaterThanOrEqualTo());
            }
            if (model.wasPropertyExplicitlySet("timeUpdatedLessThan")) {
                this.timeUpdatedLessThan(model.getTimeUpdatedLessThan());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeenGreaterThanOrEqualTo")) {
                this.timeLastSeenGreaterThanOrEqualTo(model.getTimeLastSeenGreaterThanOrEqualTo());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeenLessThan")) {
                this.timeLastSeenLessThan(model.getTimeLastSeenLessThan());
            }
            if (model.wasPropertyExplicitlySet("timeCreatedGreaterThanOrEqualTo")) {
                this.timeCreatedGreaterThanOrEqualTo(model.getTimeCreatedGreaterThanOrEqualTo());
            }
            if (model.wasPropertyExplicitlySet("timeCreatedLessThan")) {
                this.timeCreatedLessThan(model.getTimeCreatedLessThan());
            }
            if (model.wasPropertyExplicitlySet("indicatorSeenBy")) {
                this.indicatorSeenBy(model.getIndicatorSeenBy());
            }
            if (model.wasPropertyExplicitlySet("malware")) {
                this.malware(model.getMalware());
            }
            if (model.wasPropertyExplicitlySet("threatActor")) {
                this.threatActor(model.getThreatActor());
            }
            if (model.wasPropertyExplicitlySet("sortOrder")) {
                this.sortOrder(model.getSortOrder());
            }
            if (model.wasPropertyExplicitlySet("sortBy")) {
                this.sortBy(model.getSortBy());
            }
            return this;
        }
    }
}

