/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.threatintelligence.model.IndicatorType;
import com.oracle.bmc.threatintelligence.model.SortOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListIndicatorsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<String> threatTypeName;
    private IndicatorType type;
    private String value;
    private Integer confidenceGreaterThanOrEqualTo;
    private Date timeUpdatedGreaterThanOrEqualTo;
    private Date timeUpdatedLessThan;
    private Date timeLastSeenGreaterThanOrEqualTo;
    private Date timeLastSeenLessThan;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Date timeCreatedLessThan;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getThreatTypeName() {
        return this.threatTypeName;
    }

    public IndicatorType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getConfidenceGreaterThanOrEqualTo() {
        return this.confidenceGreaterThanOrEqualTo;
    }

    public Date getTimeUpdatedGreaterThanOrEqualTo() {
        return this.timeUpdatedGreaterThanOrEqualTo;
    }

    public Date getTimeUpdatedLessThan() {
        return this.timeUpdatedLessThan;
    }

    public Date getTimeLastSeenGreaterThanOrEqualTo() {
        return this.timeLastSeenGreaterThanOrEqualTo;
    }

    public Date getTimeLastSeenLessThan() {
        return this.timeLastSeenLessThan;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).threatTypeName(this.threatTypeName).type(this.type).value(this.value).confidenceGreaterThanOrEqualTo(this.confidenceGreaterThanOrEqualTo).timeUpdatedGreaterThanOrEqualTo(this.timeUpdatedGreaterThanOrEqualTo).timeUpdatedLessThan(this.timeUpdatedLessThan).timeLastSeenGreaterThanOrEqualTo(this.timeLastSeenGreaterThanOrEqualTo).timeLastSeenLessThan(this.timeLastSeenLessThan).timeCreatedGreaterThanOrEqualTo(this.timeCreatedGreaterThanOrEqualTo).timeCreatedLessThan(this.timeCreatedLessThan).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",threatTypeName=").append(String.valueOf(this.threatTypeName));
        sb.append(",type=").append(String.valueOf((Object)this.type));
        sb.append(",value=").append(String.valueOf(this.value));
        sb.append(",confidenceGreaterThanOrEqualTo=").append(String.valueOf(this.confidenceGreaterThanOrEqualTo));
        sb.append(",timeUpdatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeUpdatedGreaterThanOrEqualTo));
        sb.append(",timeUpdatedLessThan=").append(String.valueOf(this.timeUpdatedLessThan));
        sb.append(",timeLastSeenGreaterThanOrEqualTo=").append(String.valueOf(this.timeLastSeenGreaterThanOrEqualTo));
        sb.append(",timeLastSeenLessThan=").append(String.valueOf(this.timeLastSeenLessThan));
        sb.append(",timeCreatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCreatedGreaterThanOrEqualTo));
        sb.append(",timeCreatedLessThan=").append(String.valueOf(this.timeCreatedLessThan));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIndicatorsRequest)) {
            return false;
        }
        ListIndicatorsRequest other = (ListIndicatorsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.threatTypeName, other.threatTypeName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.confidenceGreaterThanOrEqualTo, other.confidenceGreaterThanOrEqualTo) && Objects.equals(this.timeUpdatedGreaterThanOrEqualTo, other.timeUpdatedGreaterThanOrEqualTo) && Objects.equals(this.timeUpdatedLessThan, other.timeUpdatedLessThan) && Objects.equals(this.timeLastSeenGreaterThanOrEqualTo, other.timeLastSeenGreaterThanOrEqualTo) && Objects.equals(this.timeLastSeenLessThan, other.timeLastSeenLessThan) && Objects.equals(this.timeCreatedGreaterThanOrEqualTo, other.timeCreatedGreaterThanOrEqualTo) && Objects.equals(this.timeCreatedLessThan, other.timeCreatedLessThan) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.threatTypeName == null ? 43 : this.threatTypeName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.confidenceGreaterThanOrEqualTo == null ? 43 : this.confidenceGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUpdatedGreaterThanOrEqualTo == null ? 43 : this.timeUpdatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUpdatedLessThan == null ? 43 : this.timeUpdatedLessThan.hashCode());
        result = result * 59 + (this.timeLastSeenGreaterThanOrEqualTo == null ? 43 : this.timeLastSeenGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLastSeenLessThan == null ? 43 : this.timeLastSeenLessThan.hashCode());
        result = result * 59 + (this.timeCreatedGreaterThanOrEqualTo == null ? 43 : this.timeCreatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeCreatedLessThan == null ? 43 : this.timeCreatedLessThan.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIndicatorsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<String> threatTypeName = null;
        private IndicatorType type = null;
        private String value = null;
        private Integer confidenceGreaterThanOrEqualTo = null;
        private Date timeUpdatedGreaterThanOrEqualTo = null;
        private Date timeUpdatedLessThan = null;
        private Date timeLastSeenGreaterThanOrEqualTo = null;
        private Date timeLastSeenLessThan = null;
        private Date timeCreatedGreaterThanOrEqualTo = null;
        private Date timeCreatedLessThan = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder threatTypeName(List<String> threatTypeName) {
            this.threatTypeName = threatTypeName;
            return this;
        }

        public Builder threatTypeName(String singularValue) {
            return this.threatTypeName(Arrays.asList(singularValue));
        }

        public Builder type(IndicatorType type) {
            this.type = type;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder confidenceGreaterThanOrEqualTo(Integer confidenceGreaterThanOrEqualTo) {
            this.confidenceGreaterThanOrEqualTo = confidenceGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeUpdatedGreaterThanOrEqualTo(Date timeUpdatedGreaterThanOrEqualTo) {
            this.timeUpdatedGreaterThanOrEqualTo = timeUpdatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeUpdatedLessThan(Date timeUpdatedLessThan) {
            this.timeUpdatedLessThan = timeUpdatedLessThan;
            return this;
        }

        public Builder timeLastSeenGreaterThanOrEqualTo(Date timeLastSeenGreaterThanOrEqualTo) {
            this.timeLastSeenGreaterThanOrEqualTo = timeLastSeenGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLastSeenLessThan(Date timeLastSeenLessThan) {
            this.timeLastSeenLessThan = timeLastSeenLessThan;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIndicatorsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.threatTypeName(o.getThreatTypeName());
            this.type(o.getType());
            this.value(o.getValue());
            this.confidenceGreaterThanOrEqualTo(o.getConfidenceGreaterThanOrEqualTo());
            this.timeUpdatedGreaterThanOrEqualTo(o.getTimeUpdatedGreaterThanOrEqualTo());
            this.timeUpdatedLessThan(o.getTimeUpdatedLessThan());
            this.timeLastSeenGreaterThanOrEqualTo(o.getTimeLastSeenGreaterThanOrEqualTo());
            this.timeLastSeenLessThan(o.getTimeLastSeenLessThan());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.timeCreatedLessThan(o.getTimeCreatedLessThan());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIndicatorsRequest build() {
            ListIndicatorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListIndicatorsRequest buildWithoutInvocationCallback() {
            ListIndicatorsRequest request = new ListIndicatorsRequest();
            request.compartmentId = this.compartmentId;
            request.threatTypeName = this.threatTypeName;
            request.type = this.type;
            request.value = this.value;
            request.confidenceGreaterThanOrEqualTo = this.confidenceGreaterThanOrEqualTo;
            request.timeUpdatedGreaterThanOrEqualTo = this.timeUpdatedGreaterThanOrEqualTo;
            request.timeUpdatedLessThan = this.timeUpdatedLessThan;
            request.timeLastSeenGreaterThanOrEqualTo = this.timeLastSeenGreaterThanOrEqualTo;
            request.timeLastSeenLessThan = this.timeLastSeenLessThan;
            request.timeCreatedGreaterThanOrEqualTo = this.timeCreatedGreaterThanOrEqualTo;
            request.timeCreatedLessThan = this.timeCreatedLessThan;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Confidence("confidence"),
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        TimeLastSeen("timeLastSeen");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

