/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.usage.RewardsAsync;
import com.oracle.bmc.usage.model.ProductCollection;
import com.oracle.bmc.usage.model.RedeemableUserCollection;
import com.oracle.bmc.usage.model.RedemptionCollection;
import com.oracle.bmc.usage.model.RewardCollection;
import com.oracle.bmc.usage.requests.CreateRedeemableUserRequest;
import com.oracle.bmc.usage.requests.DeleteRedeemableUserRequest;
import com.oracle.bmc.usage.requests.ListProductsRequest;
import com.oracle.bmc.usage.requests.ListRedeemableUsersRequest;
import com.oracle.bmc.usage.requests.ListRedemptionsRequest;
import com.oracle.bmc.usage.requests.ListRewardsRequest;
import com.oracle.bmc.usage.responses.CreateRedeemableUserResponse;
import com.oracle.bmc.usage.responses.DeleteRedeemableUserResponse;
import com.oracle.bmc.usage.responses.ListProductsResponse;
import com.oracle.bmc.usage.responses.ListRedeemableUsersResponse;
import com.oracle.bmc.usage.responses.ListRedemptionsResponse;
import com.oracle.bmc.usage.responses.ListRewardsResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewardsAsyncClient
extends BaseAsyncClient
implements RewardsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REWARDS").serviceEndpointPrefix("").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RewardsAsyncClient.class);

    RewardsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateRedeemableUserResponse> createRedeemableUser(CreateRedeemableUserRequest request, AsyncHandler<CreateRedeemableUserRequest, CreateRedeemableUserResponse> handler) {
        Objects.requireNonNull(request.getCreateRedeemableUserDetails(), "createRedeemableUserDetails is required");
        Objects.requireNonNull(request.getTenancyId(), "tenancyId is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateRedeemableUserResponse::builder).logger(LOG, "createRedeemableUser").serviceDetails("Rewards", "CreateRedeemableUser", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/RedeemableUser/CreateRedeemableUser").method(Method.POST).requestBuilder(CreateRedeemableUserRequest::builder).basePath("/20190111").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("redeemableUsers").appendQueryParam("tenancyId", (Object)request.getTenancyId()).appendQueryParam("userId", (Object)request.getUserId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(RedeemableUserCollection.class, CreateRedeemableUserResponse.Builder::redeemableUserCollection).handleResponseHeaderString("opc-request-id", CreateRedeemableUserResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateRedeemableUserResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteRedeemableUserResponse> deleteRedeemableUser(DeleteRedeemableUserRequest request, AsyncHandler<DeleteRedeemableUserRequest, DeleteRedeemableUserResponse> handler) {
        Objects.requireNonNull(request.getEmailId(), "emailId is required");
        Objects.requireNonNull(request.getTenancyId(), "tenancyId is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRedeemableUserResponse::builder).logger(LOG, "deleteRedeemableUser").serviceDetails("Rewards", "DeleteRedeemableUser", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/RedeemableUser/DeleteRedeemableUser").method(Method.DELETE).requestBuilder(DeleteRedeemableUserRequest::builder).basePath("/20190111").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("redeemableUsers").appendQueryParam("emailId", (Object)request.getEmailId()).appendQueryParam("tenancyId", (Object)request.getTenancyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteRedeemableUserResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListProductsResponse> listProducts(ListProductsRequest request, AsyncHandler<ListProductsRequest, ListProductsResponse> handler) {
        Objects.requireNonNull(request.getTenancyId(), "tenancyId is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUsagePeriodKey(), "usagePeriodKey is required");
        return this.clientCall(request, ListProductsResponse::builder).logger(LOG, "listProducts").serviceDetails("Rewards", "ListProducts", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/ProductSummary/ListProducts").method(Method.GET).requestBuilder(ListProductsRequest::builder).basePath("/20190111").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("products").appendQueryParam("tenancyId", (Object)request.getTenancyId()).appendQueryParam("usagePeriodKey", (Object)request.getUsagePeriodKey()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("producttype", (BmcEnum)request.getProducttype()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProductCollection.class, ListProductsResponse.Builder::productCollection).handleResponseHeaderString("opc-request-id", ListProductsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProductsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRedeemableUsersResponse> listRedeemableUsers(ListRedeemableUsersRequest request, AsyncHandler<ListRedeemableUsersRequest, ListRedeemableUsersResponse> handler) {
        Objects.requireNonNull(request.getTenancyId(), "tenancyId is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRedeemableUsersResponse::builder).logger(LOG, "listRedeemableUsers").serviceDetails("Rewards", "ListRedeemableUsers", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/RedeemableUserSummary/ListRedeemableUsers").method(Method.GET).requestBuilder(ListRedeemableUsersRequest::builder).basePath("/20190111").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("redeemableUsers").appendQueryParam("tenancyId", (Object)request.getTenancyId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RedeemableUserCollection.class, ListRedeemableUsersResponse.Builder::redeemableUserCollection).handleResponseHeaderString("opc-request-id", ListRedeemableUsersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRedeemableUsersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRedemptionsResponse> listRedemptions(ListRedemptionsRequest request, AsyncHandler<ListRedemptionsRequest, ListRedemptionsResponse> handler) {
        Objects.requireNonNull(request.getTenancyId(), "tenancyId is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRedemptionsResponse::builder).logger(LOG, "listRedemptions").serviceDetails("Rewards", "ListRedemptions", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/RedemptionSummary/ListRedemptions").method(Method.GET).requestBuilder(ListRedemptionsRequest::builder).basePath("/20190111").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("redemptions").appendQueryParam("tenancyId", (Object)request.getTenancyId()).appendQueryParam("timeRedeemedGreaterThanOrEqualTo", (Object)request.getTimeRedeemedGreaterThanOrEqualTo()).appendQueryParam("timeRedeemedLessThan", (Object)request.getTimeRedeemedLessThan()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RedemptionCollection.class, ListRedemptionsResponse.Builder::redemptionCollection).handleResponseHeaderString("opc-request-id", ListRedemptionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRedemptionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRewardsResponse> listRewards(ListRewardsRequest request, AsyncHandler<ListRewardsRequest, ListRewardsResponse> handler) {
        Objects.requireNonNull(request.getTenancyId(), "tenancyId is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRewardsResponse::builder).logger(LOG, "listRewards").serviceDetails("Rewards", "ListRewards", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/MonthlyRewardSummary/ListRewards").method(Method.GET).requestBuilder(ListRewardsRequest::builder).basePath("/20190111").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("rewards").appendQueryParam("tenancyId", (Object)request.getTenancyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RewardCollection.class, ListRewardsResponse.Builder::rewardCollection).handleResponseHeaderString("opc-request-id", ListRewardsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public RewardsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RewardsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RewardsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RewardsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RewardsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RewardsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RewardsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RewardsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public RewardsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RewardsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public RewardsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RewardsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public RewardsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RewardsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RewardsAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "usage";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"usage");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RewardsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RewardsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

