/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListUsageLimitsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String subscriptionId;
    private String limitType;
    private String resourceType;
    private String serviceType;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;
    private SortBy sortBy;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getLimitType() {
        return this.limitType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).subscriptionId(this.subscriptionId).limitType(this.limitType).resourceType(this.resourceType).serviceType(this.serviceType).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).sortOrder(this.sortOrder).sortBy(this.sortBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",limitType=").append(String.valueOf(this.limitType));
        sb.append(",resourceType=").append(String.valueOf(this.resourceType));
        sb.append(",serviceType=").append(String.valueOf(this.serviceType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListUsageLimitsRequest)) {
            return false;
        }
        ListUsageLimitsRequest other = (ListUsageLimitsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.limitType, other.limitType) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.serviceType, other.serviceType) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.limitType == null ? 43 : this.limitType.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.serviceType == null ? 43 : this.serviceType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListUsageLimitsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String subscriptionId = null;
        private String limitType = null;
        private String resourceType = null;
        private String serviceType = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder limitType(String limitType) {
            this.limitType = limitType;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUsageLimitsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.subscriptionId(o.getSubscriptionId());
            this.limitType(o.getLimitType());
            this.resourceType(o.getResourceType());
            this.serviceType(o.getServiceType());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUsageLimitsRequest build() {
            ListUsageLimitsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListUsageLimitsRequest buildWithoutInvocationCallback() {
            ListUsageLimitsRequest request = new ListUsageLimitsRequest();
            request.compartmentId = this.compartmentId;
            request.subscriptionId = this.subscriptionId;
            request.limitType = this.limitType;
            request.resourceType = this.resourceType;
            request.serviceType = this.serviceType;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Timestart("TIMESTART");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

