/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.usage.Resources;
import com.oracle.bmc.usage.ResourcesPaginators;
import com.oracle.bmc.usage.model.ResourceQuotumCollection;
import com.oracle.bmc.usage.model.ResourcesCollection;
import com.oracle.bmc.usage.requests.ListResourceQuotaRequest;
import com.oracle.bmc.usage.requests.ListResourcesRequest;
import com.oracle.bmc.usage.responses.ListResourceQuotaResponse;
import com.oracle.bmc.usage.responses.ListResourcesResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesClient
extends BaseSyncClient
implements Resources {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCES").serviceEndpointPrefix("").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesClient.class);
    private final ResourcesPaginators paginators = new ResourcesPaginators(this);

    ResourcesClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ListResourceQuotaResponse listResourceQuota(ListResourceQuotaRequest request) {
        Objects.requireNonNull(request.getServiceName(), "serviceName is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResourceQuotaResponse)this.clientCall(request, ListResourceQuotaResponse::builder).logger(LOG, "listResourceQuota").serviceDetails("Resources", "ListResourceQuota", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/ResourceQuotumSummary/ListResourceQuota").method(Method.GET).requestBuilder(ListResourceQuotaRequest::builder).basePath("/20190111").appendPathParam("resources").appendPathParam("quota").appendQueryParam("serviceName", (Object)request.getServiceName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("serviceEntitlement", (Object)request.getServiceEntitlement()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ResourceQuotumCollection.class, ListResourceQuotaResponse.Builder::resourceQuotumCollection).handleResponseHeaderString("opc-next-page", ListResourceQuotaResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListResourceQuotaResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListResourcesResponse listResources(ListResourcesRequest request) {
        Objects.requireNonNull(request.getServiceName(), "serviceName is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListResourcesResponse)this.clientCall(request, ListResourcesResponse::builder).logger(LOG, "listResources").serviceDetails("Resources", "ListResources", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/ResourceSummary/ListResources").method(Method.GET).requestBuilder(ListResourcesRequest::builder).basePath("/20190111").appendPathParam("resources").appendQueryParam("serviceName", (Object)request.getServiceName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("entitlementId", (Object)request.getEntitlementId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ResourcesCollection.class, ListResourcesResponse.Builder::resourcesCollection).handleResponseHeaderString("opc-next-page", ListResourcesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListResourcesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResourcesPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ResourcesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ResourcesClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ResourcesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ResourcesClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ResourcesClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ResourcesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ResourcesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ResourcesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ResourcesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ResourcesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ResourcesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ResourcesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ResourcesClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ResourcesClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourcesClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "usage";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"usage");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ResourcesClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ResourcesClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

