/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.usage.Resources;
import com.oracle.bmc.usage.model.ResourceQuotumSummary;
import com.oracle.bmc.usage.model.ResourceSummary;
import com.oracle.bmc.usage.requests.ListResourceQuotaRequest;
import com.oracle.bmc.usage.requests.ListResourcesRequest;
import com.oracle.bmc.usage.responses.ListResourceQuotaResponse;
import com.oracle.bmc.usage.responses.ListResourcesResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ResourcesPaginators {
    private final Resources client;

    public ResourcesPaginators(Resources client) {
        this.client = client;
    }

    public Iterable<ListResourceQuotaResponse> listResourceQuotaResponseIterator(final ListResourceQuotaRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResourceQuotaRequest.Builder>(){

            @Override
            public ListResourceQuotaRequest.Builder get() {
                return ListResourceQuotaRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceQuotaResponse, String>(){

            @Override
            public String apply(ListResourceQuotaResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceQuotaRequest.Builder>, ListResourceQuotaRequest>(){

            @Override
            public ListResourceQuotaRequest apply(RequestBuilderAndToken<ListResourceQuotaRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceQuotaRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceQuotaRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceQuotaRequest, ListResourceQuotaResponse>(){

            @Override
            public ListResourceQuotaResponse apply(ListResourceQuotaRequest request) {
                return ResourcesPaginators.this.client.listResourceQuota(request);
            }
        });
    }

    public Iterable<ResourceQuotumSummary> listResourceQuotaRecordIterator(final ListResourceQuotaRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResourceQuotaRequest.Builder>(){

            @Override
            public ListResourceQuotaRequest.Builder get() {
                return ListResourceQuotaRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceQuotaResponse, String>(){

            @Override
            public String apply(ListResourceQuotaResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceQuotaRequest.Builder>, ListResourceQuotaRequest>(){

            @Override
            public ListResourceQuotaRequest apply(RequestBuilderAndToken<ListResourceQuotaRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceQuotaRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceQuotaRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceQuotaRequest, ListResourceQuotaResponse>(){

            @Override
            public ListResourceQuotaResponse apply(ListResourceQuotaRequest request) {
                return ResourcesPaginators.this.client.listResourceQuota(request);
            }
        }, (Function)new Function<ListResourceQuotaResponse, List<ResourceQuotumSummary>>(){

            @Override
            public List<ResourceQuotumSummary> apply(ListResourceQuotaResponse response) {
                return response.getResourceQuotumCollection().getItems();
            }
        });
    }

    public Iterable<ListResourcesResponse> listResourcesResponseIterator(final ListResourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResourcesRequest.Builder>(){

            @Override
            public ListResourcesRequest.Builder get() {
                return ListResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourcesResponse, String>(){

            @Override
            public String apply(ListResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourcesRequest.Builder>, ListResourcesRequest>(){

            @Override
            public ListResourcesRequest apply(RequestBuilderAndToken<ListResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourcesRequest, ListResourcesResponse>(){

            @Override
            public ListResourcesResponse apply(ListResourcesRequest request) {
                return ResourcesPaginators.this.client.listResources(request);
            }
        });
    }

    public Iterable<ResourceSummary> listResourcesRecordIterator(final ListResourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResourcesRequest.Builder>(){

            @Override
            public ListResourcesRequest.Builder get() {
                return ListResourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourcesResponse, String>(){

            @Override
            public String apply(ListResourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourcesRequest.Builder>, ListResourcesRequest>(){

            @Override
            public ListResourcesRequest apply(RequestBuilderAndToken<ListResourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourcesRequest, ListResourcesResponse>(){

            @Override
            public ListResourcesResponse apply(ListResourcesRequest request) {
                return ResourcesPaginators.this.client.listResources(request);
            }
        }, (Function)new Function<ListResourcesResponse, List<ResourceSummary>>(){

            @Override
            public List<ResourceSummary> apply(ListResourcesResponse response) {
                return response.getResourcesCollection().getItems();
            }
        });
    }
}

