/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.usage.Usagelimits;
import com.oracle.bmc.usage.model.UsageLimitSummary;
import com.oracle.bmc.usage.requests.ListUsageLimitsRequest;
import com.oracle.bmc.usage.responses.ListUsageLimitsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class UsagelimitsPaginators {
    private final Usagelimits client;

    public UsagelimitsPaginators(Usagelimits client) {
        this.client = client;
    }

    public Iterable<ListUsageLimitsResponse> listUsageLimitsResponseIterator(final ListUsageLimitsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListUsageLimitsRequest.Builder>(){

            @Override
            public ListUsageLimitsRequest.Builder get() {
                return ListUsageLimitsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUsageLimitsResponse, String>(){

            @Override
            public String apply(ListUsageLimitsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUsageLimitsRequest.Builder>, ListUsageLimitsRequest>(){

            @Override
            public ListUsageLimitsRequest apply(RequestBuilderAndToken<ListUsageLimitsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListUsageLimitsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUsageLimitsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListUsageLimitsRequest, ListUsageLimitsResponse>(){

            @Override
            public ListUsageLimitsResponse apply(ListUsageLimitsRequest request) {
                return UsagelimitsPaginators.this.client.listUsageLimits(request);
            }
        });
    }

    public Iterable<UsageLimitSummary> listUsageLimitsRecordIterator(final ListUsageLimitsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListUsageLimitsRequest.Builder>(){

            @Override
            public ListUsageLimitsRequest.Builder get() {
                return ListUsageLimitsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUsageLimitsResponse, String>(){

            @Override
            public String apply(ListUsageLimitsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUsageLimitsRequest.Builder>, ListUsageLimitsRequest>(){

            @Override
            public ListUsageLimitsRequest apply(RequestBuilderAndToken<ListUsageLimitsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListUsageLimitsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUsageLimitsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListUsageLimitsRequest, ListUsageLimitsResponse>(){

            @Override
            public ListUsageLimitsResponse apply(ListUsageLimitsRequest request) {
                return UsagelimitsPaginators.this.client.listUsageLimits(request);
            }
        }, (Function)new Function<ListUsageLimitsResponse, List<UsageLimitSummary>>(){

            @Override
            public List<UsageLimitSummary> apply(ListUsageLimitsResponse response) {
                return response.getUsageLimitCollection().getItems();
            }
        });
    }
}

