/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RedemptionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeRedeemed")
    private final Date timeRedeemed;
    @JsonProperty(value="redemptionEmail")
    private final String redemptionEmail;
    @JsonProperty(value="redemptionCode")
    private final String redemptionCode;
    @JsonProperty(value="invoiceNumber")
    private final String invoiceNumber;
    @JsonProperty(value="invoiceTotalAmount")
    private final Double invoiceTotalAmount;
    @JsonProperty(value="invoiceCurrency")
    private final String invoiceCurrency;
    @JsonProperty(value="redeemedRewards")
    private final Float redeemedRewards;
    @JsonProperty(value="baseRewards")
    private final Float baseRewards;
    @JsonProperty(value="fxRate")
    private final Double fxRate;
    @JsonProperty(value="timeInvoiced")
    private final Date timeInvoiced;

    @Deprecated
    @ConstructorProperties(value={"timeRedeemed", "redemptionEmail", "redemptionCode", "invoiceNumber", "invoiceTotalAmount", "invoiceCurrency", "redeemedRewards", "baseRewards", "fxRate", "timeInvoiced"})
    public RedemptionSummary(Date timeRedeemed, String redemptionEmail, String redemptionCode, String invoiceNumber, Double invoiceTotalAmount, String invoiceCurrency, Float redeemedRewards, Float baseRewards, Double fxRate, Date timeInvoiced) {
        this.timeRedeemed = timeRedeemed;
        this.redemptionEmail = redemptionEmail;
        this.redemptionCode = redemptionCode;
        this.invoiceNumber = invoiceNumber;
        this.invoiceTotalAmount = invoiceTotalAmount;
        this.invoiceCurrency = invoiceCurrency;
        this.redeemedRewards = redeemedRewards;
        this.baseRewards = baseRewards;
        this.fxRate = fxRate;
        this.timeInvoiced = timeInvoiced;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeRedeemed() {
        return this.timeRedeemed;
    }

    public String getRedemptionEmail() {
        return this.redemptionEmail;
    }

    public String getRedemptionCode() {
        return this.redemptionCode;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public Double getInvoiceTotalAmount() {
        return this.invoiceTotalAmount;
    }

    public String getInvoiceCurrency() {
        return this.invoiceCurrency;
    }

    public Float getRedeemedRewards() {
        return this.redeemedRewards;
    }

    public Float getBaseRewards() {
        return this.baseRewards;
    }

    public Double getFxRate() {
        return this.fxRate;
    }

    public Date getTimeInvoiced() {
        return this.timeInvoiced;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RedemptionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("timeRedeemed=").append(String.valueOf(this.timeRedeemed));
        sb.append(", redemptionEmail=").append(String.valueOf(this.redemptionEmail));
        sb.append(", redemptionCode=").append(String.valueOf(this.redemptionCode));
        sb.append(", invoiceNumber=").append(String.valueOf(this.invoiceNumber));
        sb.append(", invoiceTotalAmount=").append(String.valueOf(this.invoiceTotalAmount));
        sb.append(", invoiceCurrency=").append(String.valueOf(this.invoiceCurrency));
        sb.append(", redeemedRewards=").append(String.valueOf(this.redeemedRewards));
        sb.append(", baseRewards=").append(String.valueOf(this.baseRewards));
        sb.append(", fxRate=").append(String.valueOf(this.fxRate));
        sb.append(", timeInvoiced=").append(String.valueOf(this.timeInvoiced));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedemptionSummary)) {
            return false;
        }
        RedemptionSummary other = (RedemptionSummary)((Object)o);
        return Objects.equals(this.timeRedeemed, other.timeRedeemed) && Objects.equals(this.redemptionEmail, other.redemptionEmail) && Objects.equals(this.redemptionCode, other.redemptionCode) && Objects.equals(this.invoiceNumber, other.invoiceNumber) && Objects.equals(this.invoiceTotalAmount, other.invoiceTotalAmount) && Objects.equals(this.invoiceCurrency, other.invoiceCurrency) && Objects.equals(this.redeemedRewards, other.redeemedRewards) && Objects.equals(this.baseRewards, other.baseRewards) && Objects.equals(this.fxRate, other.fxRate) && Objects.equals(this.timeInvoiced, other.timeInvoiced) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeRedeemed == null ? 43 : this.timeRedeemed.hashCode());
        result = result * 59 + (this.redemptionEmail == null ? 43 : this.redemptionEmail.hashCode());
        result = result * 59 + (this.redemptionCode == null ? 43 : this.redemptionCode.hashCode());
        result = result * 59 + (this.invoiceNumber == null ? 43 : this.invoiceNumber.hashCode());
        result = result * 59 + (this.invoiceTotalAmount == null ? 43 : this.invoiceTotalAmount.hashCode());
        result = result * 59 + (this.invoiceCurrency == null ? 43 : this.invoiceCurrency.hashCode());
        result = result * 59 + (this.redeemedRewards == null ? 43 : this.redeemedRewards.hashCode());
        result = result * 59 + (this.baseRewards == null ? 43 : this.baseRewards.hashCode());
        result = result * 59 + (this.fxRate == null ? 43 : this.fxRate.hashCode());
        result = result * 59 + (this.timeInvoiced == null ? 43 : this.timeInvoiced.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeRedeemed")
        private Date timeRedeemed;
        @JsonProperty(value="redemptionEmail")
        private String redemptionEmail;
        @JsonProperty(value="redemptionCode")
        private String redemptionCode;
        @JsonProperty(value="invoiceNumber")
        private String invoiceNumber;
        @JsonProperty(value="invoiceTotalAmount")
        private Double invoiceTotalAmount;
        @JsonProperty(value="invoiceCurrency")
        private String invoiceCurrency;
        @JsonProperty(value="redeemedRewards")
        private Float redeemedRewards;
        @JsonProperty(value="baseRewards")
        private Float baseRewards;
        @JsonProperty(value="fxRate")
        private Double fxRate;
        @JsonProperty(value="timeInvoiced")
        private Date timeInvoiced;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeRedeemed(Date timeRedeemed) {
            this.timeRedeemed = timeRedeemed;
            this.__explicitlySet__.add("timeRedeemed");
            return this;
        }

        public Builder redemptionEmail(String redemptionEmail) {
            this.redemptionEmail = redemptionEmail;
            this.__explicitlySet__.add("redemptionEmail");
            return this;
        }

        public Builder redemptionCode(String redemptionCode) {
            this.redemptionCode = redemptionCode;
            this.__explicitlySet__.add("redemptionCode");
            return this;
        }

        public Builder invoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            this.__explicitlySet__.add("invoiceNumber");
            return this;
        }

        public Builder invoiceTotalAmount(Double invoiceTotalAmount) {
            this.invoiceTotalAmount = invoiceTotalAmount;
            this.__explicitlySet__.add("invoiceTotalAmount");
            return this;
        }

        public Builder invoiceCurrency(String invoiceCurrency) {
            this.invoiceCurrency = invoiceCurrency;
            this.__explicitlySet__.add("invoiceCurrency");
            return this;
        }

        public Builder redeemedRewards(Float redeemedRewards) {
            this.redeemedRewards = redeemedRewards;
            this.__explicitlySet__.add("redeemedRewards");
            return this;
        }

        public Builder baseRewards(Float baseRewards) {
            this.baseRewards = baseRewards;
            this.__explicitlySet__.add("baseRewards");
            return this;
        }

        public Builder fxRate(Double fxRate) {
            this.fxRate = fxRate;
            this.__explicitlySet__.add("fxRate");
            return this;
        }

        public Builder timeInvoiced(Date timeInvoiced) {
            this.timeInvoiced = timeInvoiced;
            this.__explicitlySet__.add("timeInvoiced");
            return this;
        }

        public RedemptionSummary build() {
            RedemptionSummary model = new RedemptionSummary(this.timeRedeemed, this.redemptionEmail, this.redemptionCode, this.invoiceNumber, this.invoiceTotalAmount, this.invoiceCurrency, this.redeemedRewards, this.baseRewards, this.fxRate, this.timeInvoiced);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RedemptionSummary model) {
            if (model.wasPropertyExplicitlySet("timeRedeemed")) {
                this.timeRedeemed(model.getTimeRedeemed());
            }
            if (model.wasPropertyExplicitlySet("redemptionEmail")) {
                this.redemptionEmail(model.getRedemptionEmail());
            }
            if (model.wasPropertyExplicitlySet("redemptionCode")) {
                this.redemptionCode(model.getRedemptionCode());
            }
            if (model.wasPropertyExplicitlySet("invoiceNumber")) {
                this.invoiceNumber(model.getInvoiceNumber());
            }
            if (model.wasPropertyExplicitlySet("invoiceTotalAmount")) {
                this.invoiceTotalAmount(model.getInvoiceTotalAmount());
            }
            if (model.wasPropertyExplicitlySet("invoiceCurrency")) {
                this.invoiceCurrency(model.getInvoiceCurrency());
            }
            if (model.wasPropertyExplicitlySet("redeemedRewards")) {
                this.redeemedRewards(model.getRedeemedRewards());
            }
            if (model.wasPropertyExplicitlySet("baseRewards")) {
                this.baseRewards(model.getBaseRewards());
            }
            if (model.wasPropertyExplicitlySet("fxRate")) {
                this.fxRate(model.getFxRate());
            }
            if (model.wasPropertyExplicitlySet("timeInvoiced")) {
                this.timeInvoiced(model.getTimeInvoiced());
            }
            return this;
        }
    }
}

