/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.usage.model.SkuProducts;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dailyUnitDisplayName")
    private final String dailyUnitDisplayName;
    @JsonProperty(value="hourlyUnitDisplayName")
    private final String hourlyUnitDisplayName;
    @JsonProperty(value="rawUnitDisplayName")
    private final String rawUnitDisplayName;
    @JsonProperty(value="usageDataType")
    private final UsageDataType usageDataType;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="servicename")
    private final String servicename;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="instanceType")
    private final String instanceType;
    @JsonProperty(value="isPurchased")
    private final Boolean isPurchased;
    @JsonProperty(value="childResources")
    private final List<String> childResources;
    @JsonProperty(value="skus")
    private final List<SkuProducts> skus;

    @Deprecated
    @ConstructorProperties(value={"dailyUnitDisplayName", "hourlyUnitDisplayName", "rawUnitDisplayName", "usageDataType", "name", "servicename", "description", "instanceType", "isPurchased", "childResources", "skus"})
    public ResourceSummary(String dailyUnitDisplayName, String hourlyUnitDisplayName, String rawUnitDisplayName, UsageDataType usageDataType, String name, String servicename, String description, String instanceType, Boolean isPurchased, List<String> childResources, List<SkuProducts> skus) {
        this.dailyUnitDisplayName = dailyUnitDisplayName;
        this.hourlyUnitDisplayName = hourlyUnitDisplayName;
        this.rawUnitDisplayName = rawUnitDisplayName;
        this.usageDataType = usageDataType;
        this.name = name;
        this.servicename = servicename;
        this.description = description;
        this.instanceType = instanceType;
        this.isPurchased = isPurchased;
        this.childResources = childResources;
        this.skus = skus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDailyUnitDisplayName() {
        return this.dailyUnitDisplayName;
    }

    public String getHourlyUnitDisplayName() {
        return this.hourlyUnitDisplayName;
    }

    public String getRawUnitDisplayName() {
        return this.rawUnitDisplayName;
    }

    public UsageDataType getUsageDataType() {
        return this.usageDataType;
    }

    public String getName() {
        return this.name;
    }

    public String getServicename() {
        return this.servicename;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Boolean getIsPurchased() {
        return this.isPurchased;
    }

    public List<String> getChildResources() {
        return this.childResources;
    }

    public List<SkuProducts> getSkus() {
        return this.skus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("dailyUnitDisplayName=").append(String.valueOf(this.dailyUnitDisplayName));
        sb.append(", hourlyUnitDisplayName=").append(String.valueOf(this.hourlyUnitDisplayName));
        sb.append(", rawUnitDisplayName=").append(String.valueOf(this.rawUnitDisplayName));
        sb.append(", usageDataType=").append(String.valueOf((Object)this.usageDataType));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", servicename=").append(String.valueOf(this.servicename));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", instanceType=").append(String.valueOf(this.instanceType));
        sb.append(", isPurchased=").append(String.valueOf(this.isPurchased));
        sb.append(", childResources=").append(String.valueOf(this.childResources));
        sb.append(", skus=").append(String.valueOf(this.skus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceSummary)) {
            return false;
        }
        ResourceSummary other = (ResourceSummary)((Object)o);
        return Objects.equals(this.dailyUnitDisplayName, other.dailyUnitDisplayName) && Objects.equals(this.hourlyUnitDisplayName, other.hourlyUnitDisplayName) && Objects.equals(this.rawUnitDisplayName, other.rawUnitDisplayName) && Objects.equals((Object)this.usageDataType, (Object)other.usageDataType) && Objects.equals(this.name, other.name) && Objects.equals(this.servicename, other.servicename) && Objects.equals(this.description, other.description) && Objects.equals(this.instanceType, other.instanceType) && Objects.equals(this.isPurchased, other.isPurchased) && Objects.equals(this.childResources, other.childResources) && Objects.equals(this.skus, other.skus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dailyUnitDisplayName == null ? 43 : this.dailyUnitDisplayName.hashCode());
        result = result * 59 + (this.hourlyUnitDisplayName == null ? 43 : this.hourlyUnitDisplayName.hashCode());
        result = result * 59 + (this.rawUnitDisplayName == null ? 43 : this.rawUnitDisplayName.hashCode());
        result = result * 59 + (this.usageDataType == null ? 43 : this.usageDataType.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.servicename == null ? 43 : this.servicename.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.instanceType == null ? 43 : this.instanceType.hashCode());
        result = result * 59 + (this.isPurchased == null ? 43 : this.isPurchased.hashCode());
        result = result * 59 + (this.childResources == null ? 43 : this.childResources.hashCode());
        result = result * 59 + (this.skus == null ? 43 : this.skus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UsageDataType implements BmcEnum
    {
        Interval("INTERVAL"),
        PointData("POINT_DATA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UsageDataType> map;

        private UsageDataType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UsageDataType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UsageDataType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UsageDataType.class);
            map = new HashMap<String, UsageDataType>();
            for (UsageDataType v : UsageDataType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dailyUnitDisplayName")
        private String dailyUnitDisplayName;
        @JsonProperty(value="hourlyUnitDisplayName")
        private String hourlyUnitDisplayName;
        @JsonProperty(value="rawUnitDisplayName")
        private String rawUnitDisplayName;
        @JsonProperty(value="usageDataType")
        private UsageDataType usageDataType;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="servicename")
        private String servicename;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="instanceType")
        private String instanceType;
        @JsonProperty(value="isPurchased")
        private Boolean isPurchased;
        @JsonProperty(value="childResources")
        private List<String> childResources;
        @JsonProperty(value="skus")
        private List<SkuProducts> skus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dailyUnitDisplayName(String dailyUnitDisplayName) {
            this.dailyUnitDisplayName = dailyUnitDisplayName;
            this.__explicitlySet__.add("dailyUnitDisplayName");
            return this;
        }

        public Builder hourlyUnitDisplayName(String hourlyUnitDisplayName) {
            this.hourlyUnitDisplayName = hourlyUnitDisplayName;
            this.__explicitlySet__.add("hourlyUnitDisplayName");
            return this;
        }

        public Builder rawUnitDisplayName(String rawUnitDisplayName) {
            this.rawUnitDisplayName = rawUnitDisplayName;
            this.__explicitlySet__.add("rawUnitDisplayName");
            return this;
        }

        public Builder usageDataType(UsageDataType usageDataType) {
            this.usageDataType = usageDataType;
            this.__explicitlySet__.add("usageDataType");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder servicename(String servicename) {
            this.servicename = servicename;
            this.__explicitlySet__.add("servicename");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            this.__explicitlySet__.add("instanceType");
            return this;
        }

        public Builder isPurchased(Boolean isPurchased) {
            this.isPurchased = isPurchased;
            this.__explicitlySet__.add("isPurchased");
            return this;
        }

        public Builder childResources(List<String> childResources) {
            this.childResources = childResources;
            this.__explicitlySet__.add("childResources");
            return this;
        }

        public Builder skus(List<SkuProducts> skus) {
            this.skus = skus;
            this.__explicitlySet__.add("skus");
            return this;
        }

        public ResourceSummary build() {
            ResourceSummary model = new ResourceSummary(this.dailyUnitDisplayName, this.hourlyUnitDisplayName, this.rawUnitDisplayName, this.usageDataType, this.name, this.servicename, this.description, this.instanceType, this.isPurchased, this.childResources, this.skus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceSummary model) {
            if (model.wasPropertyExplicitlySet("dailyUnitDisplayName")) {
                this.dailyUnitDisplayName(model.getDailyUnitDisplayName());
            }
            if (model.wasPropertyExplicitlySet("hourlyUnitDisplayName")) {
                this.hourlyUnitDisplayName(model.getHourlyUnitDisplayName());
            }
            if (model.wasPropertyExplicitlySet("rawUnitDisplayName")) {
                this.rawUnitDisplayName(model.getRawUnitDisplayName());
            }
            if (model.wasPropertyExplicitlySet("usageDataType")) {
                this.usageDataType(model.getUsageDataType());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("servicename")) {
                this.servicename(model.getServicename());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("instanceType")) {
                this.instanceType(model.getInstanceType());
            }
            if (model.wasPropertyExplicitlySet("isPurchased")) {
                this.isPurchased(model.getIsPurchased());
            }
            if (model.wasPropertyExplicitlySet("childResources")) {
                this.childResources(model.getChildResources());
            }
            if (model.wasPropertyExplicitlySet("skus")) {
                this.skus(model.getSkus());
            }
            return this;
        }
    }
}

