/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceQuotumSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="isAllowed")
    private final Boolean isAllowed;
    @JsonProperty(value="limit")
    private final Double limit;
    @JsonProperty(value="balance")
    private final Double balance;
    @JsonProperty(value="isOverage")
    private final Boolean isOverage;
    @JsonProperty(value="purchasedLimit")
    private final Double purchasedLimit;
    @JsonProperty(value="service")
    private final String service;
    @JsonProperty(value="isDependency")
    private final Boolean isDependency;
    @JsonProperty(value="affectedResource")
    private final String affectedResource;

    @Deprecated
    @ConstructorProperties(value={"name", "isAllowed", "limit", "balance", "isOverage", "purchasedLimit", "service", "isDependency", "affectedResource"})
    public ResourceQuotumSummary(String name, Boolean isAllowed, Double limit, Double balance, Boolean isOverage, Double purchasedLimit, String service, Boolean isDependency, String affectedResource) {
        this.name = name;
        this.isAllowed = isAllowed;
        this.limit = limit;
        this.balance = balance;
        this.isOverage = isOverage;
        this.purchasedLimit = purchasedLimit;
        this.service = service;
        this.isDependency = isDependency;
        this.affectedResource = affectedResource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsAllowed() {
        return this.isAllowed;
    }

    public Double getLimit() {
        return this.limit;
    }

    public Double getBalance() {
        return this.balance;
    }

    public Boolean getIsOverage() {
        return this.isOverage;
    }

    public Double getPurchasedLimit() {
        return this.purchasedLimit;
    }

    public String getService() {
        return this.service;
    }

    public Boolean getIsDependency() {
        return this.isDependency;
    }

    public String getAffectedResource() {
        return this.affectedResource;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceQuotumSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", isAllowed=").append(String.valueOf(this.isAllowed));
        sb.append(", limit=").append(String.valueOf(this.limit));
        sb.append(", balance=").append(String.valueOf(this.balance));
        sb.append(", isOverage=").append(String.valueOf(this.isOverage));
        sb.append(", purchasedLimit=").append(String.valueOf(this.purchasedLimit));
        sb.append(", service=").append(String.valueOf(this.service));
        sb.append(", isDependency=").append(String.valueOf(this.isDependency));
        sb.append(", affectedResource=").append(String.valueOf(this.affectedResource));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceQuotumSummary)) {
            return false;
        }
        ResourceQuotumSummary other = (ResourceQuotumSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.isAllowed, other.isAllowed) && Objects.equals(this.limit, other.limit) && Objects.equals(this.balance, other.balance) && Objects.equals(this.isOverage, other.isOverage) && Objects.equals(this.purchasedLimit, other.purchasedLimit) && Objects.equals(this.service, other.service) && Objects.equals(this.isDependency, other.isDependency) && Objects.equals(this.affectedResource, other.affectedResource) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isAllowed == null ? 43 : this.isAllowed.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.balance == null ? 43 : this.balance.hashCode());
        result = result * 59 + (this.isOverage == null ? 43 : this.isOverage.hashCode());
        result = result * 59 + (this.purchasedLimit == null ? 43 : this.purchasedLimit.hashCode());
        result = result * 59 + (this.service == null ? 43 : this.service.hashCode());
        result = result * 59 + (this.isDependency == null ? 43 : this.isDependency.hashCode());
        result = result * 59 + (this.affectedResource == null ? 43 : this.affectedResource.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="isAllowed")
        private Boolean isAllowed;
        @JsonProperty(value="limit")
        private Double limit;
        @JsonProperty(value="balance")
        private Double balance;
        @JsonProperty(value="isOverage")
        private Boolean isOverage;
        @JsonProperty(value="purchasedLimit")
        private Double purchasedLimit;
        @JsonProperty(value="service")
        private String service;
        @JsonProperty(value="isDependency")
        private Boolean isDependency;
        @JsonProperty(value="affectedResource")
        private String affectedResource;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder isAllowed(Boolean isAllowed) {
            this.isAllowed = isAllowed;
            this.__explicitlySet__.add("isAllowed");
            return this;
        }

        public Builder limit(Double limit) {
            this.limit = limit;
            this.__explicitlySet__.add("limit");
            return this;
        }

        public Builder balance(Double balance) {
            this.balance = balance;
            this.__explicitlySet__.add("balance");
            return this;
        }

        public Builder isOverage(Boolean isOverage) {
            this.isOverage = isOverage;
            this.__explicitlySet__.add("isOverage");
            return this;
        }

        public Builder purchasedLimit(Double purchasedLimit) {
            this.purchasedLimit = purchasedLimit;
            this.__explicitlySet__.add("purchasedLimit");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }

        public Builder isDependency(Boolean isDependency) {
            this.isDependency = isDependency;
            this.__explicitlySet__.add("isDependency");
            return this;
        }

        public Builder affectedResource(String affectedResource) {
            this.affectedResource = affectedResource;
            this.__explicitlySet__.add("affectedResource");
            return this;
        }

        public ResourceQuotumSummary build() {
            ResourceQuotumSummary model = new ResourceQuotumSummary(this.name, this.isAllowed, this.limit, this.balance, this.isOverage, this.purchasedLimit, this.service, this.isDependency, this.affectedResource);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceQuotumSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("isAllowed")) {
                this.isAllowed(model.getIsAllowed());
            }
            if (model.wasPropertyExplicitlySet("limit")) {
                this.limit(model.getLimit());
            }
            if (model.wasPropertyExplicitlySet("balance")) {
                this.balance(model.getBalance());
            }
            if (model.wasPropertyExplicitlySet("isOverage")) {
                this.isOverage(model.getIsOverage());
            }
            if (model.wasPropertyExplicitlySet("purchasedLimit")) {
                this.purchasedLimit(model.getPurchasedLimit());
            }
            if (model.wasPropertyExplicitlySet("service")) {
                this.service(model.getService());
            }
            if (model.wasPropertyExplicitlySet("isDependency")) {
                this.isDependency(model.getIsDependency());
            }
            if (model.wasPropertyExplicitlySet("affectedResource")) {
                this.affectedResource(model.getAffectedResource());
            }
            return this;
        }
    }
}

