/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.usage.Usagelimits;
import com.oracle.bmc.usage.UsagelimitsPaginators;
import com.oracle.bmc.usage.model.UsageLimitCollection;
import com.oracle.bmc.usage.requests.ListUsageLimitsRequest;
import com.oracle.bmc.usage.responses.ListUsageLimitsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsagelimitsClient
extends BaseSyncClient
implements Usagelimits {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("USAGELIMITS").serviceEndpointPrefix("").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(UsagelimitsClient.class);
    private final UsagelimitsPaginators paginators = new UsagelimitsPaginators(this);

    UsagelimitsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ListUsageLimitsResponse listUsageLimits(ListUsageLimitsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSubscriptionId(), "subscriptionId is required");
        return (ListUsageLimitsResponse)this.clientCall(request, ListUsageLimitsResponse::builder).logger(LOG, "listUsageLimits").serviceDetails("Usagelimits", "ListUsageLimits", "https://docs.oracle.com/iaas/api/#/en/usage-proxy/20190111/UsageLimitSummary/ListUsageLimits").method(Method.GET).requestBuilder(ListUsageLimitsRequest::builder).basePath("/20190111").appendPathParam("usagelimits").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("limitType", (Object)request.getLimitType()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendQueryParam("serviceType", (Object)request.getServiceType()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(UsageLimitCollection.class, ListUsageLimitsResponse.Builder::usageLimitCollection).handleResponseHeaderString("opc-request-id", ListUsageLimitsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUsageLimitsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UsagelimitsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public UsagelimitsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)UsagelimitsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsagelimitsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(UsagelimitsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsagelimitsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)UsagelimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsagelimitsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)UsagelimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public UsagelimitsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)UsagelimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public UsagelimitsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)UsagelimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public UsagelimitsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)UsagelimitsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, UsagelimitsClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "usage";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"usage");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public UsagelimitsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new UsagelimitsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

