/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.usageapi.Usageapi;
import com.oracle.bmc.usageapi.UsageapiPaginators;
import com.oracle.bmc.usageapi.UsageapiWaiters;
import com.oracle.bmc.usageapi.model.ConfigurationAggregation;
import com.oracle.bmc.usageapi.model.CustomTable;
import com.oracle.bmc.usageapi.model.CustomTableCollection;
import com.oracle.bmc.usageapi.model.Query;
import com.oracle.bmc.usageapi.model.QueryCollection;
import com.oracle.bmc.usageapi.model.Schedule;
import com.oracle.bmc.usageapi.model.ScheduleCollection;
import com.oracle.bmc.usageapi.model.ScheduledRun;
import com.oracle.bmc.usageapi.model.ScheduledRunCollection;
import com.oracle.bmc.usageapi.model.UsageAggregation;
import com.oracle.bmc.usageapi.requests.CreateCustomTableRequest;
import com.oracle.bmc.usageapi.requests.CreateQueryRequest;
import com.oracle.bmc.usageapi.requests.CreateScheduleRequest;
import com.oracle.bmc.usageapi.requests.DeleteCustomTableRequest;
import com.oracle.bmc.usageapi.requests.DeleteQueryRequest;
import com.oracle.bmc.usageapi.requests.DeleteScheduleRequest;
import com.oracle.bmc.usageapi.requests.GetCustomTableRequest;
import com.oracle.bmc.usageapi.requests.GetQueryRequest;
import com.oracle.bmc.usageapi.requests.GetScheduleRequest;
import com.oracle.bmc.usageapi.requests.GetScheduledRunRequest;
import com.oracle.bmc.usageapi.requests.ListCustomTablesRequest;
import com.oracle.bmc.usageapi.requests.ListQueriesRequest;
import com.oracle.bmc.usageapi.requests.ListScheduledRunsRequest;
import com.oracle.bmc.usageapi.requests.ListSchedulesRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedConfigurationsRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedUsagesRequest;
import com.oracle.bmc.usageapi.requests.UpdateCustomTableRequest;
import com.oracle.bmc.usageapi.requests.UpdateQueryRequest;
import com.oracle.bmc.usageapi.requests.UpdateScheduleRequest;
import com.oracle.bmc.usageapi.responses.CreateCustomTableResponse;
import com.oracle.bmc.usageapi.responses.CreateQueryResponse;
import com.oracle.bmc.usageapi.responses.CreateScheduleResponse;
import com.oracle.bmc.usageapi.responses.DeleteCustomTableResponse;
import com.oracle.bmc.usageapi.responses.DeleteQueryResponse;
import com.oracle.bmc.usageapi.responses.DeleteScheduleResponse;
import com.oracle.bmc.usageapi.responses.GetCustomTableResponse;
import com.oracle.bmc.usageapi.responses.GetQueryResponse;
import com.oracle.bmc.usageapi.responses.GetScheduleResponse;
import com.oracle.bmc.usageapi.responses.GetScheduledRunResponse;
import com.oracle.bmc.usageapi.responses.ListCustomTablesResponse;
import com.oracle.bmc.usageapi.responses.ListQueriesResponse;
import com.oracle.bmc.usageapi.responses.ListScheduledRunsResponse;
import com.oracle.bmc.usageapi.responses.ListSchedulesResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedConfigurationsResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedUsagesResponse;
import com.oracle.bmc.usageapi.responses.UpdateCustomTableResponse;
import com.oracle.bmc.usageapi.responses.UpdateQueryResponse;
import com.oracle.bmc.usageapi.responses.UpdateScheduleResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageapiClient
extends BaseSyncClient
implements Usageapi {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("USAGEAPI").serviceEndpointPrefix("").serviceEndpointTemplate("https://usageapi.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(UsageapiClient.class);
    private final UsageapiWaiters waiters;
    private final UsageapiPaginators paginators;

    UsageapiClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Usageapi-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new UsageapiWaiters(executorService, this);
        this.paginators = new UsageapiPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateCustomTableResponse createCustomTable(CreateCustomTableRequest request) {
        Objects.requireNonNull(request.getCreateCustomTableDetails(), "createCustomTableDetails is required");
        return (CreateCustomTableResponse)this.clientCall(request, CreateCustomTableResponse::builder).logger(LOG, "createCustomTable").serviceDetails("Usageapi", "CreateCustomTable", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/CreateCustomTable").method(Method.POST).requestBuilder(CreateCustomTableRequest::builder).basePath("/20200107").appendPathParam("customTables").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CustomTable.class, CreateCustomTableResponse.Builder::customTable).handleResponseHeaderString("opc-request-id", CreateCustomTableResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateCustomTableResponse.Builder::etag).callSync();
    }

    @Override
    public CreateQueryResponse createQuery(CreateQueryRequest request) {
        Objects.requireNonNull(request.getCreateQueryDetails(), "createQueryDetails is required");
        return (CreateQueryResponse)this.clientCall(request, CreateQueryResponse::builder).logger(LOG, "createQuery").serviceDetails("Usageapi", "CreateQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/CreateQuery").method(Method.POST).requestBuilder(CreateQueryRequest::builder).basePath("/20200107").appendPathParam("queries").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Query.class, CreateQueryResponse.Builder::query).handleResponseHeaderString("opc-request-id", CreateQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateQueryResponse.Builder::etag).callSync();
    }

    @Override
    public CreateScheduleResponse createSchedule(CreateScheduleRequest request) {
        Objects.requireNonNull(request.getCreateScheduleDetails(), "createScheduleDetails is required");
        return (CreateScheduleResponse)this.clientCall(request, CreateScheduleResponse::builder).logger(LOG, "createSchedule").serviceDetails("Usageapi", "CreateSchedule", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/CreateSchedule").method(Method.POST).requestBuilder(CreateScheduleRequest::builder).basePath("/20200107").appendPathParam("schedules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Schedule.class, CreateScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", CreateScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateScheduleResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteCustomTableResponse deleteCustomTable(DeleteCustomTableRequest request) {
        Validate.notBlank((String)request.getCustomTableId(), (String)"customTableId must not be blank", (Object[])new Object[0]);
        return (DeleteCustomTableResponse)this.clientCall(request, DeleteCustomTableResponse::builder).logger(LOG, "deleteCustomTable").serviceDetails("Usageapi", "DeleteCustomTable", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/DeleteCustomTable").method(Method.DELETE).requestBuilder(DeleteCustomTableRequest::builder).basePath("/20200107").appendPathParam("customTables").appendPathParam(request.getCustomTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteCustomTableResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteQueryResponse deleteQuery(DeleteQueryRequest request) {
        Validate.notBlank((String)request.getQueryId(), (String)"queryId must not be blank", (Object[])new Object[0]);
        return (DeleteQueryResponse)this.clientCall(request, DeleteQueryResponse::builder).logger(LOG, "deleteQuery").serviceDetails("Usageapi", "DeleteQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/DeleteQuery").method(Method.DELETE).requestBuilder(DeleteQueryRequest::builder).basePath("/20200107").appendPathParam("queries").appendPathParam(request.getQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteQueryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest request) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return (DeleteScheduleResponse)this.clientCall(request, DeleteScheduleResponse::builder).logger(LOG, "deleteSchedule").serviceDetails("Usageapi", "DeleteSchedule", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/DeleteSchedule").method(Method.DELETE).requestBuilder(DeleteScheduleRequest::builder).basePath("/20200107").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCustomTableResponse getCustomTable(GetCustomTableRequest request) {
        Validate.notBlank((String)request.getCustomTableId(), (String)"customTableId must not be blank", (Object[])new Object[0]);
        return (GetCustomTableResponse)this.clientCall(request, GetCustomTableResponse::builder).logger(LOG, "getCustomTable").serviceDetails("Usageapi", "GetCustomTable", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/GetCustomTable").method(Method.GET).requestBuilder(GetCustomTableRequest::builder).basePath("/20200107").appendPathParam("customTables").appendPathParam(request.getCustomTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CustomTable.class, GetCustomTableResponse.Builder::customTable).handleResponseHeaderString("opc-request-id", GetCustomTableResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetCustomTableResponse.Builder::etag).callSync();
    }

    @Override
    public GetQueryResponse getQuery(GetQueryRequest request) {
        Validate.notBlank((String)request.getQueryId(), (String)"queryId must not be blank", (Object[])new Object[0]);
        return (GetQueryResponse)this.clientCall(request, GetQueryResponse::builder).logger(LOG, "getQuery").serviceDetails("Usageapi", "GetQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/GetQuery").method(Method.GET).requestBuilder(GetQueryRequest::builder).basePath("/20200107").appendPathParam("queries").appendPathParam(request.getQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Query.class, GetQueryResponse.Builder::query).handleResponseHeaderString("opc-request-id", GetQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetQueryResponse.Builder::etag).callSync();
    }

    @Override
    public GetScheduleResponse getSchedule(GetScheduleRequest request) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return (GetScheduleResponse)this.clientCall(request, GetScheduleResponse::builder).logger(LOG, "getSchedule").serviceDetails("Usageapi", "GetSchedule", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/GetSchedule").method(Method.GET).requestBuilder(GetScheduleRequest::builder).basePath("/20200107").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Schedule.class, GetScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", GetScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetScheduleResponse.Builder::etag).callSync();
    }

    @Override
    public GetScheduledRunResponse getScheduledRun(GetScheduledRunRequest request) {
        Validate.notBlank((String)request.getScheduledRunId(), (String)"scheduledRunId must not be blank", (Object[])new Object[0]);
        return (GetScheduledRunResponse)this.clientCall(request, GetScheduledRunResponse::builder).logger(LOG, "getScheduledRun").serviceDetails("Usageapi", "GetScheduledRun", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/ScheduledRun/GetScheduledRun").method(Method.GET).requestBuilder(GetScheduledRunRequest::builder).basePath("/20200107").appendPathParam("scheduledRuns").appendPathParam(request.getScheduledRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledRun.class, GetScheduledRunResponse.Builder::scheduledRun).handleResponseHeaderString("opc-request-id", GetScheduledRunResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetScheduledRunResponse.Builder::etag).callSync();
    }

    @Override
    public ListCustomTablesResponse listCustomTables(ListCustomTablesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSavedReportId(), "savedReportId is required");
        return (ListCustomTablesResponse)this.clientCall(request, ListCustomTablesResponse::builder).logger(LOG, "listCustomTables").serviceDetails("Usageapi", "ListCustomTables", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/ListCustomTables").method(Method.GET).requestBuilder(ListCustomTablesRequest::builder).basePath("/20200107").appendPathParam("customTables").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("savedReportId", (Object)request.getSavedReportId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CustomTableCollection.class, ListCustomTablesResponse.Builder::customTableCollection).handleResponseHeaderString("opc-request-id", ListCustomTablesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCustomTablesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListQueriesResponse listQueries(ListQueriesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListQueriesResponse)this.clientCall(request, ListQueriesResponse::builder).logger(LOG, "listQueries").serviceDetails("Usageapi", "ListQueries", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/ListQueries").method(Method.GET).requestBuilder(ListQueriesRequest::builder).basePath("/20200107").appendPathParam("queries").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(QueryCollection.class, ListQueriesResponse.Builder::queryCollection).handleResponseHeaderString("opc-request-id", ListQueriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListQueriesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListScheduledRunsResponse listScheduledRuns(ListScheduledRunsRequest request) {
        Objects.requireNonNull(request.getScheduleId(), "scheduleId is required");
        return (ListScheduledRunsResponse)this.clientCall(request, ListScheduledRunsResponse::builder).logger(LOG, "listScheduledRuns").serviceDetails("Usageapi", "ListScheduledRuns", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/ScheduledRun/ListScheduledRuns").method(Method.GET).requestBuilder(ListScheduledRunsRequest::builder).basePath("/20200107").appendPathParam("scheduledRuns").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("scheduleId", (Object)request.getScheduleId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledRunCollection.class, ListScheduledRunsResponse.Builder::scheduledRunCollection).handleResponseHeaderString("opc-request-id", ListScheduledRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScheduledRunsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListSchedulesResponse listSchedules(ListSchedulesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSchedulesResponse)this.clientCall(request, ListSchedulesResponse::builder).logger(LOG, "listSchedules").serviceDetails("Usageapi", "ListSchedules", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/ListSchedules").method(Method.GET).requestBuilder(ListSchedulesRequest::builder).basePath("/20200107").appendPathParam("schedules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduleCollection.class, ListSchedulesResponse.Builder::scheduleCollection).handleResponseHeaderString("opc-request-id", ListSchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSchedulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RequestSummarizedConfigurationsResponse requestSummarizedConfigurations(RequestSummarizedConfigurationsRequest request) {
        Objects.requireNonNull(request.getTenantId(), "tenantId is required");
        return (RequestSummarizedConfigurationsResponse)this.clientCall(request, RequestSummarizedConfigurationsResponse::builder).logger(LOG, "requestSummarizedConfigurations").serviceDetails("Usageapi", "RequestSummarizedConfigurations", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Configuration/RequestSummarizedConfigurations").method(Method.GET).requestBuilder(RequestSummarizedConfigurationsRequest::builder).basePath("/20200107").appendPathParam("configuration").appendQueryParam("tenantId", (Object)request.getTenantId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfigurationAggregation.class, RequestSummarizedConfigurationsResponse.Builder::configurationAggregation).handleResponseHeaderString("opc-request-id", RequestSummarizedConfigurationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RequestSummarizedUsagesResponse requestSummarizedUsages(RequestSummarizedUsagesRequest request) {
        Objects.requireNonNull(request.getRequestSummarizedUsagesDetails(), "requestSummarizedUsagesDetails is required");
        return (RequestSummarizedUsagesResponse)this.clientCall(request, RequestSummarizedUsagesResponse::builder).logger(LOG, "requestSummarizedUsages").serviceDetails("Usageapi", "RequestSummarizedUsages", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/UsageSummary/RequestSummarizedUsages").method(Method.POST).requestBuilder(RequestSummarizedUsagesRequest::builder).basePath("/20200107").appendPathParam("usage").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UsageAggregation.class, RequestSummarizedUsagesResponse.Builder::usageAggregation).handleResponseHeaderString("opc-request-id", RequestSummarizedUsagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedUsagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateCustomTableResponse updateCustomTable(UpdateCustomTableRequest request) {
        Objects.requireNonNull(request.getUpdateCustomTableDetails(), "updateCustomTableDetails is required");
        Validate.notBlank((String)request.getCustomTableId(), (String)"customTableId must not be blank", (Object[])new Object[0]);
        return (UpdateCustomTableResponse)this.clientCall(request, UpdateCustomTableResponse::builder).logger(LOG, "updateCustomTable").serviceDetails("Usageapi", "UpdateCustomTable", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/UpdateCustomTable").method(Method.PUT).requestBuilder(UpdateCustomTableRequest::builder).basePath("/20200107").appendPathParam("customTables").appendPathParam(request.getCustomTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(CustomTable.class, UpdateCustomTableResponse.Builder::customTable).handleResponseHeaderString("opc-request-id", UpdateCustomTableResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateCustomTableResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateQueryResponse updateQuery(UpdateQueryRequest request) {
        Objects.requireNonNull(request.getUpdateQueryDetails(), "updateQueryDetails is required");
        Validate.notBlank((String)request.getQueryId(), (String)"queryId must not be blank", (Object[])new Object[0]);
        return (UpdateQueryResponse)this.clientCall(request, UpdateQueryResponse::builder).logger(LOG, "updateQuery").serviceDetails("Usageapi", "UpdateQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/UpdateQuery").method(Method.PUT).requestBuilder(UpdateQueryRequest::builder).basePath("/20200107").appendPathParam("queries").appendPathParam(request.getQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Query.class, UpdateQueryResponse.Builder::query).handleResponseHeaderString("opc-request-id", UpdateQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateQueryResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateScheduleResponse updateSchedule(UpdateScheduleRequest request) {
        Objects.requireNonNull(request.getUpdateScheduleDetails(), "updateScheduleDetails is required");
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return (UpdateScheduleResponse)this.clientCall(request, UpdateScheduleResponse::builder).logger(LOG, "updateSchedule").serviceDetails("Usageapi", "UpdateSchedule", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/UpdateSchedule").method(Method.PUT).requestBuilder(UpdateScheduleRequest::builder).basePath("/20200107").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Schedule.class, UpdateScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", UpdateScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateScheduleResponse.Builder::etag).callSync();
    }

    @Override
    public UsageapiWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public UsageapiPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public UsageapiClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)UsageapiClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsageapiClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(UsageapiClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsageapiClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)UsageapiClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)UsageapiClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)UsageapiClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)UsageapiClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)UsageapiClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public UsageapiClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)UsageapiClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, UsageapiClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public UsageapiClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new UsageapiClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

