/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.usageapi.model.DateRange;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dateRangeType")
@JsonFilter(value="explicitlySetFilter")
public final class DynamicDateRange
extends DateRange {
    @JsonProperty(value="dynamicDateRangeType")
    private final DynamicDateRangeType dynamicDateRangeType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DynamicDateRange(DynamicDateRangeType dynamicDateRangeType) {
        this.dynamicDateRangeType = dynamicDateRangeType;
    }

    public DynamicDateRangeType getDynamicDateRangeType() {
        return this.dynamicDateRangeType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DynamicDateRange(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dynamicDateRangeType=").append(String.valueOf((Object)this.dynamicDateRangeType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicDateRange)) {
            return false;
        }
        DynamicDateRange other = (DynamicDateRange)((Object)o);
        return Objects.equals((Object)this.dynamicDateRangeType, (Object)other.dynamicDateRangeType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dynamicDateRangeType == null ? 43 : this.dynamicDateRangeType.hashCode());
        return result;
    }

    public static enum DynamicDateRangeType implements BmcEnum
    {
        Last7Days("LAST_7_DAYS"),
        Last10Days("LAST_10_DAYS"),
        LastCalendarWeek("LAST_CALENDAR_WEEK"),
        LastCalendarMonth("LAST_CALENDAR_MONTH"),
        Last2CalendarMonths("LAST_2_CALENDAR_MONTHS"),
        Last3CalendarMonths("LAST_3_CALENDAR_MONTHS"),
        Last6CalendarMonths("LAST_6_CALENDAR_MONTHS"),
        Last30Days("LAST_30_DAYS"),
        MonthToDate("MONTH_TO_DATE"),
        LastYear("LAST_YEAR"),
        YearTodate("YEAR_TODATE"),
        All("ALL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DynamicDateRangeType> map;

        private DynamicDateRangeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DynamicDateRangeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DynamicDateRangeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DynamicDateRangeType.class);
            map = new HashMap<String, DynamicDateRangeType>();
            for (DynamicDateRangeType v : DynamicDateRangeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dynamicDateRangeType")
        private DynamicDateRangeType dynamicDateRangeType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dynamicDateRangeType(DynamicDateRangeType dynamicDateRangeType) {
            this.dynamicDateRangeType = dynamicDateRangeType;
            this.__explicitlySet__.add("dynamicDateRangeType");
            return this;
        }

        public DynamicDateRange build() {
            DynamicDateRange model = new DynamicDateRange(this.dynamicDateRangeType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DynamicDateRange model) {
            if (model.wasPropertyExplicitlySet("dynamicDateRangeType")) {
                this.dynamicDateRangeType(model.getDynamicDateRangeType());
            }
            return this;
        }
    }
}

