/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.usageapi.model.CostAnalysisUI;
import com.oracle.bmc.usageapi.model.ReportQuery;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="reportQuery")
    private final ReportQuery reportQuery;
    @JsonProperty(value="costAnalysisUI")
    private final CostAnalysisUI costAnalysisUI;
    @JsonProperty(value="version")
    private final BigDecimal version;

    @Deprecated
    @ConstructorProperties(value={"displayName", "reportQuery", "costAnalysisUI", "version"})
    public QueryDefinition(String displayName, ReportQuery reportQuery, CostAnalysisUI costAnalysisUI, BigDecimal version) {
        this.displayName = displayName;
        this.reportQuery = reportQuery;
        this.costAnalysisUI = costAnalysisUI;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ReportQuery getReportQuery() {
        return this.reportQuery;
    }

    public CostAnalysisUI getCostAnalysisUI() {
        return this.costAnalysisUI;
    }

    public BigDecimal getVersion() {
        return this.version;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", reportQuery=").append(String.valueOf((Object)this.reportQuery));
        sb.append(", costAnalysisUI=").append(String.valueOf((Object)this.costAnalysisUI));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryDefinition)) {
            return false;
        }
        QueryDefinition other = (QueryDefinition)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.reportQuery, (Object)other.reportQuery) && Objects.equals((Object)this.costAnalysisUI, (Object)other.costAnalysisUI) && Objects.equals(this.version, other.version) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.reportQuery == null ? 43 : this.reportQuery.hashCode());
        result = result * 59 + (this.costAnalysisUI == null ? 43 : this.costAnalysisUI.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="reportQuery")
        private ReportQuery reportQuery;
        @JsonProperty(value="costAnalysisUI")
        private CostAnalysisUI costAnalysisUI;
        @JsonProperty(value="version")
        private BigDecimal version;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder reportQuery(ReportQuery reportQuery) {
            this.reportQuery = reportQuery;
            this.__explicitlySet__.add("reportQuery");
            return this;
        }

        public Builder costAnalysisUI(CostAnalysisUI costAnalysisUI) {
            this.costAnalysisUI = costAnalysisUI;
            this.__explicitlySet__.add("costAnalysisUI");
            return this;
        }

        public Builder version(BigDecimal version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public QueryDefinition build() {
            QueryDefinition model = new QueryDefinition(this.displayName, this.reportQuery, this.costAnalysisUI, this.version);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryDefinition model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("reportQuery")) {
                this.reportQuery(model.getReportQuery());
            }
            if (model.wasPropertyExplicitlySet("costAnalysisUI")) {
                this.costAnalysisUI(model.getCostAnalysisUI());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            return this;
        }
    }
}

