/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetScheduledRunRequest
extends BmcRequest<Void> {
    private String scheduledRunId;
    private String opcRequestId;

    public String getScheduledRunId() {
        return this.scheduledRunId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().scheduledRunId(this.scheduledRunId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",scheduledRunId=").append(String.valueOf(this.scheduledRunId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetScheduledRunRequest)) {
            return false;
        }
        GetScheduledRunRequest other = (GetScheduledRunRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.scheduledRunId, other.scheduledRunId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.scheduledRunId == null ? 43 : this.scheduledRunId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetScheduledRunRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String scheduledRunId = null;
        private String opcRequestId = null;

        public Builder scheduledRunId(String scheduledRunId) {
            this.scheduledRunId = scheduledRunId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetScheduledRunRequest o) {
            this.scheduledRunId(o.getScheduledRunId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetScheduledRunRequest build() {
            GetScheduledRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetScheduledRunRequest buildWithoutInvocationCallback() {
            GetScheduledRunRequest request = new GetScheduledRunRequest();
            request.scheduledRunId = this.scheduledRunId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

