/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi;

import com.oracle.bmc.usageapi.Usageapi;
import com.oracle.bmc.usageapi.model.Schedule;
import com.oracle.bmc.usageapi.model.ScheduledRun;
import com.oracle.bmc.usageapi.requests.GetScheduleRequest;
import com.oracle.bmc.usageapi.requests.GetScheduledRunRequest;
import com.oracle.bmc.usageapi.responses.GetScheduleResponse;
import com.oracle.bmc.usageapi.responses.GetScheduledRunResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class UsageapiWaiters {
    private final ExecutorService executorService;
    private final Usageapi client;

    public UsageapiWaiters(ExecutorService executorService, Usageapi client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(GetScheduleRequest request, Schedule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSchedule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(GetScheduleRequest request, Schedule.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(GetScheduleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Schedule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetScheduleRequest, GetScheduleResponse> forSchedule(BmcGenericWaiter waiter, GetScheduleRequest request, Schedule.LifecycleState ... targetStates) {
        final HashSet<Schedule.LifecycleState> targetStatesSet = new HashSet<Schedule.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetScheduleRequest, GetScheduleResponse>(){

            @Override
            public GetScheduleResponse apply(GetScheduleRequest request) {
                return UsageapiWaiters.this.client.getSchedule(request);
            }
        }, (Predicate)new Predicate<GetScheduleResponse>(){

            @Override
            public boolean test(GetScheduleResponse response) {
                return targetStatesSet.contains((Object)response.getSchedule().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetScheduledRunRequest, GetScheduledRunResponse> forScheduledRun(GetScheduledRunRequest request, ScheduledRun.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forScheduledRun(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetScheduledRunRequest, GetScheduledRunResponse> forScheduledRun(GetScheduledRunRequest request, ScheduledRun.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forScheduledRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetScheduledRunRequest, GetScheduledRunResponse> forScheduledRun(GetScheduledRunRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ScheduledRun.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forScheduledRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetScheduledRunRequest, GetScheduledRunResponse> forScheduledRun(BmcGenericWaiter waiter, GetScheduledRunRequest request, ScheduledRun.LifecycleState ... targetStates) {
        final HashSet<ScheduledRun.LifecycleState> targetStatesSet = new HashSet<ScheduledRun.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetScheduledRunRequest, GetScheduledRunResponse>(){

            @Override
            public GetScheduledRunResponse apply(GetScheduledRunRequest request) {
                return UsageapiWaiters.this.client.getScheduledRun(request);
            }
        }, (Predicate)new Predicate<GetScheduledRunResponse>(){

            @Override
            public boolean test(GetScheduledRunResponse response) {
                return targetStatesSet.contains((Object)response.getScheduledRun().getLifecycleState());
            }
        }, false), (Object)request);
    }
}

