/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.usageapi.model.Filter;
import com.oracle.bmc.usageapi.model.Tag;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UsageCarbonEmissionsReportQuery
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tenantId")
    private final String tenantId;
    @JsonProperty(value="timeUsageStarted")
    private final Date timeUsageStarted;
    @JsonProperty(value="timeUsageEnded")
    private final Date timeUsageEnded;
    @JsonProperty(value="isAggregateByTime")
    private final Boolean isAggregateByTime;
    @JsonProperty(value="groupBy")
    private final List<String> groupBy;
    @JsonProperty(value="groupByTag")
    private final List<Tag> groupByTag;
    @JsonProperty(value="compartmentDepth")
    private final Integer compartmentDepth;
    @JsonProperty(value="filter")
    private final Filter filter;
    @JsonProperty(value="dateRangeName")
    private final DateRangeName dateRangeName;

    @Deprecated
    @ConstructorProperties(value={"tenantId", "timeUsageStarted", "timeUsageEnded", "isAggregateByTime", "groupBy", "groupByTag", "compartmentDepth", "filter", "dateRangeName"})
    public UsageCarbonEmissionsReportQuery(String tenantId, Date timeUsageStarted, Date timeUsageEnded, Boolean isAggregateByTime, List<String> groupBy, List<Tag> groupByTag, Integer compartmentDepth, Filter filter, DateRangeName dateRangeName) {
        this.tenantId = tenantId;
        this.timeUsageStarted = timeUsageStarted;
        this.timeUsageEnded = timeUsageEnded;
        this.isAggregateByTime = isAggregateByTime;
        this.groupBy = groupBy;
        this.groupByTag = groupByTag;
        this.compartmentDepth = compartmentDepth;
        this.filter = filter;
        this.dateRangeName = dateRangeName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Date getTimeUsageStarted() {
        return this.timeUsageStarted;
    }

    public Date getTimeUsageEnded() {
        return this.timeUsageEnded;
    }

    public Boolean getIsAggregateByTime() {
        return this.isAggregateByTime;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public List<Tag> getGroupByTag() {
        return this.groupByTag;
    }

    public Integer getCompartmentDepth() {
        return this.compartmentDepth;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public DateRangeName getDateRangeName() {
        return this.dateRangeName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UsageCarbonEmissionsReportQuery(");
        sb.append("super=").append(super.toString());
        sb.append("tenantId=").append(String.valueOf(this.tenantId));
        sb.append(", timeUsageStarted=").append(String.valueOf(this.timeUsageStarted));
        sb.append(", timeUsageEnded=").append(String.valueOf(this.timeUsageEnded));
        sb.append(", isAggregateByTime=").append(String.valueOf(this.isAggregateByTime));
        sb.append(", groupBy=").append(String.valueOf(this.groupBy));
        sb.append(", groupByTag=").append(String.valueOf(this.groupByTag));
        sb.append(", compartmentDepth=").append(String.valueOf(this.compartmentDepth));
        sb.append(", filter=").append(String.valueOf((Object)this.filter));
        sb.append(", dateRangeName=").append(String.valueOf((Object)this.dateRangeName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UsageCarbonEmissionsReportQuery)) {
            return false;
        }
        UsageCarbonEmissionsReportQuery other = (UsageCarbonEmissionsReportQuery)((Object)o);
        return Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.timeUsageStarted, other.timeUsageStarted) && Objects.equals(this.timeUsageEnded, other.timeUsageEnded) && Objects.equals(this.isAggregateByTime, other.isAggregateByTime) && Objects.equals(this.groupBy, other.groupBy) && Objects.equals(this.groupByTag, other.groupByTag) && Objects.equals(this.compartmentDepth, other.compartmentDepth) && Objects.equals((Object)this.filter, (Object)other.filter) && Objects.equals((Object)this.dateRangeName, (Object)other.dateRangeName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.timeUsageStarted == null ? 43 : this.timeUsageStarted.hashCode());
        result = result * 59 + (this.timeUsageEnded == null ? 43 : this.timeUsageEnded.hashCode());
        result = result * 59 + (this.isAggregateByTime == null ? 43 : this.isAggregateByTime.hashCode());
        result = result * 59 + (this.groupBy == null ? 43 : this.groupBy.hashCode());
        result = result * 59 + (this.groupByTag == null ? 43 : this.groupByTag.hashCode());
        result = result * 59 + (this.compartmentDepth == null ? 43 : this.compartmentDepth.hashCode());
        result = result * 59 + (this.filter == null ? 43 : this.filter.hashCode());
        result = result * 59 + (this.dateRangeName == null ? 43 : this.dateRangeName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DateRangeName implements BmcEnum
    {
        LastTwoMonths("LAST_TWO_MONTHS"),
        LastThreeMonths("LAST_THREE_MONTHS"),
        LastSixMonths("LAST_SIX_MONTHS"),
        LastOneYear("LAST_ONE_YEAR"),
        Custom("CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DateRangeName> map;

        private DateRangeName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DateRangeName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DateRangeName', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DateRangeName.class);
            map = new HashMap<String, DateRangeName>();
            for (DateRangeName v : DateRangeName.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tenantId")
        private String tenantId;
        @JsonProperty(value="timeUsageStarted")
        private Date timeUsageStarted;
        @JsonProperty(value="timeUsageEnded")
        private Date timeUsageEnded;
        @JsonProperty(value="isAggregateByTime")
        private Boolean isAggregateByTime;
        @JsonProperty(value="groupBy")
        private List<String> groupBy;
        @JsonProperty(value="groupByTag")
        private List<Tag> groupByTag;
        @JsonProperty(value="compartmentDepth")
        private Integer compartmentDepth;
        @JsonProperty(value="filter")
        private Filter filter;
        @JsonProperty(value="dateRangeName")
        private DateRangeName dateRangeName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.__explicitlySet__.add("tenantId");
            return this;
        }

        public Builder timeUsageStarted(Date timeUsageStarted) {
            this.timeUsageStarted = timeUsageStarted;
            this.__explicitlySet__.add("timeUsageStarted");
            return this;
        }

        public Builder timeUsageEnded(Date timeUsageEnded) {
            this.timeUsageEnded = timeUsageEnded;
            this.__explicitlySet__.add("timeUsageEnded");
            return this;
        }

        public Builder isAggregateByTime(Boolean isAggregateByTime) {
            this.isAggregateByTime = isAggregateByTime;
            this.__explicitlySet__.add("isAggregateByTime");
            return this;
        }

        public Builder groupBy(List<String> groupBy) {
            this.groupBy = groupBy;
            this.__explicitlySet__.add("groupBy");
            return this;
        }

        public Builder groupByTag(List<Tag> groupByTag) {
            this.groupByTag = groupByTag;
            this.__explicitlySet__.add("groupByTag");
            return this;
        }

        public Builder compartmentDepth(Integer compartmentDepth) {
            this.compartmentDepth = compartmentDepth;
            this.__explicitlySet__.add("compartmentDepth");
            return this;
        }

        public Builder filter(Filter filter) {
            this.filter = filter;
            this.__explicitlySet__.add("filter");
            return this;
        }

        public Builder dateRangeName(DateRangeName dateRangeName) {
            this.dateRangeName = dateRangeName;
            this.__explicitlySet__.add("dateRangeName");
            return this;
        }

        public UsageCarbonEmissionsReportQuery build() {
            UsageCarbonEmissionsReportQuery model = new UsageCarbonEmissionsReportQuery(this.tenantId, this.timeUsageStarted, this.timeUsageEnded, this.isAggregateByTime, this.groupBy, this.groupByTag, this.compartmentDepth, this.filter, this.dateRangeName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UsageCarbonEmissionsReportQuery model) {
            if (model.wasPropertyExplicitlySet("tenantId")) {
                this.tenantId(model.getTenantId());
            }
            if (model.wasPropertyExplicitlySet("timeUsageStarted")) {
                this.timeUsageStarted(model.getTimeUsageStarted());
            }
            if (model.wasPropertyExplicitlySet("timeUsageEnded")) {
                this.timeUsageEnded(model.getTimeUsageEnded());
            }
            if (model.wasPropertyExplicitlySet("isAggregateByTime")) {
                this.isAggregateByTime(model.getIsAggregateByTime());
            }
            if (model.wasPropertyExplicitlySet("groupBy")) {
                this.groupBy(model.getGroupBy());
            }
            if (model.wasPropertyExplicitlySet("groupByTag")) {
                this.groupByTag(model.getGroupByTag());
            }
            if (model.wasPropertyExplicitlySet("compartmentDepth")) {
                this.compartmentDepth(model.getCompartmentDepth());
            }
            if (model.wasPropertyExplicitlySet("filter")) {
                this.filter(model.getFilter());
            }
            if (model.wasPropertyExplicitlySet("dateRangeName")) {
                this.dateRangeName(model.getDateRangeName());
            }
            return this;
        }
    }
}

