/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCustomTableRequest
extends BmcRequest<Void> {
    private String customTableId;
    private String opcRequestId;

    public String getCustomTableId() {
        return this.customTableId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().customTableId(this.customTableId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",customTableId=").append(String.valueOf(this.customTableId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCustomTableRequest)) {
            return false;
        }
        GetCustomTableRequest other = (GetCustomTableRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.customTableId, other.customTableId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.customTableId == null ? 43 : this.customTableId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCustomTableRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String customTableId = null;
        private String opcRequestId = null;

        public Builder customTableId(String customTableId) {
            this.customTableId = customTableId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCustomTableRequest o) {
            this.customTableId(o.getCustomTableId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCustomTableRequest build() {
            GetCustomTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCustomTableRequest buildWithoutInvocationCallback() {
            GetCustomTableRequest request = new GetCustomTableRequest();
            request.customTableId = this.customTableId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

