/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RequestCleanEnergyUsageRequest
extends BmcRequest<Void> {
    private String region;
    private String ad;
    private String opcRequestId;

    public String getRegion() {
        return this.region;
    }

    public String getAd() {
        return this.ad;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().region(this.region).ad(this.ad).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",region=").append(String.valueOf(this.region));
        sb.append(",ad=").append(String.valueOf(this.ad));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestCleanEnergyUsageRequest)) {
            return false;
        }
        RequestCleanEnergyUsageRequest other = (RequestCleanEnergyUsageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.region, other.region) && Objects.equals(this.ad, other.ad) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.ad == null ? 43 : this.ad.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestCleanEnergyUsageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String region = null;
        private String ad = null;
        private String opcRequestId = null;

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder ad(String ad) {
            this.ad = ad;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestCleanEnergyUsageRequest o) {
            this.region(o.getRegion());
            this.ad(o.getAd());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestCleanEnergyUsageRequest build() {
            RequestCleanEnergyUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RequestCleanEnergyUsageRequest buildWithoutInvocationCallback() {
            RequestCleanEnergyUsageRequest request = new RequestCleanEnergyUsageRequest();
            request.region = this.region;
            request.ad = this.ad;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

