/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CostAnalysisUI
extends ExplicitlySetBmcModel {
    @JsonProperty(value="graph")
    private final Graph graph;
    @JsonProperty(value="isCumulativeGraph")
    private final Boolean isCumulativeGraph;

    @Deprecated
    @ConstructorProperties(value={"graph", "isCumulativeGraph"})
    public CostAnalysisUI(Graph graph, Boolean isCumulativeGraph) {
        this.graph = graph;
        this.isCumulativeGraph = isCumulativeGraph;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Boolean getIsCumulativeGraph() {
        return this.isCumulativeGraph;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CostAnalysisUI(");
        sb.append("super=").append(super.toString());
        sb.append("graph=").append(String.valueOf((Object)this.graph));
        sb.append(", isCumulativeGraph=").append(String.valueOf(this.isCumulativeGraph));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CostAnalysisUI)) {
            return false;
        }
        CostAnalysisUI other = (CostAnalysisUI)((Object)o);
        return Objects.equals((Object)this.graph, (Object)other.graph) && Objects.equals(this.isCumulativeGraph, other.isCumulativeGraph) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.graph == null ? 43 : this.graph.hashCode());
        result = result * 59 + (this.isCumulativeGraph == null ? 43 : this.isCumulativeGraph.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Graph implements BmcEnum
    {
        Bars("BARS"),
        Lines("LINES"),
        StackedLines("STACKED_LINES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Graph> map;

        private Graph(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Graph create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Graph', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Graph.class);
            map = new HashMap<String, Graph>();
            for (Graph v : Graph.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="graph")
        private Graph graph;
        @JsonProperty(value="isCumulativeGraph")
        private Boolean isCumulativeGraph;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder graph(Graph graph) {
            this.graph = graph;
            this.__explicitlySet__.add("graph");
            return this;
        }

        public Builder isCumulativeGraph(Boolean isCumulativeGraph) {
            this.isCumulativeGraph = isCumulativeGraph;
            this.__explicitlySet__.add("isCumulativeGraph");
            return this;
        }

        public CostAnalysisUI build() {
            CostAnalysisUI model = new CostAnalysisUI(this.graph, this.isCumulativeGraph);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CostAnalysisUI model) {
            if (model.wasPropertyExplicitlySet("graph")) {
                this.graph(model.getGraph());
            }
            if (model.wasPropertyExplicitlySet("isCumulativeGraph")) {
                this.isCumulativeGraph(model.getIsCumulativeGraph());
            }
            return this;
        }
    }
}

