/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.usageapi.model.Dimension;
import com.oracle.bmc.usageapi.model.Tag;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Filter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operator")
    private final Operator operator;
    @JsonProperty(value="dimensions")
    private final List<Dimension> dimensions;
    @JsonProperty(value="tags")
    private final List<Tag> tags;
    @JsonProperty(value="filters")
    private final List<Filter> filters;

    @Deprecated
    @ConstructorProperties(value={"operator", "dimensions", "tags", "filters"})
    public Filter(Operator operator, List<Dimension> dimensions, List<Tag> tags, List<Filter> filters) {
        this.operator = operator;
        this.dimensions = dimensions;
        this.tags = tags;
        this.filters = filters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Filter(");
        sb.append("super=").append(super.toString());
        sb.append("operator=").append(String.valueOf((Object)this.operator));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", tags=").append(String.valueOf(this.tags));
        sb.append(", filters=").append(String.valueOf(this.filters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)((Object)o);
        return Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.tags, other.tags) && Objects.equals(this.filters, other.filters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.tags == null ? 43 : this.tags.hashCode());
        result = result * 59 + (this.filters == null ? 43 : this.filters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Operator implements BmcEnum
    {
        And("AND"),
        Not("NOT"),
        Or("OR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Operator> map;

        private Operator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Operator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Operator.class);
            map = new HashMap<String, Operator>();
            for (Operator v : Operator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operator")
        private Operator operator;
        @JsonProperty(value="dimensions")
        private List<Dimension> dimensions;
        @JsonProperty(value="tags")
        private List<Tag> tags;
        @JsonProperty(value="filters")
        private List<Filter> filters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operator(Operator operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Builder dimensions(List<Dimension> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder tags(List<Tag> tags) {
            this.tags = tags;
            this.__explicitlySet__.add("tags");
            return this;
        }

        public Builder filters(List<Filter> filters) {
            this.filters = filters;
            this.__explicitlySet__.add("filters");
            return this;
        }

        public Filter build() {
            Filter model = new Filter(this.operator, this.dimensions, this.tags, this.filters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Filter model) {
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("tags")) {
                this.tags(model.getTags());
            }
            if (model.wasPropertyExplicitlySet("filters")) {
                this.filters(model.getFilters());
            }
            return this;
        }
    }
}

