/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.usageapi.model.DateRange;
import com.oracle.bmc.usageapi.model.Filter;
import com.oracle.bmc.usageapi.model.Tag;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryProperties
extends ExplicitlySetBmcModel {
    @JsonProperty(value="groupBy")
    private final List<String> groupBy;
    @JsonProperty(value="groupByTag")
    private final List<Tag> groupByTag;
    @JsonProperty(value="filter")
    private final Filter filter;
    @JsonProperty(value="compartmentDepth")
    private final BigDecimal compartmentDepth;
    @JsonProperty(value="granularity")
    private final Granularity granularity;
    @JsonProperty(value="queryType")
    private final QueryType queryType;
    @JsonProperty(value="isAggregateByTime")
    private final Boolean isAggregateByTime;
    @JsonProperty(value="dateRange")
    private final DateRange dateRange;

    @Deprecated
    @ConstructorProperties(value={"groupBy", "groupByTag", "filter", "compartmentDepth", "granularity", "queryType", "isAggregateByTime", "dateRange"})
    public QueryProperties(List<String> groupBy, List<Tag> groupByTag, Filter filter, BigDecimal compartmentDepth, Granularity granularity, QueryType queryType, Boolean isAggregateByTime, DateRange dateRange) {
        this.groupBy = groupBy;
        this.groupByTag = groupByTag;
        this.filter = filter;
        this.compartmentDepth = compartmentDepth;
        this.granularity = granularity;
        this.queryType = queryType;
        this.isAggregateByTime = isAggregateByTime;
        this.dateRange = dateRange;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public List<Tag> getGroupByTag() {
        return this.groupByTag;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public BigDecimal getCompartmentDepth() {
        return this.compartmentDepth;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public Boolean getIsAggregateByTime() {
        return this.isAggregateByTime;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryProperties(");
        sb.append("super=").append(super.toString());
        sb.append("groupBy=").append(String.valueOf(this.groupBy));
        sb.append(", groupByTag=").append(String.valueOf(this.groupByTag));
        sb.append(", filter=").append(String.valueOf((Object)this.filter));
        sb.append(", compartmentDepth=").append(String.valueOf(this.compartmentDepth));
        sb.append(", granularity=").append(String.valueOf((Object)this.granularity));
        sb.append(", queryType=").append(String.valueOf((Object)this.queryType));
        sb.append(", isAggregateByTime=").append(String.valueOf(this.isAggregateByTime));
        sb.append(", dateRange=").append(String.valueOf((Object)this.dateRange));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryProperties)) {
            return false;
        }
        QueryProperties other = (QueryProperties)((Object)o);
        return Objects.equals(this.groupBy, other.groupBy) && Objects.equals(this.groupByTag, other.groupByTag) && Objects.equals((Object)this.filter, (Object)other.filter) && Objects.equals(this.compartmentDepth, other.compartmentDepth) && Objects.equals((Object)this.granularity, (Object)other.granularity) && Objects.equals((Object)this.queryType, (Object)other.queryType) && Objects.equals(this.isAggregateByTime, other.isAggregateByTime) && Objects.equals((Object)this.dateRange, (Object)other.dateRange) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.groupBy == null ? 43 : this.groupBy.hashCode());
        result = result * 59 + (this.groupByTag == null ? 43 : this.groupByTag.hashCode());
        result = result * 59 + (this.filter == null ? 43 : this.filter.hashCode());
        result = result * 59 + (this.compartmentDepth == null ? 43 : this.compartmentDepth.hashCode());
        result = result * 59 + (this.granularity == null ? 43 : this.granularity.hashCode());
        result = result * 59 + (this.queryType == null ? 43 : this.queryType.hashCode());
        result = result * 59 + (this.isAggregateByTime == null ? 43 : this.isAggregateByTime.hashCode());
        result = result * 59 + (this.dateRange == null ? 43 : this.dateRange.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum QueryType implements BmcEnum
    {
        Usage("USAGE"),
        Cost("COST"),
        UsageAndCost("USAGE_AND_COST"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, QueryType> map;

        private QueryType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static QueryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'QueryType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(QueryType.class);
            map = new HashMap<String, QueryType>();
            for (QueryType v : QueryType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Granularity implements BmcEnum
    {
        Daily("DAILY"),
        Monthly("MONTHLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Granularity> map;

        private Granularity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Granularity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Granularity', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Granularity.class);
            map = new HashMap<String, Granularity>();
            for (Granularity v : Granularity.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="groupBy")
        private List<String> groupBy;
        @JsonProperty(value="groupByTag")
        private List<Tag> groupByTag;
        @JsonProperty(value="filter")
        private Filter filter;
        @JsonProperty(value="compartmentDepth")
        private BigDecimal compartmentDepth;
        @JsonProperty(value="granularity")
        private Granularity granularity;
        @JsonProperty(value="queryType")
        private QueryType queryType;
        @JsonProperty(value="isAggregateByTime")
        private Boolean isAggregateByTime;
        @JsonProperty(value="dateRange")
        private DateRange dateRange;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder groupBy(List<String> groupBy) {
            this.groupBy = groupBy;
            this.__explicitlySet__.add("groupBy");
            return this;
        }

        public Builder groupByTag(List<Tag> groupByTag) {
            this.groupByTag = groupByTag;
            this.__explicitlySet__.add("groupByTag");
            return this;
        }

        public Builder filter(Filter filter) {
            this.filter = filter;
            this.__explicitlySet__.add("filter");
            return this;
        }

        public Builder compartmentDepth(BigDecimal compartmentDepth) {
            this.compartmentDepth = compartmentDepth;
            this.__explicitlySet__.add("compartmentDepth");
            return this;
        }

        public Builder granularity(Granularity granularity) {
            this.granularity = granularity;
            this.__explicitlySet__.add("granularity");
            return this;
        }

        public Builder queryType(QueryType queryType) {
            this.queryType = queryType;
            this.__explicitlySet__.add("queryType");
            return this;
        }

        public Builder isAggregateByTime(Boolean isAggregateByTime) {
            this.isAggregateByTime = isAggregateByTime;
            this.__explicitlySet__.add("isAggregateByTime");
            return this;
        }

        public Builder dateRange(DateRange dateRange) {
            this.dateRange = dateRange;
            this.__explicitlySet__.add("dateRange");
            return this;
        }

        public QueryProperties build() {
            QueryProperties model = new QueryProperties(this.groupBy, this.groupByTag, this.filter, this.compartmentDepth, this.granularity, this.queryType, this.isAggregateByTime, this.dateRange);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryProperties model) {
            if (model.wasPropertyExplicitlySet("groupBy")) {
                this.groupBy(model.getGroupBy());
            }
            if (model.wasPropertyExplicitlySet("groupByTag")) {
                this.groupByTag(model.getGroupByTag());
            }
            if (model.wasPropertyExplicitlySet("filter")) {
                this.filter(model.getFilter());
            }
            if (model.wasPropertyExplicitlySet("compartmentDepth")) {
                this.compartmentDepth(model.getCompartmentDepth());
            }
            if (model.wasPropertyExplicitlySet("granularity")) {
                this.granularity(model.getGranularity());
            }
            if (model.wasPropertyExplicitlySet("queryType")) {
                this.queryType(model.getQueryType());
            }
            if (model.wasPropertyExplicitlySet("isAggregateByTime")) {
                this.isAggregateByTime(model.getIsAggregateByTime());
            }
            if (model.wasPropertyExplicitlySet("dateRange")) {
                this.dateRange(model.getDateRange());
            }
            return this;
        }
    }
}

