/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RequestAverageCarbonEmissionRequest
extends BmcRequest<Void> {
    private String skuPartNumber;
    private String opcRequestId;

    public String getSkuPartNumber() {
        return this.skuPartNumber;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().skuPartNumber(this.skuPartNumber).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",skuPartNumber=").append(String.valueOf(this.skuPartNumber));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestAverageCarbonEmissionRequest)) {
            return false;
        }
        RequestAverageCarbonEmissionRequest other = (RequestAverageCarbonEmissionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.skuPartNumber, other.skuPartNumber) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.skuPartNumber == null ? 43 : this.skuPartNumber.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestAverageCarbonEmissionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String skuPartNumber = null;
        private String opcRequestId = null;

        public Builder skuPartNumber(String skuPartNumber) {
            this.skuPartNumber = skuPartNumber;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestAverageCarbonEmissionRequest o) {
            this.skuPartNumber(o.getSkuPartNumber());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestAverageCarbonEmissionRequest build() {
            RequestAverageCarbonEmissionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RequestAverageCarbonEmissionRequest buildWithoutInvocationCallback() {
            RequestAverageCarbonEmissionRequest request = new RequestAverageCarbonEmissionRequest();
            request.skuPartNumber = this.skuPartNumber;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

