/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.usageapi.model.UpdateQueryDetails;
import java.util.Objects;

public class UpdateQueryRequest
extends BmcRequest<UpdateQueryDetails> {
    private UpdateQueryDetails updateQueryDetails;
    private String queryId;
    private String opcRequestId;
    private String ifMatch;

    public UpdateQueryDetails getUpdateQueryDetails() {
        return this.updateQueryDetails;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateQueryDetails getBody$() {
        return this.updateQueryDetails;
    }

    public Builder toBuilder() {
        return new Builder().updateQueryDetails(this.updateQueryDetails).queryId(this.queryId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",updateQueryDetails=").append(String.valueOf((Object)this.updateQueryDetails));
        sb.append(",queryId=").append(String.valueOf(this.queryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateQueryRequest)) {
            return false;
        }
        UpdateQueryRequest other = (UpdateQueryRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.updateQueryDetails, (Object)other.updateQueryDetails) && Objects.equals(this.queryId, other.queryId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.updateQueryDetails == null ? 43 : this.updateQueryDetails.hashCode());
        result = result * 59 + (this.queryId == null ? 43 : this.queryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateQueryRequest, UpdateQueryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private UpdateQueryDetails updateQueryDetails = null;
        private String queryId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder updateQueryDetails(UpdateQueryDetails updateQueryDetails) {
            this.updateQueryDetails = updateQueryDetails;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateQueryRequest o) {
            this.updateQueryDetails(o.getUpdateQueryDetails());
            this.queryId(o.getQueryId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateQueryRequest build() {
            UpdateQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateQueryDetails body) {
            this.updateQueryDetails(body);
            return this;
        }

        public UpdateQueryRequest buildWithoutInvocationCallback() {
            UpdateQueryRequest request = new UpdateQueryRequest();
            request.updateQueryDetails = this.updateQueryDetails;
            request.queryId = this.queryId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

