/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.responses;

import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.usageapi.model.ScheduleCollection;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListSchedulesResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private ScheduleCollection scheduleCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public ScheduleCollection getScheduleCollection() {
        return this.scheduleCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "scheduleCollection"})
    private ListSchedulesResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, ScheduleCollection scheduleCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.scheduleCollection = scheduleCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",scheduleCollection=").append(String.valueOf((Object)this.scheduleCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSchedulesResponse)) {
            return false;
        }
        ListSchedulesResponse other = (ListSchedulesResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.scheduleCollection, (Object)other.scheduleCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.scheduleCollection == null ? 43 : this.scheduleCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListSchedulesResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private ScheduleCollection scheduleCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder scheduleCollection(ScheduleCollection scheduleCollection) {
            this.scheduleCollection = scheduleCollection;
            return this;
        }

        public Builder copy(ListSchedulesResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.scheduleCollection(o.getScheduleCollection());
            return this;
        }

        public ListSchedulesResponse build() {
            return new ListSchedulesResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.scheduleCollection);
        }
    }
}

