/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.usageapi.Usageapi;
import com.oracle.bmc.usageapi.model.CustomTableSummary;
import com.oracle.bmc.usageapi.model.EmailRecipientsGroupSummary;
import com.oracle.bmc.usageapi.model.QuerySummary;
import com.oracle.bmc.usageapi.model.ScheduleSummary;
import com.oracle.bmc.usageapi.model.ScheduledRunSummary;
import com.oracle.bmc.usageapi.model.UsageCarbonEmissionsQuerySummary;
import com.oracle.bmc.usageapi.requests.ListCustomTablesRequest;
import com.oracle.bmc.usageapi.requests.ListEmailRecipientsGroupsRequest;
import com.oracle.bmc.usageapi.requests.ListQueriesRequest;
import com.oracle.bmc.usageapi.requests.ListScheduledRunsRequest;
import com.oracle.bmc.usageapi.requests.ListSchedulesRequest;
import com.oracle.bmc.usageapi.requests.ListUsageCarbonEmissionsQueriesRequest;
import com.oracle.bmc.usageapi.responses.ListCustomTablesResponse;
import com.oracle.bmc.usageapi.responses.ListEmailRecipientsGroupsResponse;
import com.oracle.bmc.usageapi.responses.ListQueriesResponse;
import com.oracle.bmc.usageapi.responses.ListScheduledRunsResponse;
import com.oracle.bmc.usageapi.responses.ListSchedulesResponse;
import com.oracle.bmc.usageapi.responses.ListUsageCarbonEmissionsQueriesResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class UsageapiPaginators {
    private final Usageapi client;

    public UsageapiPaginators(Usageapi client) {
        this.client = client;
    }

    public Iterable<ListCustomTablesResponse> listCustomTablesResponseIterator(final ListCustomTablesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCustomTablesRequest.Builder>(){

            @Override
            public ListCustomTablesRequest.Builder get() {
                return ListCustomTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCustomTablesResponse, String>(){

            @Override
            public String apply(ListCustomTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCustomTablesRequest.Builder>, ListCustomTablesRequest>(){

            @Override
            public ListCustomTablesRequest apply(RequestBuilderAndToken<ListCustomTablesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCustomTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCustomTablesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCustomTablesRequest, ListCustomTablesResponse>(){

            @Override
            public ListCustomTablesResponse apply(ListCustomTablesRequest request) {
                return UsageapiPaginators.this.client.listCustomTables(request);
            }
        });
    }

    public Iterable<CustomTableSummary> listCustomTablesRecordIterator(final ListCustomTablesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCustomTablesRequest.Builder>(){

            @Override
            public ListCustomTablesRequest.Builder get() {
                return ListCustomTablesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCustomTablesResponse, String>(){

            @Override
            public String apply(ListCustomTablesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCustomTablesRequest.Builder>, ListCustomTablesRequest>(){

            @Override
            public ListCustomTablesRequest apply(RequestBuilderAndToken<ListCustomTablesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCustomTablesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCustomTablesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCustomTablesRequest, ListCustomTablesResponse>(){

            @Override
            public ListCustomTablesResponse apply(ListCustomTablesRequest request) {
                return UsageapiPaginators.this.client.listCustomTables(request);
            }
        }, (Function)new Function<ListCustomTablesResponse, List<CustomTableSummary>>(){

            @Override
            public List<CustomTableSummary> apply(ListCustomTablesResponse response) {
                return response.getCustomTableCollection().getItems();
            }
        });
    }

    public Iterable<ListEmailRecipientsGroupsResponse> listEmailRecipientsGroupsResponseIterator(final ListEmailRecipientsGroupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEmailRecipientsGroupsRequest.Builder>(){

            @Override
            public ListEmailRecipientsGroupsRequest.Builder get() {
                return ListEmailRecipientsGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEmailRecipientsGroupsResponse, String>(){

            @Override
            public String apply(ListEmailRecipientsGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEmailRecipientsGroupsRequest.Builder>, ListEmailRecipientsGroupsRequest>(){

            @Override
            public ListEmailRecipientsGroupsRequest apply(RequestBuilderAndToken<ListEmailRecipientsGroupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEmailRecipientsGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEmailRecipientsGroupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEmailRecipientsGroupsRequest, ListEmailRecipientsGroupsResponse>(){

            @Override
            public ListEmailRecipientsGroupsResponse apply(ListEmailRecipientsGroupsRequest request) {
                return UsageapiPaginators.this.client.listEmailRecipientsGroups(request);
            }
        });
    }

    public Iterable<EmailRecipientsGroupSummary> listEmailRecipientsGroupsRecordIterator(final ListEmailRecipientsGroupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEmailRecipientsGroupsRequest.Builder>(){

            @Override
            public ListEmailRecipientsGroupsRequest.Builder get() {
                return ListEmailRecipientsGroupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEmailRecipientsGroupsResponse, String>(){

            @Override
            public String apply(ListEmailRecipientsGroupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEmailRecipientsGroupsRequest.Builder>, ListEmailRecipientsGroupsRequest>(){

            @Override
            public ListEmailRecipientsGroupsRequest apply(RequestBuilderAndToken<ListEmailRecipientsGroupsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEmailRecipientsGroupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEmailRecipientsGroupsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEmailRecipientsGroupsRequest, ListEmailRecipientsGroupsResponse>(){

            @Override
            public ListEmailRecipientsGroupsResponse apply(ListEmailRecipientsGroupsRequest request) {
                return UsageapiPaginators.this.client.listEmailRecipientsGroups(request);
            }
        }, (Function)new Function<ListEmailRecipientsGroupsResponse, List<EmailRecipientsGroupSummary>>(){

            @Override
            public List<EmailRecipientsGroupSummary> apply(ListEmailRecipientsGroupsResponse response) {
                return response.getEmailRecipientsGroupCollection().getItems();
            }
        });
    }

    public Iterable<ListQueriesResponse> listQueriesResponseIterator(final ListQueriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListQueriesRequest.Builder>(){

            @Override
            public ListQueriesRequest.Builder get() {
                return ListQueriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQueriesResponse, String>(){

            @Override
            public String apply(ListQueriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQueriesRequest.Builder>, ListQueriesRequest>(){

            @Override
            public ListQueriesRequest apply(RequestBuilderAndToken<ListQueriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListQueriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQueriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListQueriesRequest, ListQueriesResponse>(){

            @Override
            public ListQueriesResponse apply(ListQueriesRequest request) {
                return UsageapiPaginators.this.client.listQueries(request);
            }
        });
    }

    public Iterable<QuerySummary> listQueriesRecordIterator(final ListQueriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListQueriesRequest.Builder>(){

            @Override
            public ListQueriesRequest.Builder get() {
                return ListQueriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQueriesResponse, String>(){

            @Override
            public String apply(ListQueriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQueriesRequest.Builder>, ListQueriesRequest>(){

            @Override
            public ListQueriesRequest apply(RequestBuilderAndToken<ListQueriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListQueriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQueriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListQueriesRequest, ListQueriesResponse>(){

            @Override
            public ListQueriesResponse apply(ListQueriesRequest request) {
                return UsageapiPaginators.this.client.listQueries(request);
            }
        }, (Function)new Function<ListQueriesResponse, List<QuerySummary>>(){

            @Override
            public List<QuerySummary> apply(ListQueriesResponse response) {
                return response.getQueryCollection().getItems();
            }
        });
    }

    public Iterable<ListScheduledRunsResponse> listScheduledRunsResponseIterator(final ListScheduledRunsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListScheduledRunsRequest.Builder>(){

            @Override
            public ListScheduledRunsRequest.Builder get() {
                return ListScheduledRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListScheduledRunsResponse, String>(){

            @Override
            public String apply(ListScheduledRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListScheduledRunsRequest.Builder>, ListScheduledRunsRequest>(){

            @Override
            public ListScheduledRunsRequest apply(RequestBuilderAndToken<ListScheduledRunsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListScheduledRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListScheduledRunsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListScheduledRunsRequest, ListScheduledRunsResponse>(){

            @Override
            public ListScheduledRunsResponse apply(ListScheduledRunsRequest request) {
                return UsageapiPaginators.this.client.listScheduledRuns(request);
            }
        });
    }

    public Iterable<ScheduledRunSummary> listScheduledRunsRecordIterator(final ListScheduledRunsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListScheduledRunsRequest.Builder>(){

            @Override
            public ListScheduledRunsRequest.Builder get() {
                return ListScheduledRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListScheduledRunsResponse, String>(){

            @Override
            public String apply(ListScheduledRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListScheduledRunsRequest.Builder>, ListScheduledRunsRequest>(){

            @Override
            public ListScheduledRunsRequest apply(RequestBuilderAndToken<ListScheduledRunsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListScheduledRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListScheduledRunsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListScheduledRunsRequest, ListScheduledRunsResponse>(){

            @Override
            public ListScheduledRunsResponse apply(ListScheduledRunsRequest request) {
                return UsageapiPaginators.this.client.listScheduledRuns(request);
            }
        }, (Function)new Function<ListScheduledRunsResponse, List<ScheduledRunSummary>>(){

            @Override
            public List<ScheduledRunSummary> apply(ListScheduledRunsResponse response) {
                return response.getScheduledRunCollection().getItems();
            }
        });
    }

    public Iterable<ListSchedulesResponse> listSchedulesResponseIterator(final ListSchedulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSchedulesRequest.Builder>(){

            @Override
            public ListSchedulesRequest.Builder get() {
                return ListSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchedulesResponse, String>(){

            @Override
            public String apply(ListSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchedulesRequest.Builder>, ListSchedulesRequest>(){

            @Override
            public ListSchedulesRequest apply(RequestBuilderAndToken<ListSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchedulesRequest, ListSchedulesResponse>(){

            @Override
            public ListSchedulesResponse apply(ListSchedulesRequest request) {
                return UsageapiPaginators.this.client.listSchedules(request);
            }
        });
    }

    public Iterable<ScheduleSummary> listSchedulesRecordIterator(final ListSchedulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSchedulesRequest.Builder>(){

            @Override
            public ListSchedulesRequest.Builder get() {
                return ListSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSchedulesResponse, String>(){

            @Override
            public String apply(ListSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSchedulesRequest.Builder>, ListSchedulesRequest>(){

            @Override
            public ListSchedulesRequest apply(RequestBuilderAndToken<ListSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSchedulesRequest, ListSchedulesResponse>(){

            @Override
            public ListSchedulesResponse apply(ListSchedulesRequest request) {
                return UsageapiPaginators.this.client.listSchedules(request);
            }
        }, (Function)new Function<ListSchedulesResponse, List<ScheduleSummary>>(){

            @Override
            public List<ScheduleSummary> apply(ListSchedulesResponse response) {
                return response.getScheduleCollection().getItems();
            }
        });
    }

    public Iterable<ListUsageCarbonEmissionsQueriesResponse> listUsageCarbonEmissionsQueriesResponseIterator(final ListUsageCarbonEmissionsQueriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListUsageCarbonEmissionsQueriesRequest.Builder>(){

            @Override
            public ListUsageCarbonEmissionsQueriesRequest.Builder get() {
                return ListUsageCarbonEmissionsQueriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUsageCarbonEmissionsQueriesResponse, String>(){

            @Override
            public String apply(ListUsageCarbonEmissionsQueriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUsageCarbonEmissionsQueriesRequest.Builder>, ListUsageCarbonEmissionsQueriesRequest>(){

            @Override
            public ListUsageCarbonEmissionsQueriesRequest apply(RequestBuilderAndToken<ListUsageCarbonEmissionsQueriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListUsageCarbonEmissionsQueriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUsageCarbonEmissionsQueriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListUsageCarbonEmissionsQueriesRequest, ListUsageCarbonEmissionsQueriesResponse>(){

            @Override
            public ListUsageCarbonEmissionsQueriesResponse apply(ListUsageCarbonEmissionsQueriesRequest request) {
                return UsageapiPaginators.this.client.listUsageCarbonEmissionsQueries(request);
            }
        });
    }

    public Iterable<UsageCarbonEmissionsQuerySummary> listUsageCarbonEmissionsQueriesRecordIterator(final ListUsageCarbonEmissionsQueriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListUsageCarbonEmissionsQueriesRequest.Builder>(){

            @Override
            public ListUsageCarbonEmissionsQueriesRequest.Builder get() {
                return ListUsageCarbonEmissionsQueriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUsageCarbonEmissionsQueriesResponse, String>(){

            @Override
            public String apply(ListUsageCarbonEmissionsQueriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUsageCarbonEmissionsQueriesRequest.Builder>, ListUsageCarbonEmissionsQueriesRequest>(){

            @Override
            public ListUsageCarbonEmissionsQueriesRequest apply(RequestBuilderAndToken<ListUsageCarbonEmissionsQueriesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListUsageCarbonEmissionsQueriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUsageCarbonEmissionsQueriesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListUsageCarbonEmissionsQueriesRequest, ListUsageCarbonEmissionsQueriesResponse>(){

            @Override
            public ListUsageCarbonEmissionsQueriesResponse apply(ListUsageCarbonEmissionsQueriesRequest request) {
                return UsageapiPaginators.this.client.listUsageCarbonEmissionsQueries(request);
            }
        }, (Function)new Function<ListUsageCarbonEmissionsQueriesResponse, List<UsageCarbonEmissionsQuerySummary>>(){

            @Override
            public List<UsageCarbonEmissionsQuerySummary> apply(ListUsageCarbonEmissionsQueriesResponse response) {
                return response.getUsageCarbonEmissionsQueryCollection().getItems();
            }
        });
    }
}

