/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Forecast
extends ExplicitlySetBmcModel {
    @JsonProperty(value="forecastType")
    private final ForecastType forecastType;
    @JsonProperty(value="timeForecastStarted")
    private final Date timeForecastStarted;
    @JsonProperty(value="timeForecastEnded")
    private final Date timeForecastEnded;

    @Deprecated
    @ConstructorProperties(value={"forecastType", "timeForecastStarted", "timeForecastEnded"})
    public Forecast(ForecastType forecastType, Date timeForecastStarted, Date timeForecastEnded) {
        this.forecastType = forecastType;
        this.timeForecastStarted = timeForecastStarted;
        this.timeForecastEnded = timeForecastEnded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ForecastType getForecastType() {
        return this.forecastType;
    }

    public Date getTimeForecastStarted() {
        return this.timeForecastStarted;
    }

    public Date getTimeForecastEnded() {
        return this.timeForecastEnded;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Forecast(");
        sb.append("super=").append(super.toString());
        sb.append("forecastType=").append(String.valueOf((Object)this.forecastType));
        sb.append(", timeForecastStarted=").append(String.valueOf(this.timeForecastStarted));
        sb.append(", timeForecastEnded=").append(String.valueOf(this.timeForecastEnded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Forecast)) {
            return false;
        }
        Forecast other = (Forecast)((Object)o);
        return Objects.equals((Object)this.forecastType, (Object)other.forecastType) && Objects.equals(this.timeForecastStarted, other.timeForecastStarted) && Objects.equals(this.timeForecastEnded, other.timeForecastEnded) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.forecastType == null ? 43 : this.forecastType.hashCode());
        result = result * 59 + (this.timeForecastStarted == null ? 43 : this.timeForecastStarted.hashCode());
        result = result * 59 + (this.timeForecastEnded == null ? 43 : this.timeForecastEnded.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ForecastType implements BmcEnum
    {
        Basic("BASIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ForecastType> map;

        private ForecastType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ForecastType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ForecastType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ForecastType.class);
            map = new HashMap<String, ForecastType>();
            for (ForecastType v : ForecastType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="forecastType")
        private ForecastType forecastType;
        @JsonProperty(value="timeForecastStarted")
        private Date timeForecastStarted;
        @JsonProperty(value="timeForecastEnded")
        private Date timeForecastEnded;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder forecastType(ForecastType forecastType) {
            this.forecastType = forecastType;
            this.__explicitlySet__.add("forecastType");
            return this;
        }

        public Builder timeForecastStarted(Date timeForecastStarted) {
            this.timeForecastStarted = timeForecastStarted;
            this.__explicitlySet__.add("timeForecastStarted");
            return this;
        }

        public Builder timeForecastEnded(Date timeForecastEnded) {
            this.timeForecastEnded = timeForecastEnded;
            this.__explicitlySet__.add("timeForecastEnded");
            return this;
        }

        public Forecast build() {
            Forecast model = new Forecast(this.forecastType, this.timeForecastStarted, this.timeForecastEnded);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Forecast model) {
            if (model.wasPropertyExplicitlySet("forecastType")) {
                this.forecastType(model.getForecastType());
            }
            if (model.wasPropertyExplicitlySet("timeForecastStarted")) {
                this.timeForecastStarted(model.getTimeForecastStarted());
            }
            if (model.wasPropertyExplicitlySet("timeForecastEnded")) {
                this.timeForecastEnded(model.getTimeForecastEnded());
            }
            return this;
        }
    }
}

