/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.usageapi.UsageapiAsync;
import com.oracle.bmc.usageapi.model.AverageCarbonEmission;
import com.oracle.bmc.usageapi.model.CleanEnergyUsage;
import com.oracle.bmc.usageapi.model.ConfigurationAggregation;
import com.oracle.bmc.usageapi.model.CustomTable;
import com.oracle.bmc.usageapi.model.CustomTableCollection;
import com.oracle.bmc.usageapi.model.EmailRecipientsGroup;
import com.oracle.bmc.usageapi.model.EmailRecipientsGroupCollection;
import com.oracle.bmc.usageapi.model.Query;
import com.oracle.bmc.usageapi.model.QueryCollection;
import com.oracle.bmc.usageapi.model.Schedule;
import com.oracle.bmc.usageapi.model.ScheduleCollection;
import com.oracle.bmc.usageapi.model.ScheduledRun;
import com.oracle.bmc.usageapi.model.ScheduledRunCollection;
import com.oracle.bmc.usageapi.model.UsageAggregation;
import com.oracle.bmc.usageapi.model.UsageCarbonEmissionAggregation;
import com.oracle.bmc.usageapi.model.UsageCarbonEmissionsQuery;
import com.oracle.bmc.usageapi.model.UsageCarbonEmissionsQueryCollection;
import com.oracle.bmc.usageapi.requests.CreateCustomTableRequest;
import com.oracle.bmc.usageapi.requests.CreateEmailRecipientsGroupRequest;
import com.oracle.bmc.usageapi.requests.CreateQueryRequest;
import com.oracle.bmc.usageapi.requests.CreateScheduleRequest;
import com.oracle.bmc.usageapi.requests.CreateUsageCarbonEmissionsQueryRequest;
import com.oracle.bmc.usageapi.requests.DeleteCustomTableRequest;
import com.oracle.bmc.usageapi.requests.DeleteEmailRecipientsGroupRequest;
import com.oracle.bmc.usageapi.requests.DeleteQueryRequest;
import com.oracle.bmc.usageapi.requests.DeleteScheduleRequest;
import com.oracle.bmc.usageapi.requests.DeleteUsageCarbonEmissionsQueryRequest;
import com.oracle.bmc.usageapi.requests.GetCustomTableRequest;
import com.oracle.bmc.usageapi.requests.GetEmailRecipientsGroupRequest;
import com.oracle.bmc.usageapi.requests.GetQueryRequest;
import com.oracle.bmc.usageapi.requests.GetScheduleRequest;
import com.oracle.bmc.usageapi.requests.GetScheduledRunRequest;
import com.oracle.bmc.usageapi.requests.GetUsageCarbonEmissionsQueryRequest;
import com.oracle.bmc.usageapi.requests.ListCustomTablesRequest;
import com.oracle.bmc.usageapi.requests.ListEmailRecipientsGroupsRequest;
import com.oracle.bmc.usageapi.requests.ListQueriesRequest;
import com.oracle.bmc.usageapi.requests.ListScheduledRunsRequest;
import com.oracle.bmc.usageapi.requests.ListSchedulesRequest;
import com.oracle.bmc.usageapi.requests.ListUsageCarbonEmissionsQueriesRequest;
import com.oracle.bmc.usageapi.requests.RequestAverageCarbonEmissionRequest;
import com.oracle.bmc.usageapi.requests.RequestCleanEnergyUsageRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedConfigurationsRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedUsagesRequest;
import com.oracle.bmc.usageapi.requests.RequestUsageCarbonEmissionConfigRequest;
import com.oracle.bmc.usageapi.requests.RequestUsageCarbonEmissionsRequest;
import com.oracle.bmc.usageapi.requests.UpdateCustomTableRequest;
import com.oracle.bmc.usageapi.requests.UpdateEmailRecipientsGroupRequest;
import com.oracle.bmc.usageapi.requests.UpdateQueryRequest;
import com.oracle.bmc.usageapi.requests.UpdateScheduleRequest;
import com.oracle.bmc.usageapi.requests.UpdateUsageCarbonEmissionsQueryRequest;
import com.oracle.bmc.usageapi.responses.CreateCustomTableResponse;
import com.oracle.bmc.usageapi.responses.CreateEmailRecipientsGroupResponse;
import com.oracle.bmc.usageapi.responses.CreateQueryResponse;
import com.oracle.bmc.usageapi.responses.CreateScheduleResponse;
import com.oracle.bmc.usageapi.responses.CreateUsageCarbonEmissionsQueryResponse;
import com.oracle.bmc.usageapi.responses.DeleteCustomTableResponse;
import com.oracle.bmc.usageapi.responses.DeleteEmailRecipientsGroupResponse;
import com.oracle.bmc.usageapi.responses.DeleteQueryResponse;
import com.oracle.bmc.usageapi.responses.DeleteScheduleResponse;
import com.oracle.bmc.usageapi.responses.DeleteUsageCarbonEmissionsQueryResponse;
import com.oracle.bmc.usageapi.responses.GetCustomTableResponse;
import com.oracle.bmc.usageapi.responses.GetEmailRecipientsGroupResponse;
import com.oracle.bmc.usageapi.responses.GetQueryResponse;
import com.oracle.bmc.usageapi.responses.GetScheduleResponse;
import com.oracle.bmc.usageapi.responses.GetScheduledRunResponse;
import com.oracle.bmc.usageapi.responses.GetUsageCarbonEmissionsQueryResponse;
import com.oracle.bmc.usageapi.responses.ListCustomTablesResponse;
import com.oracle.bmc.usageapi.responses.ListEmailRecipientsGroupsResponse;
import com.oracle.bmc.usageapi.responses.ListQueriesResponse;
import com.oracle.bmc.usageapi.responses.ListScheduledRunsResponse;
import com.oracle.bmc.usageapi.responses.ListSchedulesResponse;
import com.oracle.bmc.usageapi.responses.ListUsageCarbonEmissionsQueriesResponse;
import com.oracle.bmc.usageapi.responses.RequestAverageCarbonEmissionResponse;
import com.oracle.bmc.usageapi.responses.RequestCleanEnergyUsageResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedConfigurationsResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedUsagesResponse;
import com.oracle.bmc.usageapi.responses.RequestUsageCarbonEmissionConfigResponse;
import com.oracle.bmc.usageapi.responses.RequestUsageCarbonEmissionsResponse;
import com.oracle.bmc.usageapi.responses.UpdateCustomTableResponse;
import com.oracle.bmc.usageapi.responses.UpdateEmailRecipientsGroupResponse;
import com.oracle.bmc.usageapi.responses.UpdateQueryResponse;
import com.oracle.bmc.usageapi.responses.UpdateScheduleResponse;
import com.oracle.bmc.usageapi.responses.UpdateUsageCarbonEmissionsQueryResponse;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageapiAsyncClient
extends BaseAsyncClient
implements UsageapiAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("USAGEAPI").serviceEndpointPrefix("").serviceEndpointTemplate("https://usageapi.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(UsageapiAsyncClient.class);

    UsageapiAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateCustomTableResponse> createCustomTable(CreateCustomTableRequest request, AsyncHandler<CreateCustomTableRequest, CreateCustomTableResponse> handler) {
        Objects.requireNonNull(request.getCreateCustomTableDetails(), "createCustomTableDetails is required");
        return this.clientCall(request, CreateCustomTableResponse::builder).logger(LOG, "createCustomTable").serviceDetails("Usageapi", "CreateCustomTable", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/CreateCustomTable").method(Method.POST).requestBuilder(CreateCustomTableRequest::builder).basePath("/20200107").appendPathParam("customTables").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(CustomTable.class, CreateCustomTableResponse.Builder::customTable).handleResponseHeaderString("opc-request-id", CreateCustomTableResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateCustomTableResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateEmailRecipientsGroupResponse> createEmailRecipientsGroup(CreateEmailRecipientsGroupRequest request, AsyncHandler<CreateEmailRecipientsGroupRequest, CreateEmailRecipientsGroupResponse> handler) {
        Objects.requireNonNull(request.getCreateEmailRecipientsGroupDetails(), "createEmailRecipientsGroupDetails is required");
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateEmailRecipientsGroupResponse::builder).logger(LOG, "createEmailRecipientsGroup").serviceDetails("Usageapi", "CreateEmailRecipientsGroup", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/EmailRecipientsGroup/CreateEmailRecipientsGroup").method(Method.POST).requestBuilder(CreateEmailRecipientsGroupRequest::builder).basePath("/20200107").appendPathParam("usageStatements").appendPathParam(request.getSubscriptionId()).appendPathParam("emailRecipientsGroups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(EmailRecipientsGroup.class, CreateEmailRecipientsGroupResponse.Builder::emailRecipientsGroup).handleResponseHeaderString("opc-request-id", CreateEmailRecipientsGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateEmailRecipientsGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateQueryResponse> createQuery(CreateQueryRequest request, AsyncHandler<CreateQueryRequest, CreateQueryResponse> handler) {
        Objects.requireNonNull(request.getCreateQueryDetails(), "createQueryDetails is required");
        return this.clientCall(request, CreateQueryResponse::builder).logger(LOG, "createQuery").serviceDetails("Usageapi", "CreateQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/CreateQuery").method(Method.POST).requestBuilder(CreateQueryRequest::builder).basePath("/20200107").appendPathParam("queries").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Query.class, CreateQueryResponse.Builder::query).handleResponseHeaderString("opc-request-id", CreateQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateQueryResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateScheduleResponse> createSchedule(CreateScheduleRequest request, AsyncHandler<CreateScheduleRequest, CreateScheduleResponse> handler) {
        Objects.requireNonNull(request.getCreateScheduleDetails(), "createScheduleDetails is required");
        return this.clientCall(request, CreateScheduleResponse::builder).logger(LOG, "createSchedule").serviceDetails("Usageapi", "CreateSchedule", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/CreateSchedule").method(Method.POST).requestBuilder(CreateScheduleRequest::builder).basePath("/20200107").appendPathParam("schedules").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Schedule.class, CreateScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", CreateScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateScheduleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateUsageCarbonEmissionsQueryResponse> createUsageCarbonEmissionsQuery(CreateUsageCarbonEmissionsQueryRequest request, AsyncHandler<CreateUsageCarbonEmissionsQueryRequest, CreateUsageCarbonEmissionsQueryResponse> handler) {
        Objects.requireNonNull(request.getCreateUsageCarbonEmissionsQueryDetails(), "createUsageCarbonEmissionsQueryDetails is required");
        return this.clientCall(request, CreateUsageCarbonEmissionsQueryResponse::builder).logger(LOG, "createUsageCarbonEmissionsQuery").serviceDetails("Usageapi", "CreateUsageCarbonEmissionsQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/UsageCarbonEmissionsQuery/CreateUsageCarbonEmissionsQuery").method(Method.POST).requestBuilder(CreateUsageCarbonEmissionsQueryRequest::builder).basePath("/20200107").appendPathParam("usageCarbonEmissionsQueries").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(UsageCarbonEmissionsQuery.class, CreateUsageCarbonEmissionsQueryResponse.Builder::usageCarbonEmissionsQuery).handleResponseHeaderString("opc-request-id", CreateUsageCarbonEmissionsQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateUsageCarbonEmissionsQueryResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteCustomTableResponse> deleteCustomTable(DeleteCustomTableRequest request, AsyncHandler<DeleteCustomTableRequest, DeleteCustomTableResponse> handler) {
        Validate.notBlank((String)request.getCustomTableId(), (String)"customTableId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCustomTableResponse::builder).logger(LOG, "deleteCustomTable").serviceDetails("Usageapi", "DeleteCustomTable", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/DeleteCustomTable").method(Method.DELETE).requestBuilder(DeleteCustomTableRequest::builder).basePath("/20200107").appendPathParam("customTables").appendPathParam(request.getCustomTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteCustomTableResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteEmailRecipientsGroupResponse> deleteEmailRecipientsGroup(DeleteEmailRecipientsGroupRequest request, AsyncHandler<DeleteEmailRecipientsGroupRequest, DeleteEmailRecipientsGroupResponse> handler) {
        Validate.notBlank((String)request.getEmailRecipientsGroupId(), (String)"emailRecipientsGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, DeleteEmailRecipientsGroupResponse::builder).logger(LOG, "deleteEmailRecipientsGroup").serviceDetails("Usageapi", "DeleteEmailRecipientsGroup", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/EmailRecipientsGroup/DeleteEmailRecipientsGroup").method(Method.DELETE).requestBuilder(DeleteEmailRecipientsGroupRequest::builder).basePath("/20200107").appendPathParam("usageStatements").appendPathParam(request.getSubscriptionId()).appendPathParam("emailRecipientsGroups").appendPathParam(request.getEmailRecipientsGroupId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteEmailRecipientsGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteQueryResponse> deleteQuery(DeleteQueryRequest request, AsyncHandler<DeleteQueryRequest, DeleteQueryResponse> handler) {
        Validate.notBlank((String)request.getQueryId(), (String)"queryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteQueryResponse::builder).logger(LOG, "deleteQuery").serviceDetails("Usageapi", "DeleteQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/DeleteQuery").method(Method.DELETE).requestBuilder(DeleteQueryRequest::builder).basePath("/20200107").appendPathParam("queries").appendPathParam(request.getQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteQueryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteScheduleResponse> deleteSchedule(DeleteScheduleRequest request, AsyncHandler<DeleteScheduleRequest, DeleteScheduleResponse> handler) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteScheduleResponse::builder).logger(LOG, "deleteSchedule").serviceDetails("Usageapi", "DeleteSchedule", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/DeleteSchedule").method(Method.DELETE).requestBuilder(DeleteScheduleRequest::builder).basePath("/20200107").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteUsageCarbonEmissionsQueryResponse> deleteUsageCarbonEmissionsQuery(DeleteUsageCarbonEmissionsQueryRequest request, AsyncHandler<DeleteUsageCarbonEmissionsQueryRequest, DeleteUsageCarbonEmissionsQueryResponse> handler) {
        Validate.notBlank((String)request.getUsageCarbonEmissionsQueryId(), (String)"usageCarbonEmissionsQueryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteUsageCarbonEmissionsQueryResponse::builder).logger(LOG, "deleteUsageCarbonEmissionsQuery").serviceDetails("Usageapi", "DeleteUsageCarbonEmissionsQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/UsageCarbonEmissionsQuery/DeleteUsageCarbonEmissionsQuery").method(Method.DELETE).requestBuilder(DeleteUsageCarbonEmissionsQueryRequest::builder).basePath("/20200107").appendPathParam("usageCarbonEmissionsQueries").appendPathParam(request.getUsageCarbonEmissionsQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteUsageCarbonEmissionsQueryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCustomTableResponse> getCustomTable(GetCustomTableRequest request, AsyncHandler<GetCustomTableRequest, GetCustomTableResponse> handler) {
        Validate.notBlank((String)request.getCustomTableId(), (String)"customTableId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCustomTableResponse::builder).logger(LOG, "getCustomTable").serviceDetails("Usageapi", "GetCustomTable", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/GetCustomTable").method(Method.GET).requestBuilder(GetCustomTableRequest::builder).basePath("/20200107").appendPathParam("customTables").appendPathParam(request.getCustomTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CustomTable.class, GetCustomTableResponse.Builder::customTable).handleResponseHeaderString("opc-request-id", GetCustomTableResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetCustomTableResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetEmailRecipientsGroupResponse> getEmailRecipientsGroup(GetEmailRecipientsGroupRequest request, AsyncHandler<GetEmailRecipientsGroupRequest, GetEmailRecipientsGroupResponse> handler) {
        Validate.notBlank((String)request.getEmailRecipientsGroupId(), (String)"emailRecipientsGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetEmailRecipientsGroupResponse::builder).logger(LOG, "getEmailRecipientsGroup").serviceDetails("Usageapi", "GetEmailRecipientsGroup", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/EmailRecipientsGroup/GetEmailRecipientsGroup").method(Method.GET).requestBuilder(GetEmailRecipientsGroupRequest::builder).basePath("/20200107").appendPathParam("usageStatements").appendPathParam(request.getSubscriptionId()).appendPathParam("emailRecipientsGroups").appendPathParam(request.getEmailRecipientsGroupId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EmailRecipientsGroup.class, GetEmailRecipientsGroupResponse.Builder::emailRecipientsGroup).handleResponseHeaderString("opc-request-id", GetEmailRecipientsGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetEmailRecipientsGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetQueryResponse> getQuery(GetQueryRequest request, AsyncHandler<GetQueryRequest, GetQueryResponse> handler) {
        Validate.notBlank((String)request.getQueryId(), (String)"queryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetQueryResponse::builder).logger(LOG, "getQuery").serviceDetails("Usageapi", "GetQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/GetQuery").method(Method.GET).requestBuilder(GetQueryRequest::builder).basePath("/20200107").appendPathParam("queries").appendPathParam(request.getQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Query.class, GetQueryResponse.Builder::query).handleResponseHeaderString("opc-request-id", GetQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetQueryResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetScheduleResponse> getSchedule(GetScheduleRequest request, AsyncHandler<GetScheduleRequest, GetScheduleResponse> handler) {
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetScheduleResponse::builder).logger(LOG, "getSchedule").serviceDetails("Usageapi", "GetSchedule", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/GetSchedule").method(Method.GET).requestBuilder(GetScheduleRequest::builder).basePath("/20200107").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Schedule.class, GetScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", GetScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetScheduleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetScheduledRunResponse> getScheduledRun(GetScheduledRunRequest request, AsyncHandler<GetScheduledRunRequest, GetScheduledRunResponse> handler) {
        Validate.notBlank((String)request.getScheduledRunId(), (String)"scheduledRunId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetScheduledRunResponse::builder).logger(LOG, "getScheduledRun").serviceDetails("Usageapi", "GetScheduledRun", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/ScheduledRun/GetScheduledRun").method(Method.GET).requestBuilder(GetScheduledRunRequest::builder).basePath("/20200107").appendPathParam("scheduledRuns").appendPathParam(request.getScheduledRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledRun.class, GetScheduledRunResponse.Builder::scheduledRun).handleResponseHeaderString("opc-request-id", GetScheduledRunResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetScheduledRunResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetUsageCarbonEmissionsQueryResponse> getUsageCarbonEmissionsQuery(GetUsageCarbonEmissionsQueryRequest request, AsyncHandler<GetUsageCarbonEmissionsQueryRequest, GetUsageCarbonEmissionsQueryResponse> handler) {
        Validate.notBlank((String)request.getUsageCarbonEmissionsQueryId(), (String)"usageCarbonEmissionsQueryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUsageCarbonEmissionsQueryResponse::builder).logger(LOG, "getUsageCarbonEmissionsQuery").serviceDetails("Usageapi", "GetUsageCarbonEmissionsQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/UsageCarbonEmissionsQuery/GetUsageCarbonEmissionsQuery").method(Method.GET).requestBuilder(GetUsageCarbonEmissionsQueryRequest::builder).basePath("/20200107").appendPathParam("usageCarbonEmissionsQueries").appendPathParam(request.getUsageCarbonEmissionsQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UsageCarbonEmissionsQuery.class, GetUsageCarbonEmissionsQueryResponse.Builder::usageCarbonEmissionsQuery).handleResponseHeaderString("opc-request-id", GetUsageCarbonEmissionsQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetUsageCarbonEmissionsQueryResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListCustomTablesResponse> listCustomTables(ListCustomTablesRequest request, AsyncHandler<ListCustomTablesRequest, ListCustomTablesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSavedReportId(), "savedReportId is required");
        return this.clientCall(request, ListCustomTablesResponse::builder).logger(LOG, "listCustomTables").serviceDetails("Usageapi", "ListCustomTables", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/ListCustomTables").method(Method.GET).requestBuilder(ListCustomTablesRequest::builder).basePath("/20200107").appendPathParam("customTables").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("savedReportId", (Object)request.getSavedReportId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CustomTableCollection.class, ListCustomTablesResponse.Builder::customTableCollection).handleResponseHeaderString("opc-request-id", ListCustomTablesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCustomTablesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListEmailRecipientsGroupsResponse> listEmailRecipientsGroups(ListEmailRecipientsGroupsRequest request, AsyncHandler<ListEmailRecipientsGroupsRequest, ListEmailRecipientsGroupsResponse> handler) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListEmailRecipientsGroupsResponse::builder).logger(LOG, "listEmailRecipientsGroups").serviceDetails("Usageapi", "ListEmailRecipientsGroups", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/EmailRecipientsGroup/ListEmailRecipientsGroups").method(Method.GET).requestBuilder(ListEmailRecipientsGroupsRequest::builder).basePath("/20200107").appendPathParam("usageStatements").appendPathParam(request.getSubscriptionId()).appendPathParam("emailRecipientsGroups").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(EmailRecipientsGroupCollection.class, ListEmailRecipientsGroupsResponse.Builder::emailRecipientsGroupCollection).handleResponseHeaderString("opc-request-id", ListEmailRecipientsGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEmailRecipientsGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListQueriesResponse> listQueries(ListQueriesRequest request, AsyncHandler<ListQueriesRequest, ListQueriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListQueriesResponse::builder).logger(LOG, "listQueries").serviceDetails("Usageapi", "ListQueries", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/ListQueries").method(Method.GET).requestBuilder(ListQueriesRequest::builder).basePath("/20200107").appendPathParam("queries").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(QueryCollection.class, ListQueriesResponse.Builder::queryCollection).handleResponseHeaderString("opc-request-id", ListQueriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListQueriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListScheduledRunsResponse> listScheduledRuns(ListScheduledRunsRequest request, AsyncHandler<ListScheduledRunsRequest, ListScheduledRunsResponse> handler) {
        Objects.requireNonNull(request.getScheduleId(), "scheduleId is required");
        return this.clientCall(request, ListScheduledRunsResponse::builder).logger(LOG, "listScheduledRuns").serviceDetails("Usageapi", "ListScheduledRuns", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/ScheduledRun/ListScheduledRuns").method(Method.GET).requestBuilder(ListScheduledRunsRequest::builder).basePath("/20200107").appendPathParam("scheduledRuns").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("scheduleId", (Object)request.getScheduleId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduledRunCollection.class, ListScheduledRunsResponse.Builder::scheduledRunCollection).handleResponseHeaderString("opc-request-id", ListScheduledRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListScheduledRunsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSchedulesResponse> listSchedules(ListSchedulesRequest request, AsyncHandler<ListSchedulesRequest, ListSchedulesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSchedulesResponse::builder).logger(LOG, "listSchedules").serviceDetails("Usageapi", "ListSchedules", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/ListSchedules").method(Method.GET).requestBuilder(ListSchedulesRequest::builder).basePath("/20200107").appendPathParam("schedules").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ScheduleCollection.class, ListSchedulesResponse.Builder::scheduleCollection).handleResponseHeaderString("opc-request-id", ListSchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSchedulesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListUsageCarbonEmissionsQueriesResponse> listUsageCarbonEmissionsQueries(ListUsageCarbonEmissionsQueriesRequest request, AsyncHandler<ListUsageCarbonEmissionsQueriesRequest, ListUsageCarbonEmissionsQueriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListUsageCarbonEmissionsQueriesResponse::builder).logger(LOG, "listUsageCarbonEmissionsQueries").serviceDetails("Usageapi", "ListUsageCarbonEmissionsQueries", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/UsageCarbonEmissionsQuery/ListUsageCarbonEmissionsQueries").method(Method.GET).requestBuilder(ListUsageCarbonEmissionsQueriesRequest::builder).basePath("/20200107").appendPathParam("usageCarbonEmissionsQueries").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UsageCarbonEmissionsQueryCollection.class, ListUsageCarbonEmissionsQueriesResponse.Builder::usageCarbonEmissionsQueryCollection).handleResponseHeaderString("opc-request-id", ListUsageCarbonEmissionsQueriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUsageCarbonEmissionsQueriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RequestAverageCarbonEmissionResponse> requestAverageCarbonEmission(RequestAverageCarbonEmissionRequest request, AsyncHandler<RequestAverageCarbonEmissionRequest, RequestAverageCarbonEmissionResponse> handler) {
        Validate.notBlank((String)request.getSkuPartNumber(), (String)"skuPartNumber must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RequestAverageCarbonEmissionResponse::builder).logger(LOG, "requestAverageCarbonEmission").serviceDetails("Usageapi", "RequestAverageCarbonEmission", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/AverageCarbonEmission/RequestAverageCarbonEmission").method(Method.GET).requestBuilder(RequestAverageCarbonEmissionRequest::builder).basePath("/20200107").appendPathParam("averageCarbonEmissions").appendPathParam(request.getSkuPartNumber()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AverageCarbonEmission.class, RequestAverageCarbonEmissionResponse.Builder::averageCarbonEmission).handleResponseHeaderString("opc-request-id", RequestAverageCarbonEmissionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RequestAverageCarbonEmissionResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RequestCleanEnergyUsageResponse> requestCleanEnergyUsage(RequestCleanEnergyUsageRequest request, AsyncHandler<RequestCleanEnergyUsageRequest, RequestCleanEnergyUsageResponse> handler) {
        Validate.notBlank((String)request.getRegion(), (String)"region must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RequestCleanEnergyUsageResponse::builder).logger(LOG, "requestCleanEnergyUsage").serviceDetails("Usageapi", "RequestCleanEnergyUsage", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CleanEnergyUsage/RequestCleanEnergyUsage").method(Method.GET).requestBuilder(RequestCleanEnergyUsageRequest::builder).basePath("/20200107").appendPathParam("cleanEnergyUsages").appendPathParam(request.getRegion()).appendQueryParam("ad", (Object)request.getAd()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CleanEnergyUsage.class, RequestCleanEnergyUsageResponse.Builder::cleanEnergyUsage).handleResponseHeaderString("opc-request-id", RequestCleanEnergyUsageResponse.Builder::opcRequestId).handleResponseHeaderString("etag", RequestCleanEnergyUsageResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RequestSummarizedConfigurationsResponse> requestSummarizedConfigurations(RequestSummarizedConfigurationsRequest request, AsyncHandler<RequestSummarizedConfigurationsRequest, RequestSummarizedConfigurationsResponse> handler) {
        Objects.requireNonNull(request.getTenantId(), "tenantId is required");
        return this.clientCall(request, RequestSummarizedConfigurationsResponse::builder).logger(LOG, "requestSummarizedConfigurations").serviceDetails("Usageapi", "RequestSummarizedConfigurations", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Configuration/RequestSummarizedConfigurations").method(Method.GET).requestBuilder(RequestSummarizedConfigurationsRequest::builder).basePath("/20200107").appendPathParam("configuration").appendQueryParam("tenantId", (Object)request.getTenantId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfigurationAggregation.class, RequestSummarizedConfigurationsResponse.Builder::configurationAggregation).handleResponseHeaderString("opc-request-id", RequestSummarizedConfigurationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RequestSummarizedUsagesResponse> requestSummarizedUsages(RequestSummarizedUsagesRequest request, AsyncHandler<RequestSummarizedUsagesRequest, RequestSummarizedUsagesResponse> handler) {
        Objects.requireNonNull(request.getRequestSummarizedUsagesDetails(), "requestSummarizedUsagesDetails is required");
        return this.clientCall(request, RequestSummarizedUsagesResponse::builder).logger(LOG, "requestSummarizedUsages").serviceDetails("Usageapi", "RequestSummarizedUsages", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/UsageSummary/RequestSummarizedUsages").method(Method.POST).requestBuilder(RequestSummarizedUsagesRequest::builder).basePath("/20200107").appendPathParam("usage").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UsageAggregation.class, RequestSummarizedUsagesResponse.Builder::usageAggregation).handleResponseHeaderString("opc-request-id", RequestSummarizedUsagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestSummarizedUsagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RequestUsageCarbonEmissionConfigResponse> requestUsageCarbonEmissionConfig(RequestUsageCarbonEmissionConfigRequest request, AsyncHandler<RequestUsageCarbonEmissionConfigRequest, RequestUsageCarbonEmissionConfigResponse> handler) {
        Objects.requireNonNull(request.getTenantId(), "tenantId is required");
        return this.clientCall(request, RequestUsageCarbonEmissionConfigResponse::builder).logger(LOG, "requestUsageCarbonEmissionConfig").serviceDetails("Usageapi", "RequestUsageCarbonEmissionConfig", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Configuration/RequestUsageCarbonEmissionConfig").method(Method.GET).requestBuilder(RequestUsageCarbonEmissionConfigRequest::builder).basePath("/20200107").appendPathParam("usageCarbonEmissionsConfig").appendQueryParam("tenantId", (Object)request.getTenantId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ConfigurationAggregation.class, RequestUsageCarbonEmissionConfigResponse.Builder::configurationAggregation).handleResponseHeaderString("opc-request-id", RequestUsageCarbonEmissionConfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RequestUsageCarbonEmissionsResponse> requestUsageCarbonEmissions(RequestUsageCarbonEmissionsRequest request, AsyncHandler<RequestUsageCarbonEmissionsRequest, RequestUsageCarbonEmissionsResponse> handler) {
        Objects.requireNonNull(request.getRequestUsageCarbonEmissionsDetails(), "requestUsageCarbonEmissionsDetails is required");
        return this.clientCall(request, RequestUsageCarbonEmissionsResponse::builder).logger(LOG, "requestUsageCarbonEmissions").serviceDetails("Usageapi", "RequestUsageCarbonEmissions", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/UsageCarbonEmissionSummary/RequestUsageCarbonEmissions").method(Method.POST).requestBuilder(RequestUsageCarbonEmissionsRequest::builder).basePath("/20200107").appendPathParam("usageCarbonEmissions").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UsageCarbonEmissionAggregation.class, RequestUsageCarbonEmissionsResponse.Builder::usageCarbonEmissionAggregation).handleResponseHeaderString("opc-request-id", RequestUsageCarbonEmissionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", RequestUsageCarbonEmissionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateCustomTableResponse> updateCustomTable(UpdateCustomTableRequest request, AsyncHandler<UpdateCustomTableRequest, UpdateCustomTableResponse> handler) {
        Objects.requireNonNull(request.getUpdateCustomTableDetails(), "updateCustomTableDetails is required");
        Validate.notBlank((String)request.getCustomTableId(), (String)"customTableId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateCustomTableResponse::builder).logger(LOG, "updateCustomTable").serviceDetails("Usageapi", "UpdateCustomTable", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/CustomTable/UpdateCustomTable").method(Method.PUT).requestBuilder(UpdateCustomTableRequest::builder).basePath("/20200107").appendPathParam("customTables").appendPathParam(request.getCustomTableId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(CustomTable.class, UpdateCustomTableResponse.Builder::customTable).handleResponseHeaderString("opc-request-id", UpdateCustomTableResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateCustomTableResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateEmailRecipientsGroupResponse> updateEmailRecipientsGroup(UpdateEmailRecipientsGroupRequest request, AsyncHandler<UpdateEmailRecipientsGroupRequest, UpdateEmailRecipientsGroupResponse> handler) {
        Objects.requireNonNull(request.getUpdateEmailRecipientsGroupDetails(), "updateEmailRecipientsGroupDetails is required");
        Validate.notBlank((String)request.getEmailRecipientsGroupId(), (String)"emailRecipientsGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, UpdateEmailRecipientsGroupResponse::builder).logger(LOG, "updateEmailRecipientsGroup").serviceDetails("Usageapi", "UpdateEmailRecipientsGroup", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/EmailRecipientsGroup/UpdateEmailRecipientsGroup").method(Method.PUT).requestBuilder(UpdateEmailRecipientsGroupRequest::builder).basePath("/20200107").appendPathParam("usageStatements").appendPathParam(request.getSubscriptionId()).appendPathParam("emailRecipientsGroups").appendPathParam(request.getEmailRecipientsGroupId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(EmailRecipientsGroup.class, UpdateEmailRecipientsGroupResponse.Builder::emailRecipientsGroup).handleResponseHeaderString("opc-request-id", UpdateEmailRecipientsGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateEmailRecipientsGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateQueryResponse> updateQuery(UpdateQueryRequest request, AsyncHandler<UpdateQueryRequest, UpdateQueryResponse> handler) {
        Objects.requireNonNull(request.getUpdateQueryDetails(), "updateQueryDetails is required");
        Validate.notBlank((String)request.getQueryId(), (String)"queryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateQueryResponse::builder).logger(LOG, "updateQuery").serviceDetails("Usageapi", "UpdateQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Query/UpdateQuery").method(Method.PUT).requestBuilder(UpdateQueryRequest::builder).basePath("/20200107").appendPathParam("queries").appendPathParam(request.getQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Query.class, UpdateQueryResponse.Builder::query).handleResponseHeaderString("opc-request-id", UpdateQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateQueryResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateScheduleResponse> updateSchedule(UpdateScheduleRequest request, AsyncHandler<UpdateScheduleRequest, UpdateScheduleResponse> handler) {
        Objects.requireNonNull(request.getUpdateScheduleDetails(), "updateScheduleDetails is required");
        Validate.notBlank((String)request.getScheduleId(), (String)"scheduleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateScheduleResponse::builder).logger(LOG, "updateSchedule").serviceDetails("Usageapi", "UpdateSchedule", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/Schedule/UpdateSchedule").method(Method.PUT).requestBuilder(UpdateScheduleRequest::builder).basePath("/20200107").appendPathParam("schedules").appendPathParam(request.getScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Schedule.class, UpdateScheduleResponse.Builder::schedule).handleResponseHeaderString("opc-request-id", UpdateScheduleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateScheduleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateUsageCarbonEmissionsQueryResponse> updateUsageCarbonEmissionsQuery(UpdateUsageCarbonEmissionsQueryRequest request, AsyncHandler<UpdateUsageCarbonEmissionsQueryRequest, UpdateUsageCarbonEmissionsQueryResponse> handler) {
        Objects.requireNonNull(request.getUpdateUsageCarbonEmissionsQueryDetails(), "updateUsageCarbonEmissionsQueryDetails is required");
        Validate.notBlank((String)request.getUsageCarbonEmissionsQueryId(), (String)"usageCarbonEmissionsQueryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateUsageCarbonEmissionsQueryResponse::builder).logger(LOG, "updateUsageCarbonEmissionsQuery").serviceDetails("Usageapi", "UpdateUsageCarbonEmissionsQuery", "https://docs.oracle.com/iaas/api/#/en/usage/20200107/UsageCarbonEmissionsQuery/UpdateUsageCarbonEmissionsQuery").method(Method.PUT).requestBuilder(UpdateUsageCarbonEmissionsQueryRequest::builder).basePath("/20200107").appendPathParam("usageCarbonEmissionsQueries").appendPathParam(request.getUsageCarbonEmissionsQueryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(UsageCarbonEmissionsQuery.class, UpdateUsageCarbonEmissionsQueryResponse.Builder::usageCarbonEmissionsQuery).handleResponseHeaderString("opc-request-id", UpdateUsageCarbonEmissionsQueryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateUsageCarbonEmissionsQueryResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public UsageapiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)UsageapiAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsageapiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(UsageapiAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsageapiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)UsageapiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)UsageapiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)UsageapiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)UsageapiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)UsageapiAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, UsageapiAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "usageapi";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"usageapi");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public UsageapiAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new UsageapiAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

