/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RequestUsageCarbonEmissionConfigRequest
extends BmcRequest<Void> {
    private String tenantId;
    private String opcRequestId;

    public String getTenantId() {
        return this.tenantId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().tenantId(this.tenantId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tenantId=").append(String.valueOf(this.tenantId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestUsageCarbonEmissionConfigRequest)) {
            return false;
        }
        RequestUsageCarbonEmissionConfigRequest other = (RequestUsageCarbonEmissionConfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tenantId, other.tenantId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tenantId == null ? 43 : this.tenantId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestUsageCarbonEmissionConfigRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tenantId = null;
        private String opcRequestId = null;

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestUsageCarbonEmissionConfigRequest o) {
            this.tenantId(o.getTenantId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestUsageCarbonEmissionConfigRequest build() {
            RequestUsageCarbonEmissionConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RequestUsageCarbonEmissionConfigRequest buildWithoutInvocationCallback() {
            RequestUsageCarbonEmissionConfigRequest request = new RequestUsageCarbonEmissionConfigRequest();
            request.tenantId = this.tenantId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

