/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.vault.model.Secret;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.responses.CreateSecretResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSecretConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSecretConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateSecretRequest interceptRequest(CreateSecretRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateSecretRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateSecretDetails(), (String)"createSecretDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180608").path("secrets");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateSecretResponse> fromResponse() {
        Function<Response, CreateSecretResponse> transformer = new Function<Response, CreateSecretResponse>(){

            public CreateSecretResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.vault.responses.CreateSecretResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Secret.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateSecretResponse.Builder builder = CreateSecretResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.secret((Secret)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                CreateSecretResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

