/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CancelSecretDeletionRequest
extends BmcRequest<Void> {
    private String secretId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"secretId", "ifMatch", "opcRequestId"})
    CancelSecretDeletionRequest(String secretId, String ifMatch, String opcRequestId) {
        this.secretId = secretId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelSecretDeletionRequest, Void> {
        private String secretId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelSecretDeletionRequest o) {
            this.secretId(o.getSecretId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelSecretDeletionRequest build() {
            CancelSecretDeletionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CancelSecretDeletionRequest buildWithoutInvocationCallback() {
            return new CancelSecretDeletionRequest(this.secretId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "CancelSecretDeletionRequest.Builder(secretId=" + this.secretId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

