/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSecretVersionRequest
extends BmcRequest<Void> {
    private String secretId;
    private Long secretVersionNumber;
    private String opcRequestId;

    @ConstructorProperties(value={"secretId", "secretVersionNumber", "opcRequestId"})
    GetSecretVersionRequest(String secretId, Long secretVersionNumber, String opcRequestId) {
        this.secretId = secretId;
        this.secretVersionNumber = secretVersionNumber;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSecretId() {
        return this.secretId;
    }

    public Long getSecretVersionNumber() {
        return this.secretVersionNumber;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSecretVersionRequest, Void> {
        private String secretId;
        private Long secretVersionNumber;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecretVersionRequest o) {
            this.secretId(o.getSecretId());
            this.secretVersionNumber(o.getSecretVersionNumber());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecretVersionRequest build() {
            GetSecretVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder secretVersionNumber(Long secretVersionNumber) {
            this.secretVersionNumber = secretVersionNumber;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetSecretVersionRequest buildWithoutInvocationCallback() {
            return new GetSecretVersionRequest(this.secretId, this.secretVersionNumber, this.opcRequestId);
        }

        public String toString() {
            return "GetSecretVersionRequest.Builder(secretId=" + this.secretId + ", secretVersionNumber=" + this.secretVersionNumber + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

