/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vault.VaultsAsync;
import com.oracle.bmc.vault.model.Secret;
import com.oracle.bmc.vault.model.SecretSummary;
import com.oracle.bmc.vault.model.SecretVersion;
import com.oracle.bmc.vault.model.SecretVersionSummary;
import com.oracle.bmc.vault.requests.CancelSecretDeletionRequest;
import com.oracle.bmc.vault.requests.CancelSecretVersionDeletionRequest;
import com.oracle.bmc.vault.requests.ChangeSecretCompartmentRequest;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.requests.GetSecretRequest;
import com.oracle.bmc.vault.requests.GetSecretVersionRequest;
import com.oracle.bmc.vault.requests.ListSecretVersionsRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretDeletionRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretVersionDeletionRequest;
import com.oracle.bmc.vault.requests.UpdateSecretRequest;
import com.oracle.bmc.vault.responses.CancelSecretDeletionResponse;
import com.oracle.bmc.vault.responses.CancelSecretVersionDeletionResponse;
import com.oracle.bmc.vault.responses.ChangeSecretCompartmentResponse;
import com.oracle.bmc.vault.responses.CreateSecretResponse;
import com.oracle.bmc.vault.responses.GetSecretResponse;
import com.oracle.bmc.vault.responses.GetSecretVersionResponse;
import com.oracle.bmc.vault.responses.ListSecretVersionsResponse;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretDeletionResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretVersionDeletionResponse;
import com.oracle.bmc.vault.responses.UpdateSecretResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultsAsyncClient
extends BaseAsyncClient
implements VaultsAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VAULTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://vaults.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VaultsAsyncClient.class);

    VaultsAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelSecretDeletionResponse> cancelSecretDeletion(CancelSecretDeletionRequest request, AsyncHandler<CancelSecretDeletionRequest, CancelSecretDeletionResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelSecretDeletionResponse::builder).logger(LOG, "cancelSecretDeletion").serviceDetails("Vaults", "CancelSecretDeletion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/CancelSecretDeletion").method(Method.POST).requestBuilder(CancelSecretDeletionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("etag", CancelSecretDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelSecretDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelSecretVersionDeletionResponse> cancelSecretVersionDeletion(CancelSecretVersionDeletionRequest request, AsyncHandler<CancelSecretVersionDeletionRequest, CancelSecretVersionDeletionResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelSecretVersionDeletionResponse::builder).logger(LOG, "cancelSecretVersionDeletion").serviceDetails("Vaults", "CancelSecretVersionDeletion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretVersion/CancelSecretVersionDeletion").method(Method.POST).requestBuilder(CancelSecretVersionDeletionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("version").appendPathParam((Number)request.getSecretVersionNumber()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("etag", CancelSecretVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelSecretVersionDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeSecretCompartmentResponse> changeSecretCompartment(ChangeSecretCompartmentRequest request, AsyncHandler<ChangeSecretCompartmentRequest, ChangeSecretCompartmentResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSecretCompartmentDetails(), "changeSecretCompartmentDetails is required");
        return this.clientCall(request, ChangeSecretCompartmentResponse::builder).logger(LOG, "changeSecretCompartment").serviceDetails("Vaults", "ChangeSecretCompartment", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/ChangeSecretCompartment").method(Method.POST).requestBuilder(ChangeSecretCompartmentRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeSecretCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeSecretCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateSecretResponse> createSecret(CreateSecretRequest request, AsyncHandler<CreateSecretRequest, CreateSecretResponse> handler) {
        Objects.requireNonNull(request.getCreateSecretDetails(), "createSecretDetails is required");
        return this.clientCall(request, CreateSecretResponse::builder).logger(LOG, "createSecret").serviceDetails("Vaults", "CreateSecret", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/CreateSecret").method(Method.POST).requestBuilder(CreateSecretRequest::builder).basePath("/20180608").appendPathParam("secrets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Secret.class, CreateSecretResponse.Builder::secret).handleResponseHeaderString("etag", CreateSecretResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSecretResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSecretResponse> getSecret(GetSecretRequest request, AsyncHandler<GetSecretRequest, GetSecretResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSecretResponse::builder).logger(LOG, "getSecret").serviceDetails("Vaults", "GetSecret", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/GetSecret").method(Method.GET).requestBuilder(GetSecretRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Secret.class, GetSecretResponse.Builder::secret).handleResponseHeaderString("etag", GetSecretResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecretResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSecretVersionResponse> getSecretVersion(GetSecretVersionRequest request, AsyncHandler<GetSecretVersionRequest, GetSecretVersionResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSecretVersionResponse::builder).logger(LOG, "getSecretVersion").serviceDetails("Vaults", "GetSecretVersion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretVersion/GetSecretVersion").method(Method.GET).requestBuilder(GetSecretVersionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("version").appendPathParam((Number)request.getSecretVersionNumber()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SecretVersion.class, GetSecretVersionResponse.Builder::secretVersion).handleResponseHeaderString("etag", GetSecretVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecretVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSecretVersionsResponse> listSecretVersions(ListSecretVersionsRequest request, AsyncHandler<ListSecretVersionsRequest, ListSecretVersionsResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSecretVersionsResponse::builder).logger(LOG, "listSecretVersions").serviceDetails("Vaults", "ListSecretVersions", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretVersionSummary/ListSecretVersions").method(Method.GET).requestBuilder(ListSecretVersionsRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("versions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SecretVersionSummary.class, ListSecretVersionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSecretVersionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSecretVersionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSecretsResponse> listSecrets(ListSecretsRequest request, AsyncHandler<ListSecretsRequest, ListSecretsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListSecretsResponse::builder).logger(LOG, "listSecrets").serviceDetails("Vaults", "ListSecrets", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretSummary/ListSecrets").method(Method.GET).requestBuilder(ListSecretsRequest::builder).basePath("/20180608").appendPathParam("secrets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("vaultId", (Object)request.getVaultId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(SecretSummary.class, ListSecretsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSecretsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSecretsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleSecretDeletionResponse> scheduleSecretDeletion(ScheduleSecretDeletionRequest request, AsyncHandler<ScheduleSecretDeletionRequest, ScheduleSecretDeletionResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleSecretDeletionDetails(), "scheduleSecretDeletionDetails is required");
        return this.clientCall(request, ScheduleSecretDeletionResponse::builder).logger(LOG, "scheduleSecretDeletion").serviceDetails("Vaults", "ScheduleSecretDeletion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/ScheduleSecretDeletion").method(Method.POST).requestBuilder(ScheduleSecretDeletionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ScheduleSecretDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleSecretDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScheduleSecretVersionDeletionResponse> scheduleSecretVersionDeletion(ScheduleSecretVersionDeletionRequest request, AsyncHandler<ScheduleSecretVersionDeletionRequest, ScheduleSecretVersionDeletionResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleSecretVersionDeletionDetails(), "scheduleSecretVersionDeletionDetails is required");
        return this.clientCall(request, ScheduleSecretVersionDeletionResponse::builder).logger(LOG, "scheduleSecretVersionDeletion").serviceDetails("Vaults", "ScheduleSecretVersionDeletion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretVersion/ScheduleSecretVersionDeletion").method(Method.POST).requestBuilder(ScheduleSecretVersionDeletionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("version").appendPathParam((Number)request.getSecretVersionNumber()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ScheduleSecretVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleSecretVersionDeletionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateSecretResponse> updateSecret(UpdateSecretRequest request, AsyncHandler<UpdateSecretRequest, UpdateSecretResponse> handler) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSecretDetails(), "updateSecretDetails is required");
        return this.clientCall(request, UpdateSecretResponse::builder).logger(LOG, "updateSecret").serviceDetails("Vaults", "UpdateSecret", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/UpdateSecret").method(Method.PUT).requestBuilder(UpdateSecretRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Secret.class, UpdateSecretResponse.Builder::secret).handleResponseHeaderString("etag", UpdateSecretResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSecretResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public VaultsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VaultsAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VaultsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VaultsAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VaultsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VaultsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VaultsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VaultsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VaultsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VaultsAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VaultsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public VaultsAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VaultsAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

