/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vault.model.RotationConfig;
import com.oracle.bmc.vault.model.SecretContentDetails;
import com.oracle.bmc.vault.model.SecretRule;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateSecretDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="metadata")
    private final Map<String, Object> metadata;
    @JsonProperty(value="secretContent")
    private final SecretContentDetails secretContent;
    @JsonProperty(value="rotationConfig")
    private final RotationConfig rotationConfig;
    @JsonProperty(value="secretName")
    private final String secretName;
    @JsonProperty(value="secretRules")
    private final List<SecretRule> secretRules;
    @JsonProperty(value="vaultId")
    private final String vaultId;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTags", "description", "freeformTags", "keyId", "metadata", "secretContent", "rotationConfig", "secretName", "secretRules", "vaultId"})
    public CreateSecretDetails(String compartmentId, Map<String, Map<String, Object>> definedTags, String description, Map<String, String> freeformTags, String keyId, Map<String, Object> metadata, SecretContentDetails secretContent, RotationConfig rotationConfig, String secretName, List<SecretRule> secretRules, String vaultId) {
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.description = description;
        this.freeformTags = freeformTags;
        this.keyId = keyId;
        this.metadata = metadata;
        this.secretContent = secretContent;
        this.rotationConfig = rotationConfig;
        this.secretName = secretName;
        this.secretRules = secretRules;
        this.vaultId = vaultId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public SecretContentDetails getSecretContent() {
        return this.secretContent;
    }

    public RotationConfig getRotationConfig() {
        return this.rotationConfig;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public List<SecretRule> getSecretRules() {
        return this.secretRules;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateSecretDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", keyId=").append(String.valueOf(this.keyId));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(", secretContent=").append(String.valueOf((Object)this.secretContent));
        sb.append(", rotationConfig=").append(String.valueOf((Object)this.rotationConfig));
        sb.append(", secretName=").append(String.valueOf(this.secretName));
        sb.append(", secretRules=").append(String.valueOf(this.secretRules));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSecretDetails)) {
            return false;
        }
        CreateSecretDetails other = (CreateSecretDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.description, other.description) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.keyId, other.keyId) && Objects.equals(this.metadata, other.metadata) && Objects.equals((Object)this.secretContent, (Object)other.secretContent) && Objects.equals((Object)this.rotationConfig, (Object)other.rotationConfig) && Objects.equals(this.secretName, other.secretName) && Objects.equals(this.secretRules, other.secretRules) && Objects.equals(this.vaultId, other.vaultId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.secretContent == null ? 43 : this.secretContent.hashCode());
        result = result * 59 + (this.rotationConfig == null ? 43 : this.rotationConfig.hashCode());
        result = result * 59 + (this.secretName == null ? 43 : this.secretName.hashCode());
        result = result * 59 + (this.secretRules == null ? 43 : this.secretRules.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="metadata")
        private Map<String, Object> metadata;
        @JsonProperty(value="secretContent")
        private SecretContentDetails secretContent;
        @JsonProperty(value="rotationConfig")
        private RotationConfig rotationConfig;
        @JsonProperty(value="secretName")
        private String secretName;
        @JsonProperty(value="secretRules")
        private List<SecretRule> secretRules;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder secretContent(SecretContentDetails secretContent) {
            this.secretContent = secretContent;
            this.__explicitlySet__.add("secretContent");
            return this;
        }

        public Builder rotationConfig(RotationConfig rotationConfig) {
            this.rotationConfig = rotationConfig;
            this.__explicitlySet__.add("rotationConfig");
            return this;
        }

        public Builder secretName(String secretName) {
            this.secretName = secretName;
            this.__explicitlySet__.add("secretName");
            return this;
        }

        public Builder secretRules(List<SecretRule> secretRules) {
            this.secretRules = secretRules;
            this.__explicitlySet__.add("secretRules");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public CreateSecretDetails build() {
            CreateSecretDetails model = new CreateSecretDetails(this.compartmentId, this.definedTags, this.description, this.freeformTags, this.keyId, this.metadata, this.secretContent, this.rotationConfig, this.secretName, this.secretRules, this.vaultId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateSecretDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("keyId")) {
                this.keyId(model.getKeyId());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("secretContent")) {
                this.secretContent(model.getSecretContent());
            }
            if (model.wasPropertyExplicitlySet("rotationConfig")) {
                this.rotationConfig(model.getRotationConfig());
            }
            if (model.wasPropertyExplicitlySet("secretName")) {
                this.secretName(model.getSecretName());
            }
            if (model.wasPropertyExplicitlySet("secretRules")) {
                this.secretRules(model.getSecretRules());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            return this;
        }
    }
}

