/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vault.model.TargetSystemDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RotationConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="rotationInterval")
    private final String rotationInterval;
    @JsonProperty(value="targetSystemDetails")
    private final TargetSystemDetails targetSystemDetails;
    @JsonProperty(value="isScheduledRotationEnabled")
    private final Boolean isScheduledRotationEnabled;

    @Deprecated
    @ConstructorProperties(value={"rotationInterval", "targetSystemDetails", "isScheduledRotationEnabled"})
    public RotationConfig(String rotationInterval, TargetSystemDetails targetSystemDetails, Boolean isScheduledRotationEnabled) {
        this.rotationInterval = rotationInterval;
        this.targetSystemDetails = targetSystemDetails;
        this.isScheduledRotationEnabled = isScheduledRotationEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRotationInterval() {
        return this.rotationInterval;
    }

    public TargetSystemDetails getTargetSystemDetails() {
        return this.targetSystemDetails;
    }

    public Boolean getIsScheduledRotationEnabled() {
        return this.isScheduledRotationEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RotationConfig(");
        sb.append("super=").append(super.toString());
        sb.append("rotationInterval=").append(String.valueOf(this.rotationInterval));
        sb.append(", targetSystemDetails=").append(String.valueOf((Object)this.targetSystemDetails));
        sb.append(", isScheduledRotationEnabled=").append(String.valueOf(this.isScheduledRotationEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RotationConfig)) {
            return false;
        }
        RotationConfig other = (RotationConfig)((Object)o);
        return Objects.equals(this.rotationInterval, other.rotationInterval) && Objects.equals((Object)this.targetSystemDetails, (Object)other.targetSystemDetails) && Objects.equals(this.isScheduledRotationEnabled, other.isScheduledRotationEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.rotationInterval == null ? 43 : this.rotationInterval.hashCode());
        result = result * 59 + (this.targetSystemDetails == null ? 43 : this.targetSystemDetails.hashCode());
        result = result * 59 + (this.isScheduledRotationEnabled == null ? 43 : this.isScheduledRotationEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="rotationInterval")
        private String rotationInterval;
        @JsonProperty(value="targetSystemDetails")
        private TargetSystemDetails targetSystemDetails;
        @JsonProperty(value="isScheduledRotationEnabled")
        private Boolean isScheduledRotationEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder rotationInterval(String rotationInterval) {
            this.rotationInterval = rotationInterval;
            this.__explicitlySet__.add("rotationInterval");
            return this;
        }

        public Builder targetSystemDetails(TargetSystemDetails targetSystemDetails) {
            this.targetSystemDetails = targetSystemDetails;
            this.__explicitlySet__.add("targetSystemDetails");
            return this;
        }

        public Builder isScheduledRotationEnabled(Boolean isScheduledRotationEnabled) {
            this.isScheduledRotationEnabled = isScheduledRotationEnabled;
            this.__explicitlySet__.add("isScheduledRotationEnabled");
            return this;
        }

        public RotationConfig build() {
            RotationConfig model = new RotationConfig(this.rotationInterval, this.targetSystemDetails, this.isScheduledRotationEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RotationConfig model) {
            if (model.wasPropertyExplicitlySet("rotationInterval")) {
                this.rotationInterval(model.getRotationInterval());
            }
            if (model.wasPropertyExplicitlySet("targetSystemDetails")) {
                this.targetSystemDetails(model.getTargetSystemDetails());
            }
            if (model.wasPropertyExplicitlySet("isScheduledRotationEnabled")) {
                this.isScheduledRotationEnabled(model.getIsScheduledRotationEnabled());
            }
            return this;
        }
    }
}

