/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vault.Vaults;
import com.oracle.bmc.vault.model.Secret;
import com.oracle.bmc.vault.requests.GetSecretRequest;
import com.oracle.bmc.vault.requests.RotateSecretRequest;
import com.oracle.bmc.vault.responses.GetSecretResponse;
import com.oracle.bmc.vault.responses.RotateSecretResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VaultsWaiters {
    @Nonnull
    private final ExecutorService executorService;
    @Nonnull
    private final Vaults client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public VaultsWaiters(@Nonnull ExecutorService executorService, @Nonnull Vaults client) {
        this(executorService, client, null);
    }

    public VaultsWaiters(@Nonnull ExecutorService executorService, @Nonnull Vaults client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<GetSecretRequest, GetSecretResponse> forSecret(GetSecretRequest request, Secret.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecret(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecretRequest, GetSecretResponse> forSecret(GetSecretRequest request, Secret.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecret(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecretRequest, GetSecretResponse> forSecret(GetSecretRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Secret.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSecret(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecretRequest, GetSecretResponse> forSecret(BmcGenericWaiter waiter, GetSecretRequest request, Secret.LifecycleState ... targetStates) {
        final HashSet<Secret.LifecycleState> targetStatesSet = new HashSet<Secret.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecretRequest, GetSecretResponse>(){

            @Override
            public GetSecretResponse apply(GetSecretRequest request) {
                return VaultsWaiters.this.client.getSecret(request);
            }
        }, (Predicate)new Predicate<GetSecretResponse>(){

            @Override
            public boolean test(GetSecretResponse response) {
                return targetStatesSet.contains((Object)response.getSecret().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Secret.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<RotateSecretRequest, RotateSecretResponse> forRotateSecret(RotateSecretRequest request) {
        return this.forRotateSecret(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<RotateSecretRequest, RotateSecretResponse> forRotateSecret(final RotateSecretRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<RotateSecretResponse>(){

            @Override
            public RotateSecretResponse call() throws Exception {
                RotateSecretResponse response = VaultsWaiters.this.client.rotateSecret(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VaultsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }
}

