/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecretVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="contentType")
    private final ContentType contentType;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="stages")
    private final List<Stages> stages;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="timeOfExpiry")
    private final Date timeOfExpiry;
    @JsonProperty(value="versionNumber")
    private final Long versionNumber;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="isContentAutoGenerated")
    private final Boolean isContentAutoGenerated;

    @Deprecated
    @ConstructorProperties(value={"contentType", "name", "secretId", "stages", "timeCreated", "timeOfDeletion", "timeOfExpiry", "versionNumber", "systemTags", "isContentAutoGenerated"})
    public SecretVersionSummary(ContentType contentType, String name, String secretId, List<Stages> stages, Date timeCreated, Date timeOfDeletion, Date timeOfExpiry, Long versionNumber, Map<String, Map<String, Object>> systemTags, Boolean isContentAutoGenerated) {
        this.contentType = contentType;
        this.name = name;
        this.secretId = secretId;
        this.stages = stages;
        this.timeCreated = timeCreated;
        this.timeOfDeletion = timeOfDeletion;
        this.timeOfExpiry = timeOfExpiry;
        this.versionNumber = versionNumber;
        this.systemTags = systemTags;
        this.isContentAutoGenerated = isContentAutoGenerated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public List<Stages> getStages() {
        return this.stages;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public Date getTimeOfExpiry() {
        return this.timeOfExpiry;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Boolean getIsContentAutoGenerated() {
        return this.isContentAutoGenerated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecretVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("contentType=").append(String.valueOf((Object)this.contentType));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", secretId=").append(String.valueOf(this.secretId));
        sb.append(", stages=").append(String.valueOf(this.stages));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeOfDeletion=").append(String.valueOf(this.timeOfDeletion));
        sb.append(", timeOfExpiry=").append(String.valueOf(this.timeOfExpiry));
        sb.append(", versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", isContentAutoGenerated=").append(String.valueOf(this.isContentAutoGenerated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecretVersionSummary)) {
            return false;
        }
        SecretVersionSummary other = (SecretVersionSummary)((Object)o);
        return Objects.equals((Object)this.contentType, (Object)other.contentType) && Objects.equals(this.name, other.name) && Objects.equals(this.secretId, other.secretId) && Objects.equals(this.stages, other.stages) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeOfDeletion, other.timeOfDeletion) && Objects.equals(this.timeOfExpiry, other.timeOfExpiry) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.isContentAutoGenerated, other.isContentAutoGenerated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.stages == null ? 43 : this.stages.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeOfDeletion == null ? 43 : this.timeOfDeletion.hashCode());
        result = result * 59 + (this.timeOfExpiry == null ? 43 : this.timeOfExpiry.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.isContentAutoGenerated == null ? 43 : this.isContentAutoGenerated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Stages implements BmcEnum
    {
        Current("CURRENT"),
        Pending("PENDING"),
        Latest("LATEST"),
        Previous("PREVIOUS"),
        Deprecated("DEPRECATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Stages> map;

        private Stages(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stages create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Stages', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Stages.class);
            map = new HashMap<String, Stages>();
            for (Stages v : Stages.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ContentType implements BmcEnum
    {
        Base64("BASE64"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ContentType> map;

        private ContentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ContentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ContentType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ContentType.class);
            map = new HashMap<String, ContentType>();
            for (ContentType v : ContentType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="contentType")
        private ContentType contentType;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="stages")
        private List<Stages> stages;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="timeOfExpiry")
        private Date timeOfExpiry;
        @JsonProperty(value="versionNumber")
        private Long versionNumber;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="isContentAutoGenerated")
        private Boolean isContentAutoGenerated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder contentType(ContentType contentType) {
            this.contentType = contentType;
            this.__explicitlySet__.add("contentType");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder stages(List<Stages> stages) {
            this.stages = stages;
            this.__explicitlySet__.add("stages");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder timeOfExpiry(Date timeOfExpiry) {
            this.timeOfExpiry = timeOfExpiry;
            this.__explicitlySet__.add("timeOfExpiry");
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            this.__explicitlySet__.add("versionNumber");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder isContentAutoGenerated(Boolean isContentAutoGenerated) {
            this.isContentAutoGenerated = isContentAutoGenerated;
            this.__explicitlySet__.add("isContentAutoGenerated");
            return this;
        }

        public SecretVersionSummary build() {
            SecretVersionSummary model = new SecretVersionSummary(this.contentType, this.name, this.secretId, this.stages, this.timeCreated, this.timeOfDeletion, this.timeOfExpiry, this.versionNumber, this.systemTags, this.isContentAutoGenerated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecretVersionSummary model) {
            if (model.wasPropertyExplicitlySet("contentType")) {
                this.contentType(model.getContentType());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("secretId")) {
                this.secretId(model.getSecretId());
            }
            if (model.wasPropertyExplicitlySet("stages")) {
                this.stages(model.getStages());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeOfDeletion")) {
                this.timeOfDeletion(model.getTimeOfDeletion());
            }
            if (model.wasPropertyExplicitlySet("timeOfExpiry")) {
                this.timeOfExpiry(model.getTimeOfExpiry());
            }
            if (model.wasPropertyExplicitlySet("versionNumber")) {
                this.versionNumber(model.getVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("isContentAutoGenerated")) {
                this.isContentAutoGenerated(model.getIsContentAutoGenerated());
            }
            return this;
        }
    }
}

