/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vault.Vaults;
import com.oracle.bmc.vault.VaultsPaginators;
import com.oracle.bmc.vault.VaultsWaiters;
import com.oracle.bmc.vault.model.Secret;
import com.oracle.bmc.vault.model.SecretSummary;
import com.oracle.bmc.vault.model.SecretVersion;
import com.oracle.bmc.vault.model.SecretVersionSummary;
import com.oracle.bmc.vault.requests.CancelSecretDeletionRequest;
import com.oracle.bmc.vault.requests.CancelSecretRotationRequest;
import com.oracle.bmc.vault.requests.CancelSecretVersionDeletionRequest;
import com.oracle.bmc.vault.requests.ChangeSecretCompartmentRequest;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.requests.GetSecretRequest;
import com.oracle.bmc.vault.requests.GetSecretVersionRequest;
import com.oracle.bmc.vault.requests.ListSecretVersionsRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.RotateSecretRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretDeletionRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretVersionDeletionRequest;
import com.oracle.bmc.vault.requests.UpdateSecretRequest;
import com.oracle.bmc.vault.responses.CancelSecretDeletionResponse;
import com.oracle.bmc.vault.responses.CancelSecretRotationResponse;
import com.oracle.bmc.vault.responses.CancelSecretVersionDeletionResponse;
import com.oracle.bmc.vault.responses.ChangeSecretCompartmentResponse;
import com.oracle.bmc.vault.responses.CreateSecretResponse;
import com.oracle.bmc.vault.responses.GetSecretResponse;
import com.oracle.bmc.vault.responses.GetSecretVersionResponse;
import com.oracle.bmc.vault.responses.ListSecretVersionsResponse;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import com.oracle.bmc.vault.responses.RotateSecretResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretDeletionResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretVersionDeletionResponse;
import com.oracle.bmc.vault.responses.UpdateSecretResponse;
import com.oracle.bmc.workrequests.WorkRequest;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultsClient
extends BaseSyncClient
implements Vaults {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VAULTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://vaults.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VaultsClient.class);
    protected final ExecutorService executorService;
    private final VaultsWaiters waiters;
    private final VaultsPaginators paginators;

    VaultsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Vaults-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new VaultsWaiters(executorService, this);
        this.paginators = new VaultsPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelSecretDeletionResponse cancelSecretDeletion(CancelSecretDeletionRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (CancelSecretDeletionResponse)this.clientCall(request, CancelSecretDeletionResponse::builder).logger(LOG, "cancelSecretDeletion").serviceDetails("Vaults", "CancelSecretDeletion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/CancelSecretDeletion").method(Method.POST).requestBuilder(CancelSecretDeletionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("etag", CancelSecretDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelSecretDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelSecretRotationResponse cancelSecretRotation(CancelSecretRotationRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (CancelSecretRotationResponse)this.clientCall(request, CancelSecretRotationResponse::builder).logger(LOG, "cancelSecretRotation").serviceDetails("Vaults", "CancelSecretRotation", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/CancelSecretRotation").method(Method.POST).requestBuilder(CancelSecretRotationRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("actions").appendPathParam("cancelRotation").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelSecretRotationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelSecretVersionDeletionResponse cancelSecretVersionDeletion(CancelSecretVersionDeletionRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (CancelSecretVersionDeletionResponse)this.clientCall(request, CancelSecretVersionDeletionResponse::builder).logger(LOG, "cancelSecretVersionDeletion").serviceDetails("Vaults", "CancelSecretVersionDeletion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretVersion/CancelSecretVersionDeletion").method(Method.POST).requestBuilder(CancelSecretVersionDeletionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("version").appendPathParam((Number)request.getSecretVersionNumber()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("etag", CancelSecretVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelSecretVersionDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeSecretCompartmentResponse changeSecretCompartment(ChangeSecretCompartmentRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSecretCompartmentDetails(), "changeSecretCompartmentDetails is required");
        return (ChangeSecretCompartmentResponse)this.clientCall(request, ChangeSecretCompartmentResponse::builder).logger(LOG, "changeSecretCompartment").serviceDetails("Vaults", "ChangeSecretCompartment", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/ChangeSecretCompartment").method(Method.POST).requestBuilder(ChangeSecretCompartmentRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeSecretCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeSecretCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSecretResponse createSecret(CreateSecretRequest request) {
        Objects.requireNonNull(request.getCreateSecretDetails(), "createSecretDetails is required");
        return (CreateSecretResponse)this.clientCall(request, CreateSecretResponse::builder).logger(LOG, "createSecret").serviceDetails("Vaults", "CreateSecret", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/CreateSecret").method(Method.POST).requestBuilder(CreateSecretRequest::builder).basePath("/20180608").appendPathParam("secrets").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(Secret.class, CreateSecretResponse.Builder::secret).handleResponseHeaderString("etag", CreateSecretResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateSecretResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSecretResponse getSecret(GetSecretRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (GetSecretResponse)this.clientCall(request, GetSecretResponse::builder).logger(LOG, "getSecret").serviceDetails("Vaults", "GetSecret", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/GetSecret").method(Method.GET).requestBuilder(GetSecretRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Secret.class, GetSecretResponse.Builder::secret).handleResponseHeaderString("etag", GetSecretResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecretResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSecretVersionResponse getSecretVersion(GetSecretVersionRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (GetSecretVersionResponse)this.clientCall(request, GetSecretVersionResponse::builder).logger(LOG, "getSecretVersion").serviceDetails("Vaults", "GetSecretVersion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretVersion/GetSecretVersion").method(Method.GET).requestBuilder(GetSecretVersionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("version").appendPathParam((Number)request.getSecretVersionNumber()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SecretVersion.class, GetSecretVersionResponse.Builder::secretVersion).handleResponseHeaderString("etag", GetSecretVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSecretVersionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSecretVersionsResponse listSecretVersions(ListSecretVersionsRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (ListSecretVersionsResponse)this.clientCall(request, ListSecretVersionsResponse::builder).logger(LOG, "listSecretVersions").serviceDetails("Vaults", "ListSecretVersions", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretVersionSummary/ListSecretVersions").method(Method.GET).requestBuilder(ListSecretVersionsRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("versions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(SecretVersionSummary.class, ListSecretVersionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSecretVersionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSecretVersionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSecretsResponse listSecrets(ListSecretsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSecretsResponse)this.clientCall(request, ListSecretsResponse::builder).logger(LOG, "listSecrets").serviceDetails("Vaults", "ListSecrets", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretSummary/ListSecrets").method(Method.GET).requestBuilder(ListSecretsRequest::builder).basePath("/20180608").appendPathParam("secrets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("vaultId", (Object)request.getVaultId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(SecretSummary.class, ListSecretsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListSecretsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSecretsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RotateSecretResponse rotateSecret(RotateSecretRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        return (RotateSecretResponse)this.clientCall(request, RotateSecretResponse::builder).logger(LOG, "rotateSecret").serviceDetails("Vaults", "RotateSecret", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/RotateSecret").method(Method.POST).requestBuilder(RotateSecretRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("actions").appendPathParam("rotate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", RotateSecretResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RotateSecretResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ScheduleSecretDeletionResponse scheduleSecretDeletion(ScheduleSecretDeletionRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleSecretDeletionDetails(), "scheduleSecretDeletionDetails is required");
        return (ScheduleSecretDeletionResponse)this.clientCall(request, ScheduleSecretDeletionResponse::builder).logger(LOG, "scheduleSecretDeletion").serviceDetails("Vaults", "ScheduleSecretDeletion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/ScheduleSecretDeletion").method(Method.POST).requestBuilder(ScheduleSecretDeletionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ScheduleSecretDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleSecretDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ScheduleSecretVersionDeletionResponse scheduleSecretVersionDeletion(ScheduleSecretVersionDeletionRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScheduleSecretVersionDeletionDetails(), "scheduleSecretVersionDeletionDetails is required");
        return (ScheduleSecretVersionDeletionResponse)this.clientCall(request, ScheduleSecretVersionDeletionResponse::builder).logger(LOG, "scheduleSecretVersionDeletion").serviceDetails("Vaults", "ScheduleSecretVersionDeletion", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/SecretVersion/ScheduleSecretVersionDeletion").method(Method.POST).requestBuilder(ScheduleSecretVersionDeletionRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).appendPathParam("version").appendPathParam((Number)request.getSecretVersionNumber()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("etag", ScheduleSecretVersionDeletionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ScheduleSecretVersionDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateSecretResponse updateSecret(UpdateSecretRequest request) {
        Validate.notBlank((String)request.getSecretId(), (String)"secretId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSecretDetails(), "updateSecretDetails is required");
        return (UpdateSecretResponse)this.clientCall(request, UpdateSecretResponse::builder).logger(LOG, "updateSecret").serviceDetails("Vaults", "UpdateSecret", "https://docs.oracle.com/iaas/api/#/en/secretmgmt/20180608/Secret/UpdateSecret").method(Method.PUT).requestBuilder(UpdateSecretRequest::builder).basePath("/20180608").appendPathParam("secrets").appendPathParam(request.getSecretId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Secret.class, UpdateSecretResponse.Builder::secret).handleResponseHeaderString("etag", UpdateSecretResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateSecretResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public VaultsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public VaultsWaiters newWaiters(WorkRequest workRequestClient) {
        return new VaultsWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public VaultsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public VaultsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VaultsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VaultsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VaultsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VaultsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VaultsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VaultsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VaultsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VaultsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VaultsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VaultsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VaultsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VaultsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VaultsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VaultsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VaultsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VaultsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "vault";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"vault");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public VaultsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VaultsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

