/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vault.model.BytesGenerationContext;
import com.oracle.bmc.vault.model.PassphraseGenerationContext;
import com.oracle.bmc.vault.model.SshKeyGenerationContext;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="generationType", defaultImpl=SecretGenerationContext.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PassphraseGenerationContext.class, name="PASSPHRASE"), @JsonSubTypes.Type(value=SshKeyGenerationContext.class, name="SSH_KEY"), @JsonSubTypes.Type(value=BytesGenerationContext.class, name="BYTES")})
@JsonFilter(value="explicitlySetFilter")
public class SecretGenerationContext
extends ExplicitlySetBmcModel {
    @JsonProperty(value="secretTemplate")
    private final String secretTemplate;

    @Deprecated
    @ConstructorProperties(value={"secretTemplate"})
    protected SecretGenerationContext(String secretTemplate) {
        this.secretTemplate = secretTemplate;
    }

    public String getSecretTemplate() {
        return this.secretTemplate;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecretGenerationContext(");
        sb.append("super=").append(super.toString());
        sb.append("secretTemplate=").append(String.valueOf(this.secretTemplate));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecretGenerationContext)) {
            return false;
        }
        SecretGenerationContext other = (SecretGenerationContext)((Object)o);
        return Objects.equals(this.secretTemplate, other.secretTemplate) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.secretTemplate == null ? 43 : this.secretTemplate.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum GenerationType implements BmcEnum
    {
        Passphrase("PASSPHRASE"),
        SshKey("SSH_KEY"),
        Bytes("BYTES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, GenerationType> map;

        private GenerationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GenerationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'GenerationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(GenerationType.class);
            map = new HashMap<String, GenerationType>();
            for (GenerationType v : GenerationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

