/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.vault.model.SecretGenerationContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="generationType")
@JsonFilter(value="explicitlySetFilter")
public final class SshKeyGenerationContext
extends SecretGenerationContext {
    @JsonProperty(value="generationTemplate")
    private final GenerationTemplate generationTemplate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SshKeyGenerationContext(String secretTemplate, GenerationTemplate generationTemplate) {
        super(secretTemplate);
        this.generationTemplate = generationTemplate;
    }

    public GenerationTemplate getGenerationTemplate() {
        return this.generationTemplate;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SshKeyGenerationContext(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", generationTemplate=").append(String.valueOf((Object)this.generationTemplate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SshKeyGenerationContext)) {
            return false;
        }
        SshKeyGenerationContext other = (SshKeyGenerationContext)((Object)o);
        return Objects.equals((Object)this.generationTemplate, (Object)other.generationTemplate) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.generationTemplate == null ? 43 : this.generationTemplate.hashCode());
        return result;
    }

    public static enum GenerationTemplate implements BmcEnum
    {
        Rsa2048("RSA_2048"),
        Rsa3072("RSA_3072"),
        Rsa4096("RSA_4096"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, GenerationTemplate> map;

        private GenerationTemplate(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GenerationTemplate create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'GenerationTemplate', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(GenerationTemplate.class);
            map = new HashMap<String, GenerationTemplate>();
            for (GenerationTemplate v : GenerationTemplate.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="secretTemplate")
        private String secretTemplate;
        @JsonProperty(value="generationTemplate")
        private GenerationTemplate generationTemplate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder secretTemplate(String secretTemplate) {
            this.secretTemplate = secretTemplate;
            this.__explicitlySet__.add("secretTemplate");
            return this;
        }

        public Builder generationTemplate(GenerationTemplate generationTemplate) {
            this.generationTemplate = generationTemplate;
            this.__explicitlySet__.add("generationTemplate");
            return this;
        }

        public SshKeyGenerationContext build() {
            SshKeyGenerationContext model = new SshKeyGenerationContext(this.secretTemplate, this.generationTemplate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SshKeyGenerationContext model) {
            if (model.wasPropertyExplicitlySet("secretTemplate")) {
                this.secretTemplate(model.getSecretTemplate());
            }
            if (model.wasPropertyExplicitlySet("generationTemplate")) {
                this.generationTemplate(model.getGenerationTemplate());
            }
            return this;
        }
    }
}

