/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vbsinst;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vbsinst.VbsInstanceAsync;
import com.oracle.bmc.vbsinst.model.VbsInstance;
import com.oracle.bmc.vbsinst.model.VbsInstanceSummaryCollection;
import com.oracle.bmc.vbsinst.model.WorkRequest;
import com.oracle.bmc.vbsinst.model.WorkRequestErrorCollection;
import com.oracle.bmc.vbsinst.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.vbsinst.model.WorkRequestSummaryCollection;
import com.oracle.bmc.vbsinst.requests.ChangeVbsInstanceCompartmentRequest;
import com.oracle.bmc.vbsinst.requests.CreateVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.DeleteVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.GetVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.GetWorkRequestRequest;
import com.oracle.bmc.vbsinst.requests.ListVbsInstancesRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestsRequest;
import com.oracle.bmc.vbsinst.requests.UpdateVbsInstanceRequest;
import com.oracle.bmc.vbsinst.responses.ChangeVbsInstanceCompartmentResponse;
import com.oracle.bmc.vbsinst.responses.CreateVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.DeleteVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.GetVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.GetWorkRequestResponse;
import com.oracle.bmc.vbsinst.responses.ListVbsInstancesResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestsResponse;
import com.oracle.bmc.vbsinst.responses.UpdateVbsInstanceResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VbsInstanceAsyncClient
extends BaseAsyncClient
implements VbsInstanceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VBSINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://vbstudio.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VbsInstanceAsyncClient.class);

    VbsInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeVbsInstanceCompartmentResponse> changeVbsInstanceCompartment(ChangeVbsInstanceCompartmentRequest request, AsyncHandler<ChangeVbsInstanceCompartmentRequest, ChangeVbsInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getVbsInstanceId(), (String)"vbsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVbsInstanceCompartmentDetails(), "changeVbsInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeVbsInstanceCompartmentResponse::builder).logger(LOG, "changeVbsInstanceCompartment").serviceDetails("VbsInstance", "ChangeVbsInstanceCompartment", "").method(Method.POST).requestBuilder(ChangeVbsInstanceCompartmentRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendPathParam(request.getVbsInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVbsInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVbsInstanceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateVbsInstanceResponse> createVbsInstance(CreateVbsInstanceRequest request, AsyncHandler<CreateVbsInstanceRequest, CreateVbsInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateVbsInstanceDetails(), "createVbsInstanceDetails is required");
        return this.clientCall(request, CreateVbsInstanceResponse::builder).logger(LOG, "createVbsInstance").serviceDetails("VbsInstance", "CreateVbsInstance", "").method(Method.POST).requestBuilder(CreateVbsInstanceRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").accept(new String[]{"application/json"}).appendHeader("idcs-access-token", request.getIdcsAccessToken()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateVbsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVbsInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteVbsInstanceResponse> deleteVbsInstance(DeleteVbsInstanceRequest request, AsyncHandler<DeleteVbsInstanceRequest, DeleteVbsInstanceResponse> handler) {
        Validate.notBlank((String)request.getVbsInstanceId(), (String)"vbsInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteVbsInstanceResponse::builder).logger(LOG, "deleteVbsInstance").serviceDetails("VbsInstance", "DeleteVbsInstance", "").method(Method.DELETE).requestBuilder(DeleteVbsInstanceRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendPathParam(request.getVbsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVbsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVbsInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVbsInstanceResponse> getVbsInstance(GetVbsInstanceRequest request, AsyncHandler<GetVbsInstanceRequest, GetVbsInstanceResponse> handler) {
        Validate.notBlank((String)request.getVbsInstanceId(), (String)"vbsInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVbsInstanceResponse::builder).logger(LOG, "getVbsInstance").serviceDetails("VbsInstance", "GetVbsInstance", "").method(Method.GET).requestBuilder(GetVbsInstanceRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendPathParam(request.getVbsInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VbsInstance.class, GetVbsInstanceResponse.Builder::vbsInstance).handleResponseHeaderString("etag", GetVbsInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVbsInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("VbsInstance", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListVbsInstancesResponse> listVbsInstances(ListVbsInstancesRequest request, AsyncHandler<ListVbsInstancesRequest, ListVbsInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVbsInstancesResponse::builder).logger(LOG, "listVbsInstances").serviceDetails("VbsInstance", "ListVbsInstances", "").method(Method.GET).requestBuilder(ListVbsInstancesRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VbsInstanceSummaryCollection.class, ListVbsInstancesResponse.Builder::vbsInstanceSummaryCollection).handleResponseHeaderString("opc-request-id", ListVbsInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVbsInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("VbsInstance", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("VbsInstance", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("VbsInstance", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateVbsInstanceResponse> updateVbsInstance(UpdateVbsInstanceRequest request, AsyncHandler<UpdateVbsInstanceRequest, UpdateVbsInstanceResponse> handler) {
        Validate.notBlank((String)request.getVbsInstanceId(), (String)"vbsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVbsInstanceDetails(), "updateVbsInstanceDetails is required");
        return this.clientCall(request, UpdateVbsInstanceResponse::builder).logger(LOG, "updateVbsInstance").serviceDetails("VbsInstance", "UpdateVbsInstance", "").method(Method.PUT).requestBuilder(UpdateVbsInstanceRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendPathParam(request.getVbsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVbsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVbsInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public VbsInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VbsInstanceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VbsInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VbsInstanceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VbsInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VbsInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VbsInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VbsInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public VbsInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VbsInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public VbsInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VbsInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public VbsInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VbsInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VbsInstanceAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "vbsinst";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"vbsinst");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public VbsInstanceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VbsInstanceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

