/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vbsinst;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vbsinst.VbsInstancePaginators;
import com.oracle.bmc.vbsinst.VbsInstanceWaiters;
import com.oracle.bmc.vbsinst.model.VbsInstance;
import com.oracle.bmc.vbsinst.model.VbsInstanceSummaryCollection;
import com.oracle.bmc.vbsinst.model.WorkRequest;
import com.oracle.bmc.vbsinst.model.WorkRequestErrorCollection;
import com.oracle.bmc.vbsinst.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.vbsinst.model.WorkRequestSummaryCollection;
import com.oracle.bmc.vbsinst.requests.ChangeVbsInstanceCompartmentRequest;
import com.oracle.bmc.vbsinst.requests.CreateVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.DeleteVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.GetVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.GetWorkRequestRequest;
import com.oracle.bmc.vbsinst.requests.ListVbsInstancesRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.vbsinst.requests.ListWorkRequestsRequest;
import com.oracle.bmc.vbsinst.requests.UpdateVbsInstanceRequest;
import com.oracle.bmc.vbsinst.responses.ChangeVbsInstanceCompartmentResponse;
import com.oracle.bmc.vbsinst.responses.CreateVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.DeleteVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.GetVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.GetWorkRequestResponse;
import com.oracle.bmc.vbsinst.responses.ListVbsInstancesResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.vbsinst.responses.ListWorkRequestsResponse;
import com.oracle.bmc.vbsinst.responses.UpdateVbsInstanceResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VbsInstanceClient
extends BaseSyncClient
implements com.oracle.bmc.vbsinst.VbsInstance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VBSINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://vbstudio.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VbsInstanceClient.class);
    private final VbsInstanceWaiters waiters;
    private final VbsInstancePaginators paginators;

    VbsInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("VbsInstance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new VbsInstanceWaiters(executorService, this);
        this.paginators = new VbsInstancePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeVbsInstanceCompartmentResponse changeVbsInstanceCompartment(ChangeVbsInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getVbsInstanceId(), (String)"vbsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVbsInstanceCompartmentDetails(), "changeVbsInstanceCompartmentDetails is required");
        return (ChangeVbsInstanceCompartmentResponse)this.clientCall(request, ChangeVbsInstanceCompartmentResponse::builder).logger(LOG, "changeVbsInstanceCompartment").serviceDetails("VbsInstance", "ChangeVbsInstanceCompartment", "").method(Method.POST).requestBuilder(ChangeVbsInstanceCompartmentRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendPathParam(request.getVbsInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVbsInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVbsInstanceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVbsInstanceResponse createVbsInstance(CreateVbsInstanceRequest request) {
        Objects.requireNonNull(request.getCreateVbsInstanceDetails(), "createVbsInstanceDetails is required");
        return (CreateVbsInstanceResponse)this.clientCall(request, CreateVbsInstanceResponse::builder).logger(LOG, "createVbsInstance").serviceDetails("VbsInstance", "CreateVbsInstance", "").method(Method.POST).requestBuilder(CreateVbsInstanceRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").accept(new String[]{"application/json"}).appendHeader("idcs-access-token", request.getIdcsAccessToken()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateVbsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVbsInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVbsInstanceResponse deleteVbsInstance(DeleteVbsInstanceRequest request) {
        Validate.notBlank((String)request.getVbsInstanceId(), (String)"vbsInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteVbsInstanceResponse)this.clientCall(request, DeleteVbsInstanceResponse::builder).logger(LOG, "deleteVbsInstance").serviceDetails("VbsInstance", "DeleteVbsInstance", "").method(Method.DELETE).requestBuilder(DeleteVbsInstanceRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendPathParam(request.getVbsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVbsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVbsInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVbsInstanceResponse getVbsInstance(GetVbsInstanceRequest request) {
        Validate.notBlank((String)request.getVbsInstanceId(), (String)"vbsInstanceId must not be blank", (Object[])new Object[0]);
        return (GetVbsInstanceResponse)this.clientCall(request, GetVbsInstanceResponse::builder).logger(LOG, "getVbsInstance").serviceDetails("VbsInstance", "GetVbsInstance", "").method(Method.GET).requestBuilder(GetVbsInstanceRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendPathParam(request.getVbsInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VbsInstance.class, GetVbsInstanceResponse.Builder::vbsInstance).handleResponseHeaderString("etag", GetVbsInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVbsInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("VbsInstance", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListVbsInstancesResponse listVbsInstances(ListVbsInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVbsInstancesResponse)this.clientCall(request, ListVbsInstancesResponse::builder).logger(LOG, "listVbsInstances").serviceDetails("VbsInstance", "ListVbsInstances", "").method(Method.GET).requestBuilder(ListVbsInstancesRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VbsInstanceSummaryCollection.class, ListVbsInstancesResponse.Builder::vbsInstanceSummaryCollection).handleResponseHeaderString("opc-request-id", ListVbsInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVbsInstancesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("VbsInstance", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("VbsInstance", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("VbsInstance", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180828").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateVbsInstanceResponse updateVbsInstance(UpdateVbsInstanceRequest request) {
        Validate.notBlank((String)request.getVbsInstanceId(), (String)"vbsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVbsInstanceDetails(), "updateVbsInstanceDetails is required");
        return (UpdateVbsInstanceResponse)this.clientCall(request, UpdateVbsInstanceResponse::builder).logger(LOG, "updateVbsInstance").serviceDetails("VbsInstance", "UpdateVbsInstance", "").method(Method.PUT).requestBuilder(UpdateVbsInstanceRequest::builder).basePath("/20180828").appendPathParam("vbsInstances").appendPathParam(request.getVbsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVbsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVbsInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public VbsInstanceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public VbsInstancePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public VbsInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VbsInstanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbsInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VbsInstanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbsInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VbsInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbsInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VbsInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbsInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VbsInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbsInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VbsInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbsInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VbsInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbsInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VbsInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VbsInstanceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "vbsinst";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"vbsinst");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public VbsInstanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VbsInstanceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

