/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vbsinst;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vbsinst.VbsInstance;
import com.oracle.bmc.vbsinst.model.LifecycleState;
import com.oracle.bmc.vbsinst.requests.GetVbsInstanceRequest;
import com.oracle.bmc.vbsinst.requests.GetWorkRequestRequest;
import com.oracle.bmc.vbsinst.responses.GetVbsInstanceResponse;
import com.oracle.bmc.vbsinst.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VbsInstanceWaiters {
    private final ExecutorService executorService;
    private final VbsInstance client;

    public VbsInstanceWaiters(ExecutorService executorService, VbsInstance client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetVbsInstanceRequest, GetVbsInstanceResponse> forVbsInstance(GetVbsInstanceRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVbsInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVbsInstanceRequest, GetVbsInstanceResponse> forVbsInstance(GetVbsInstanceRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVbsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVbsInstanceRequest, GetVbsInstanceResponse> forVbsInstance(GetVbsInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVbsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVbsInstanceRequest, GetVbsInstanceResponse> forVbsInstance(BmcGenericWaiter waiter, GetVbsInstanceRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVbsInstanceRequest, GetVbsInstanceResponse>(){

            @Override
            public GetVbsInstanceResponse apply(GetVbsInstanceRequest request) {
                return VbsInstanceWaiters.this.client.getVbsInstance(request);
            }
        }, (Predicate)new Predicate<GetVbsInstanceResponse>(){

            @Override
            public boolean test(GetVbsInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getVbsInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return VbsInstanceWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

