/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vbsinst.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVbsInstanceRequest
extends BmcRequest<Void> {
    private String vbsInstanceId;
    private String opcRequestId;

    public String getVbsInstanceId() {
        return this.vbsInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().vbsInstanceId(this.vbsInstanceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vbsInstanceId=").append(String.valueOf(this.vbsInstanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVbsInstanceRequest)) {
            return false;
        }
        GetVbsInstanceRequest other = (GetVbsInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vbsInstanceId, other.vbsInstanceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vbsInstanceId == null ? 43 : this.vbsInstanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVbsInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vbsInstanceId = null;
        private String opcRequestId = null;

        public Builder vbsInstanceId(String vbsInstanceId) {
            this.vbsInstanceId = vbsInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVbsInstanceRequest o) {
            this.vbsInstanceId(o.getVbsInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVbsInstanceRequest build() {
            GetVbsInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVbsInstanceRequest buildWithoutInvocationCallback() {
            GetVbsInstanceRequest request = new GetVbsInstanceRequest();
            request.vbsInstanceId = this.vbsInstanceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

