/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.visualbuilder;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.visualbuilder.VbInstanceAsync;
import com.oracle.bmc.visualbuilder.model.ApplicationSummaryCollection;
import com.oracle.bmc.visualbuilder.model.VbInstance;
import com.oracle.bmc.visualbuilder.model.VbInstanceSummaryCollection;
import com.oracle.bmc.visualbuilder.model.WorkRequest;
import com.oracle.bmc.visualbuilder.model.WorkRequestErrorCollection;
import com.oracle.bmc.visualbuilder.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.visualbuilder.model.WorkRequestSummaryCollection;
import com.oracle.bmc.visualbuilder.requests.ChangeVbInstanceCompartmentRequest;
import com.oracle.bmc.visualbuilder.requests.CreateVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.DeleteVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.GetVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.GetWorkRequestRequest;
import com.oracle.bmc.visualbuilder.requests.ListVbInstancesRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestsRequest;
import com.oracle.bmc.visualbuilder.requests.RequestSummarizedApplicationsRequest;
import com.oracle.bmc.visualbuilder.requests.StartVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.StopVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.UpdateVbInstanceRequest;
import com.oracle.bmc.visualbuilder.responses.ChangeVbInstanceCompartmentResponse;
import com.oracle.bmc.visualbuilder.responses.CreateVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.DeleteVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.GetVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.GetWorkRequestResponse;
import com.oracle.bmc.visualbuilder.responses.ListVbInstancesResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestsResponse;
import com.oracle.bmc.visualbuilder.responses.RequestSummarizedApplicationsResponse;
import com.oracle.bmc.visualbuilder.responses.StartVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.StopVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.UpdateVbInstanceResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VbInstanceAsyncClient
extends BaseAsyncClient
implements VbInstanceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VBINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://visualbuilder.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VbInstanceAsyncClient.class);

    VbInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeVbInstanceCompartmentResponse> changeVbInstanceCompartment(ChangeVbInstanceCompartmentRequest request, AsyncHandler<ChangeVbInstanceCompartmentRequest, ChangeVbInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVbInstanceCompartmentDetails(), "changeVbInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeVbInstanceCompartmentResponse::builder).logger(LOG, "changeVbInstanceCompartment").serviceDetails("VbInstance", "ChangeVbInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/ChangeVbInstanceCompartment").method(Method.POST).requestBuilder(ChangeVbInstanceCompartmentRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVbInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVbInstanceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateVbInstanceResponse> createVbInstance(CreateVbInstanceRequest request, AsyncHandler<CreateVbInstanceRequest, CreateVbInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateVbInstanceDetails(), "createVbInstanceDetails is required");
        return this.clientCall(request, CreateVbInstanceResponse::builder).logger(LOG, "createVbInstance").serviceDetails("VbInstance", "CreateVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/CreateVbInstance").method(Method.POST).requestBuilder(CreateVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVbInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteVbInstanceResponse> deleteVbInstance(DeleteVbInstanceRequest request, AsyncHandler<DeleteVbInstanceRequest, DeleteVbInstanceResponse> handler) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteVbInstanceResponse::builder).logger(LOG, "deleteVbInstance").serviceDetails("VbInstance", "DeleteVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/DeleteVbInstance").method(Method.DELETE).requestBuilder(DeleteVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVbInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVbInstanceResponse> getVbInstance(GetVbInstanceRequest request, AsyncHandler<GetVbInstanceRequest, GetVbInstanceResponse> handler) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVbInstanceResponse::builder).logger(LOG, "getVbInstance").serviceDetails("VbInstance", "GetVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/GetVbInstance").method(Method.GET).requestBuilder(GetVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VbInstance.class, GetVbInstanceResponse.Builder::vbInstance).handleResponseHeaderString("etag", GetVbInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVbInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("VbInstance", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListVbInstancesResponse> listVbInstances(ListVbInstancesRequest request, AsyncHandler<ListVbInstancesRequest, ListVbInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVbInstancesResponse::builder).logger(LOG, "listVbInstances").serviceDetails("VbInstance", "ListVbInstances", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstanceSummaryCollection/ListVbInstances").method(Method.GET).requestBuilder(ListVbInstancesRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VbInstanceSummaryCollection.class, ListVbInstancesResponse.Builder::vbInstanceSummaryCollection).handleResponseHeaderString("opc-request-id", ListVbInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVbInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListVbInstancesResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("VbInstance", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestErrorsResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("VbInstance", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestLogsResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("VbInstance", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/WorkRequestSummaryCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210601").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("vbInstanceId", (Object)request.getVbInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestsResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<RequestSummarizedApplicationsResponse> requestSummarizedApplications(RequestSummarizedApplicationsRequest request, AsyncHandler<RequestSummarizedApplicationsRequest, RequestSummarizedApplicationsResponse> handler) {
        Objects.requireNonNull(request.getRequestSummarizedApplicationsDetails(), "requestSummarizedApplicationsDetails is required");
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RequestSummarizedApplicationsResponse::builder).logger(LOG, "requestSummarizedApplications").serviceDetails("VbInstance", "RequestSummarizedApplications", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/ApplicationSummaryCollection/RequestSummarizedApplications").method(Method.POST).requestBuilder(RequestSummarizedApplicationsRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).appendPathParam("actions").appendPathParam("applications").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ApplicationSummaryCollection.class, RequestSummarizedApplicationsResponse.Builder::applicationSummaryCollection).handleResponseHeaderString("etag", RequestSummarizedApplicationsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RequestSummarizedApplicationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StartVbInstanceResponse> startVbInstance(StartVbInstanceRequest request, AsyncHandler<StartVbInstanceRequest, StartVbInstanceResponse> handler) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartVbInstanceResponse::builder).logger(LOG, "startVbInstance").serviceDetails("VbInstance", "StartVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/StartVbInstance").method(Method.POST).requestBuilder(StartVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartVbInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopVbInstanceResponse> stopVbInstance(StopVbInstanceRequest request, AsyncHandler<StopVbInstanceRequest, StopVbInstanceResponse> handler) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopVbInstanceResponse::builder).logger(LOG, "stopVbInstance").serviceDetails("VbInstance", "StopVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/StopVbInstance").method(Method.POST).requestBuilder(StopVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StopVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopVbInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateVbInstanceResponse> updateVbInstance(UpdateVbInstanceRequest request, AsyncHandler<UpdateVbInstanceRequest, UpdateVbInstanceResponse> handler) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVbInstanceDetails(), "updateVbInstanceDetails is required");
        return this.clientCall(request, UpdateVbInstanceResponse::builder).logger(LOG, "updateVbInstance").serviceDetails("VbInstance", "UpdateVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/UpdateVbInstance").method(Method.PUT).requestBuilder(UpdateVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVbInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public VbInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VbInstanceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VbInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VbInstanceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VbInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VbInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public VbInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VbInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public VbInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VbInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public VbInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VbInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public VbInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VbInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VbInstanceAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "visualbuilder";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"visualbuilder");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public VbInstanceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VbInstanceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

