/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.visualbuilder;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.visualbuilder.VbInstancePaginators;
import com.oracle.bmc.visualbuilder.VbInstanceWaiters;
import com.oracle.bmc.visualbuilder.model.ApplicationSummaryCollection;
import com.oracle.bmc.visualbuilder.model.VbInstance;
import com.oracle.bmc.visualbuilder.model.VbInstanceSummaryCollection;
import com.oracle.bmc.visualbuilder.model.WorkRequest;
import com.oracle.bmc.visualbuilder.model.WorkRequestErrorCollection;
import com.oracle.bmc.visualbuilder.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.visualbuilder.model.WorkRequestSummaryCollection;
import com.oracle.bmc.visualbuilder.requests.ChangeVbInstanceCompartmentRequest;
import com.oracle.bmc.visualbuilder.requests.CreateVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.DeleteVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.GetVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.GetWorkRequestRequest;
import com.oracle.bmc.visualbuilder.requests.ListVbInstancesRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestsRequest;
import com.oracle.bmc.visualbuilder.requests.RequestSummarizedApplicationsRequest;
import com.oracle.bmc.visualbuilder.requests.StartVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.StopVbInstanceRequest;
import com.oracle.bmc.visualbuilder.requests.UpdateVbInstanceRequest;
import com.oracle.bmc.visualbuilder.responses.ChangeVbInstanceCompartmentResponse;
import com.oracle.bmc.visualbuilder.responses.CreateVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.DeleteVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.GetVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.GetWorkRequestResponse;
import com.oracle.bmc.visualbuilder.responses.ListVbInstancesResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestsResponse;
import com.oracle.bmc.visualbuilder.responses.RequestSummarizedApplicationsResponse;
import com.oracle.bmc.visualbuilder.responses.StartVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.StopVbInstanceResponse;
import com.oracle.bmc.visualbuilder.responses.UpdateVbInstanceResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VbInstanceClient
extends BaseSyncClient
implements com.oracle.bmc.visualbuilder.VbInstance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VBINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://visualbuilder.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(VbInstanceClient.class);
    private final VbInstanceWaiters waiters;
    private final VbInstancePaginators paginators;

    VbInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("VbInstance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new VbInstanceWaiters(executorService, this);
        this.paginators = new VbInstancePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeVbInstanceCompartmentResponse changeVbInstanceCompartment(ChangeVbInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVbInstanceCompartmentDetails(), "changeVbInstanceCompartmentDetails is required");
        return (ChangeVbInstanceCompartmentResponse)this.clientCall(request, ChangeVbInstanceCompartmentResponse::builder).logger(LOG, "changeVbInstanceCompartment").serviceDetails("VbInstance", "ChangeVbInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/ChangeVbInstanceCompartment").method(Method.POST).requestBuilder(ChangeVbInstanceCompartmentRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeVbInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeVbInstanceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVbInstanceResponse createVbInstance(CreateVbInstanceRequest request) {
        Objects.requireNonNull(request.getCreateVbInstanceDetails(), "createVbInstanceDetails is required");
        return (CreateVbInstanceResponse)this.clientCall(request, CreateVbInstanceResponse::builder).logger(LOG, "createVbInstance").serviceDetails("VbInstance", "CreateVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/CreateVbInstance").method(Method.POST).requestBuilder(CreateVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVbInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVbInstanceResponse deleteVbInstance(DeleteVbInstanceRequest request) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteVbInstanceResponse)this.clientCall(request, DeleteVbInstanceResponse::builder).logger(LOG, "deleteVbInstance").serviceDetails("VbInstance", "DeleteVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/DeleteVbInstance").method(Method.DELETE).requestBuilder(DeleteVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVbInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVbInstanceResponse getVbInstance(GetVbInstanceRequest request) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return (GetVbInstanceResponse)this.clientCall(request, GetVbInstanceResponse::builder).logger(LOG, "getVbInstance").serviceDetails("VbInstance", "GetVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/GetVbInstance").method(Method.GET).requestBuilder(GetVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VbInstance.class, GetVbInstanceResponse.Builder::vbInstance).handleResponseHeaderString("etag", GetVbInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVbInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("VbInstance", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListVbInstancesResponse listVbInstances(ListVbInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListVbInstancesResponse)this.clientCall(request, ListVbInstancesResponse::builder).logger(LOG, "listVbInstances").serviceDetails("VbInstance", "ListVbInstances", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstanceSummaryCollection/ListVbInstances").method(Method.GET).requestBuilder(ListVbInstancesRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VbInstanceSummaryCollection.class, ListVbInstancesResponse.Builder::vbInstanceSummaryCollection).handleResponseHeaderString("opc-request-id", ListVbInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVbInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListVbInstancesResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("VbInstance", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestErrorsResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("VbInstance", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210601").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestLogsResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("VbInstance", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/WorkRequestSummaryCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210601").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("vbInstanceId", (Object)request.getVbInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestsResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public RequestSummarizedApplicationsResponse requestSummarizedApplications(RequestSummarizedApplicationsRequest request) {
        Objects.requireNonNull(request.getRequestSummarizedApplicationsDetails(), "requestSummarizedApplicationsDetails is required");
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return (RequestSummarizedApplicationsResponse)this.clientCall(request, RequestSummarizedApplicationsResponse::builder).logger(LOG, "requestSummarizedApplications").serviceDetails("VbInstance", "RequestSummarizedApplications", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/ApplicationSummaryCollection/RequestSummarizedApplications").method(Method.POST).requestBuilder(RequestSummarizedApplicationsRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).appendPathParam("actions").appendPathParam("applications").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ApplicationSummaryCollection.class, RequestSummarizedApplicationsResponse.Builder::applicationSummaryCollection).handleResponseHeaderString("etag", RequestSummarizedApplicationsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RequestSummarizedApplicationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StartVbInstanceResponse startVbInstance(StartVbInstanceRequest request) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return (StartVbInstanceResponse)this.clientCall(request, StartVbInstanceResponse::builder).logger(LOG, "startVbInstance").serviceDetails("VbInstance", "StartVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/StartVbInstance").method(Method.POST).requestBuilder(StartVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartVbInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StopVbInstanceResponse stopVbInstance(StopVbInstanceRequest request) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        return (StopVbInstanceResponse)this.clientCall(request, StopVbInstanceResponse::builder).logger(LOG, "stopVbInstance").serviceDetails("VbInstance", "StopVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/StopVbInstance").method(Method.POST).requestBuilder(StopVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StopVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopVbInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVbInstanceResponse updateVbInstance(UpdateVbInstanceRequest request) {
        Validate.notBlank((String)request.getVbInstanceId(), (String)"vbInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVbInstanceDetails(), "updateVbInstanceDetails is required");
        return (UpdateVbInstanceResponse)this.clientCall(request, UpdateVbInstanceResponse::builder).logger(LOG, "updateVbInstance").serviceDetails("VbInstance", "UpdateVbInstance", "https://docs.oracle.com/iaas/api/#/en/visual-builder/20210601/VbInstance/UpdateVbInstance").method(Method.PUT).requestBuilder(UpdateVbInstanceRequest::builder).basePath("/20210601").appendPathParam("vbInstances").appendPathParam(request.getVbInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVbInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVbInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public VbInstanceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public VbInstancePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public VbInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)VbInstanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(VbInstanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)VbInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)VbInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)VbInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)VbInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VbInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public VbInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)VbInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VbInstanceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "visualbuilder";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"visualbuilder");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public VbInstanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new VbInstanceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

