/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.visualbuilder;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.visualbuilder.VbInstance;
import com.oracle.bmc.visualbuilder.model.VbInstanceSummary;
import com.oracle.bmc.visualbuilder.model.WorkRequestError;
import com.oracle.bmc.visualbuilder.model.WorkRequestLogEntry;
import com.oracle.bmc.visualbuilder.model.WorkRequestSummary;
import com.oracle.bmc.visualbuilder.requests.ListVbInstancesRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.visualbuilder.requests.ListWorkRequestsRequest;
import com.oracle.bmc.visualbuilder.responses.ListVbInstancesResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.visualbuilder.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class VbInstancePaginators {
    private final VbInstance client;

    public VbInstancePaginators(VbInstance client) {
        this.client = client;
    }

    public Iterable<ListVbInstancesResponse> listVbInstancesResponseIterator(final ListVbInstancesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListVbInstancesRequest.Builder>(){

            @Override
            public ListVbInstancesRequest.Builder get() {
                return ListVbInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVbInstancesResponse, String>(){

            @Override
            public String apply(ListVbInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVbInstancesRequest.Builder>, ListVbInstancesRequest>(){

            @Override
            public ListVbInstancesRequest apply(RequestBuilderAndToken<ListVbInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVbInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVbInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVbInstancesRequest, ListVbInstancesResponse>(){

            @Override
            public ListVbInstancesResponse apply(ListVbInstancesRequest request) {
                return VbInstancePaginators.this.client.listVbInstances(request);
            }
        });
    }

    public Iterable<VbInstanceSummary> listVbInstancesRecordIterator(final ListVbInstancesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListVbInstancesRequest.Builder>(){

            @Override
            public ListVbInstancesRequest.Builder get() {
                return ListVbInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListVbInstancesResponse, String>(){

            @Override
            public String apply(ListVbInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListVbInstancesRequest.Builder>, ListVbInstancesRequest>(){

            @Override
            public ListVbInstancesRequest apply(RequestBuilderAndToken<ListVbInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListVbInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListVbInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListVbInstancesRequest, ListVbInstancesResponse>(){

            @Override
            public ListVbInstancesResponse apply(ListVbInstancesRequest request) {
                return VbInstancePaginators.this.client.listVbInstances(request);
            }
        }, (Function)new Function<ListVbInstancesResponse, List<VbInstanceSummary>>(){

            @Override
            public List<VbInstanceSummary> apply(ListVbInstancesResponse response) {
                return response.getVbInstanceSummaryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return VbInstancePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return VbInstancePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return VbInstancePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return VbInstancePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return VbInstancePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return VbInstancePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

