/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.visualbuilder.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListWorkRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private String vbInstanceId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getVbInstanceId() {
        return this.vbInstanceId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).vbInstanceId(this.vbInstanceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",vbInstanceId=").append(String.valueOf(this.vbInstanceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListWorkRequestsRequest)) {
            return false;
        }
        ListWorkRequestsRequest other = (ListWorkRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.vbInstanceId, other.vbInstanceId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.vbInstanceId == null ? 43 : this.vbInstanceId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private String vbInstanceId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder vbInstanceId(String vbInstanceId) {
            this.vbInstanceId = vbInstanceId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.vbInstanceId(o.getVbInstanceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestsRequest build() {
            ListWorkRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListWorkRequestsRequest buildWithoutInvocationCallback() {
            ListWorkRequestsRequest request = new ListWorkRequestsRequest();
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.vbInstanceId = this.vbInstanceId;
            return request;
        }
    }
}

