/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.waas.Redirect;
import com.oracle.bmc.waas.model.LifecycleStates;
import com.oracle.bmc.waas.requests.GetHttpRedirectRequest;
import com.oracle.bmc.waas.responses.GetHttpRedirectResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class RedirectWaiters {
    private final ExecutorService executorService;
    private final Redirect client;

    public Waiter<GetHttpRedirectRequest, GetHttpRedirectResponse> forHttpRedirect(GetHttpRedirectRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHttpRedirect(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHttpRedirectRequest, GetHttpRedirectResponse> forHttpRedirect(GetHttpRedirectRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHttpRedirect(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHttpRedirectRequest, GetHttpRedirectResponse> forHttpRedirect(GetHttpRedirectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHttpRedirect(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHttpRedirectRequest, GetHttpRedirectResponse> forHttpRedirect(BmcGenericWaiter waiter, GetHttpRedirectRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetHttpRedirectRequest, GetHttpRedirectResponse>(){

            public GetHttpRedirectResponse apply(GetHttpRedirectRequest request) {
                return RedirectWaiters.this.client.getHttpRedirect(request);
            }
        }, (Predicate)new Predicate<GetHttpRedirectResponse>(){

            public boolean apply(GetHttpRedirectResponse response) {
                return targetStatesSet.contains((Object)response.getHttpRedirect().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public RedirectWaiters(ExecutorService executorService, Redirect client) {
        this.executorService = executorService;
        this.client = client;
    }
}

