/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import com.oracle.bmc.waas.WaasAsync;
import com.oracle.bmc.waas.internal.http.AcceptRecommendationsConverter;
import com.oracle.bmc.waas.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.waas.internal.http.ChangeAddressListCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeCertificateCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeCustomProtectionRuleCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeWaasPolicyCompartmentConverter;
import com.oracle.bmc.waas.internal.http.CreateAddressListConverter;
import com.oracle.bmc.waas.internal.http.CreateCertificateConverter;
import com.oracle.bmc.waas.internal.http.CreateCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.CreateWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.DeleteAddressListConverter;
import com.oracle.bmc.waas.internal.http.DeleteCertificateConverter;
import com.oracle.bmc.waas.internal.http.DeleteCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.DeleteWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.GetAddressListConverter;
import com.oracle.bmc.waas.internal.http.GetCertificateConverter;
import com.oracle.bmc.waas.internal.http.GetCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.GetDeviceFingerprintChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetHumanInteractionChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetJsChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetPolicyConfigConverter;
import com.oracle.bmc.waas.internal.http.GetProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.GetProtectionSettingsConverter;
import com.oracle.bmc.waas.internal.http.GetWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.GetWafAddressRateLimitingConverter;
import com.oracle.bmc.waas.internal.http.GetWafConfigConverter;
import com.oracle.bmc.waas.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.waas.internal.http.ListAccessRulesConverter;
import com.oracle.bmc.waas.internal.http.ListAddressListsConverter;
import com.oracle.bmc.waas.internal.http.ListCachingRulesConverter;
import com.oracle.bmc.waas.internal.http.ListCaptchasConverter;
import com.oracle.bmc.waas.internal.http.ListCertificatesConverter;
import com.oracle.bmc.waas.internal.http.ListCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListEdgeSubnetsConverter;
import com.oracle.bmc.waas.internal.http.ListGoodBotsConverter;
import com.oracle.bmc.waas.internal.http.ListProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListRecommendationsConverter;
import com.oracle.bmc.waas.internal.http.ListThreatFeedsConverter;
import com.oracle.bmc.waas.internal.http.ListWaasPoliciesConverter;
import com.oracle.bmc.waas.internal.http.ListWaasPolicyCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListWafBlockedRequestsConverter;
import com.oracle.bmc.waas.internal.http.ListWafLogsConverter;
import com.oracle.bmc.waas.internal.http.ListWafRequestsConverter;
import com.oracle.bmc.waas.internal.http.ListWafTrafficConverter;
import com.oracle.bmc.waas.internal.http.ListWhitelistsConverter;
import com.oracle.bmc.waas.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.waas.internal.http.PurgeCacheConverter;
import com.oracle.bmc.waas.internal.http.UpdateAccessRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateAddressListConverter;
import com.oracle.bmc.waas.internal.http.UpdateCachingRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateCaptchasConverter;
import com.oracle.bmc.waas.internal.http.UpdateCertificateConverter;
import com.oracle.bmc.waas.internal.http.UpdateCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.UpdateDeviceFingerprintChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdateGoodBotsConverter;
import com.oracle.bmc.waas.internal.http.UpdateHumanInteractionChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdateJsChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdatePolicyConfigConverter;
import com.oracle.bmc.waas.internal.http.UpdateProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateProtectionSettingsConverter;
import com.oracle.bmc.waas.internal.http.UpdateThreatFeedsConverter;
import com.oracle.bmc.waas.internal.http.UpdateWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.UpdateWaasPolicyCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateWafAddressRateLimitingConverter;
import com.oracle.bmc.waas.internal.http.UpdateWafConfigConverter;
import com.oracle.bmc.waas.internal.http.UpdateWhitelistsConverter;
import com.oracle.bmc.waas.requests.AcceptRecommendationsRequest;
import com.oracle.bmc.waas.requests.CancelWorkRequestRequest;
import com.oracle.bmc.waas.requests.ChangeAddressListCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeCustomProtectionRuleCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeWaasPolicyCompartmentRequest;
import com.oracle.bmc.waas.requests.CreateAddressListRequest;
import com.oracle.bmc.waas.requests.CreateCertificateRequest;
import com.oracle.bmc.waas.requests.CreateCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.CreateWaasPolicyRequest;
import com.oracle.bmc.waas.requests.DeleteAddressListRequest;
import com.oracle.bmc.waas.requests.DeleteCertificateRequest;
import com.oracle.bmc.waas.requests.DeleteCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.DeleteWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetAddressListRequest;
import com.oracle.bmc.waas.requests.GetCertificateRequest;
import com.oracle.bmc.waas.requests.GetCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetDeviceFingerprintChallengeRequest;
import com.oracle.bmc.waas.requests.GetHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.requests.GetJsChallengeRequest;
import com.oracle.bmc.waas.requests.GetPolicyConfigRequest;
import com.oracle.bmc.waas.requests.GetProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetProtectionSettingsRequest;
import com.oracle.bmc.waas.requests.GetWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetWafAddressRateLimitingRequest;
import com.oracle.bmc.waas.requests.GetWafConfigRequest;
import com.oracle.bmc.waas.requests.GetWorkRequestRequest;
import com.oracle.bmc.waas.requests.ListAccessRulesRequest;
import com.oracle.bmc.waas.requests.ListAddressListsRequest;
import com.oracle.bmc.waas.requests.ListCachingRulesRequest;
import com.oracle.bmc.waas.requests.ListCaptchasRequest;
import com.oracle.bmc.waas.requests.ListCertificatesRequest;
import com.oracle.bmc.waas.requests.ListCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListEdgeSubnetsRequest;
import com.oracle.bmc.waas.requests.ListGoodBotsRequest;
import com.oracle.bmc.waas.requests.ListProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListRecommendationsRequest;
import com.oracle.bmc.waas.requests.ListThreatFeedsRequest;
import com.oracle.bmc.waas.requests.ListWaasPoliciesRequest;
import com.oracle.bmc.waas.requests.ListWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListWafBlockedRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafLogsRequest;
import com.oracle.bmc.waas.requests.ListWafRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafTrafficRequest;
import com.oracle.bmc.waas.requests.ListWhitelistsRequest;
import com.oracle.bmc.waas.requests.ListWorkRequestsRequest;
import com.oracle.bmc.waas.requests.PurgeCacheRequest;
import com.oracle.bmc.waas.requests.UpdateAccessRulesRequest;
import com.oracle.bmc.waas.requests.UpdateAddressListRequest;
import com.oracle.bmc.waas.requests.UpdateCachingRulesRequest;
import com.oracle.bmc.waas.requests.UpdateCaptchasRequest;
import com.oracle.bmc.waas.requests.UpdateCertificateRequest;
import com.oracle.bmc.waas.requests.UpdateCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.UpdateDeviceFingerprintChallengeRequest;
import com.oracle.bmc.waas.requests.UpdateGoodBotsRequest;
import com.oracle.bmc.waas.requests.UpdateHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.requests.UpdateJsChallengeRequest;
import com.oracle.bmc.waas.requests.UpdatePolicyConfigRequest;
import com.oracle.bmc.waas.requests.UpdateProtectionRulesRequest;
import com.oracle.bmc.waas.requests.UpdateProtectionSettingsRequest;
import com.oracle.bmc.waas.requests.UpdateThreatFeedsRequest;
import com.oracle.bmc.waas.requests.UpdateWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.UpdateWaasPolicyRequest;
import com.oracle.bmc.waas.requests.UpdateWafAddressRateLimitingRequest;
import com.oracle.bmc.waas.requests.UpdateWafConfigRequest;
import com.oracle.bmc.waas.requests.UpdateWhitelistsRequest;
import com.oracle.bmc.waas.responses.AcceptRecommendationsResponse;
import com.oracle.bmc.waas.responses.CancelWorkRequestResponse;
import com.oracle.bmc.waas.responses.ChangeAddressListCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeCustomProtectionRuleCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeWaasPolicyCompartmentResponse;
import com.oracle.bmc.waas.responses.CreateAddressListResponse;
import com.oracle.bmc.waas.responses.CreateCertificateResponse;
import com.oracle.bmc.waas.responses.CreateCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.CreateWaasPolicyResponse;
import com.oracle.bmc.waas.responses.DeleteAddressListResponse;
import com.oracle.bmc.waas.responses.DeleteCertificateResponse;
import com.oracle.bmc.waas.responses.DeleteCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.DeleteWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetAddressListResponse;
import com.oracle.bmc.waas.responses.GetCertificateResponse;
import com.oracle.bmc.waas.responses.GetCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetDeviceFingerprintChallengeResponse;
import com.oracle.bmc.waas.responses.GetHumanInteractionChallengeResponse;
import com.oracle.bmc.waas.responses.GetJsChallengeResponse;
import com.oracle.bmc.waas.responses.GetPolicyConfigResponse;
import com.oracle.bmc.waas.responses.GetProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetProtectionSettingsResponse;
import com.oracle.bmc.waas.responses.GetWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetWafAddressRateLimitingResponse;
import com.oracle.bmc.waas.responses.GetWafConfigResponse;
import com.oracle.bmc.waas.responses.GetWorkRequestResponse;
import com.oracle.bmc.waas.responses.ListAccessRulesResponse;
import com.oracle.bmc.waas.responses.ListAddressListsResponse;
import com.oracle.bmc.waas.responses.ListCachingRulesResponse;
import com.oracle.bmc.waas.responses.ListCaptchasResponse;
import com.oracle.bmc.waas.responses.ListCertificatesResponse;
import com.oracle.bmc.waas.responses.ListCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListEdgeSubnetsResponse;
import com.oracle.bmc.waas.responses.ListGoodBotsResponse;
import com.oracle.bmc.waas.responses.ListProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListRecommendationsResponse;
import com.oracle.bmc.waas.responses.ListThreatFeedsResponse;
import com.oracle.bmc.waas.responses.ListWaasPoliciesResponse;
import com.oracle.bmc.waas.responses.ListWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListWafBlockedRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafLogsResponse;
import com.oracle.bmc.waas.responses.ListWafRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafTrafficResponse;
import com.oracle.bmc.waas.responses.ListWhitelistsResponse;
import com.oracle.bmc.waas.responses.ListWorkRequestsResponse;
import com.oracle.bmc.waas.responses.PurgeCacheResponse;
import com.oracle.bmc.waas.responses.UpdateAccessRulesResponse;
import com.oracle.bmc.waas.responses.UpdateAddressListResponse;
import com.oracle.bmc.waas.responses.UpdateCachingRulesResponse;
import com.oracle.bmc.waas.responses.UpdateCaptchasResponse;
import com.oracle.bmc.waas.responses.UpdateCertificateResponse;
import com.oracle.bmc.waas.responses.UpdateCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.UpdateDeviceFingerprintChallengeResponse;
import com.oracle.bmc.waas.responses.UpdateGoodBotsResponse;
import com.oracle.bmc.waas.responses.UpdateHumanInteractionChallengeResponse;
import com.oracle.bmc.waas.responses.UpdateJsChallengeResponse;
import com.oracle.bmc.waas.responses.UpdatePolicyConfigResponse;
import com.oracle.bmc.waas.responses.UpdateProtectionRulesResponse;
import com.oracle.bmc.waas.responses.UpdateProtectionSettingsResponse;
import com.oracle.bmc.waas.responses.UpdateThreatFeedsResponse;
import com.oracle.bmc.waas.responses.UpdateWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.UpdateWaasPolicyResponse;
import com.oracle.bmc.waas.responses.UpdateWafAddressRateLimitingResponse;
import com.oracle.bmc.waas.responses.UpdateWafConfigResponse;
import com.oracle.bmc.waas.responses.UpdateWhitelistsResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaasAsyncClient
implements WaasAsync {
    private static final Logger LOG = LoggerFactory.getLogger(WaasAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("WAAS").serviceEndpointPrefix("waas").serviceEndpointTemplate("https://waas.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public WaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public WaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public WaasAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public WaasAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AcceptRecommendationsResponse> acceptRecommendations(AcceptRecommendationsRequest request, AsyncHandler<AcceptRecommendationsRequest, AcceptRecommendationsResponse> handler) {
        LOG.trace("Called async acceptRecommendations");
        AcceptRecommendationsRequest interceptedRequest = AcceptRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AcceptRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, AcceptRecommendationsResponse> transformer = AcceptRecommendationsConverter.fromResponse();
        AsyncHandler<AcceptRecommendationsRequest, AcceptRecommendationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AcceptRecommendationsRequest, AcceptRecommendationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        LOG.trace("Called async cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelWorkRequestRequest, CancelWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeAddressListCompartmentResponse> changeAddressListCompartment(ChangeAddressListCompartmentRequest request, AsyncHandler<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse> handler) {
        LOG.trace("Called async changeAddressListCompartment");
        ChangeAddressListCompartmentRequest interceptedRequest = ChangeAddressListCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAddressListCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeAddressListCompartmentResponse> transformer = ChangeAddressListCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeAddressListCompartmentRequest, ChangeAddressListCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeCertificateCompartmentResponse> changeCertificateCompartment(ChangeCertificateCompartmentRequest request, AsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> handler) {
        LOG.trace("Called async changeCertificateCompartment");
        ChangeCertificateCompartmentRequest interceptedRequest = ChangeCertificateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCertificateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeCertificateCompartmentResponse> transformer = ChangeCertificateCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeCertificateCompartmentRequest, ChangeCertificateCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeCustomProtectionRuleCompartmentResponse> changeCustomProtectionRuleCompartment(ChangeCustomProtectionRuleCompartmentRequest request, AsyncHandler<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse> handler) {
        LOG.trace("Called async changeCustomProtectionRuleCompartment");
        ChangeCustomProtectionRuleCompartmentRequest interceptedRequest = ChangeCustomProtectionRuleCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCustomProtectionRuleCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeCustomProtectionRuleCompartmentResponse> transformer = ChangeCustomProtectionRuleCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeCustomProtectionRuleCompartmentRequest, ChangeCustomProtectionRuleCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeWaasPolicyCompartmentResponse> changeWaasPolicyCompartment(ChangeWaasPolicyCompartmentRequest request, AsyncHandler<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse> handler) {
        LOG.trace("Called async changeWaasPolicyCompartment");
        ChangeWaasPolicyCompartmentRequest interceptedRequest = ChangeWaasPolicyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeWaasPolicyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeWaasPolicyCompartmentResponse> transformer = ChangeWaasPolicyCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeWaasPolicyCompartmentRequest, ChangeWaasPolicyCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateAddressListResponse> createAddressList(CreateAddressListRequest request, AsyncHandler<CreateAddressListRequest, CreateAddressListResponse> handler) {
        LOG.trace("Called async createAddressList");
        CreateAddressListRequest interceptedRequest = CreateAddressListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAddressListConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateAddressListResponse> transformer = CreateAddressListConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateAddressListRequest, CreateAddressListResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateAddressListRequest, CreateAddressListResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCertificateResponse> createCertificate(CreateCertificateRequest request, AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handler) {
        LOG.trace("Called async createCertificate");
        CreateCertificateRequest interceptedRequest = CreateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCertificateConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateCertificateResponse> transformer = CreateCertificateConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCertificateRequest, CreateCertificateResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCertificateRequest, CreateCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateCustomProtectionRuleResponse> createCustomProtectionRule(CreateCustomProtectionRuleRequest request, AsyncHandler<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse> handler) {
        LOG.trace("Called async createCustomProtectionRule");
        CreateCustomProtectionRuleRequest interceptedRequest = CreateCustomProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateCustomProtectionRuleResponse> transformer = CreateCustomProtectionRuleConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateCustomProtectionRuleRequest, CreateCustomProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateWaasPolicyResponse> createWaasPolicy(CreateWaasPolicyRequest request, AsyncHandler<CreateWaasPolicyRequest, CreateWaasPolicyResponse> handler) {
        LOG.trace("Called async createWaasPolicy");
        CreateWaasPolicyRequest interceptedRequest = CreateWaasPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateWaasPolicyResponse> transformer = CreateWaasPolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateWaasPolicyRequest, CreateWaasPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateWaasPolicyRequest, CreateWaasPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteAddressListResponse> deleteAddressList(DeleteAddressListRequest request, AsyncHandler<DeleteAddressListRequest, DeleteAddressListResponse> handler) {
        LOG.trace("Called async deleteAddressList");
        DeleteAddressListRequest interceptedRequest = DeleteAddressListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAddressListConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteAddressListResponse> transformer = DeleteAddressListConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteAddressListRequest, DeleteAddressListResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteAddressListRequest, DeleteAddressListResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request, AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handler) {
        LOG.trace("Called async deleteCertificate");
        DeleteCertificateRequest interceptedRequest = DeleteCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCertificateConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteCertificateResponse> transformer = DeleteCertificateConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteCertificateRequest, DeleteCertificateResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCertificateRequest, DeleteCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteCustomProtectionRuleResponse> deleteCustomProtectionRule(DeleteCustomProtectionRuleRequest request, AsyncHandler<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse> handler) {
        LOG.trace("Called async deleteCustomProtectionRule");
        DeleteCustomProtectionRuleRequest interceptedRequest = DeleteCustomProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteCustomProtectionRuleResponse> transformer = DeleteCustomProtectionRuleConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteCustomProtectionRuleRequest, DeleteCustomProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteWaasPolicyResponse> deleteWaasPolicy(DeleteWaasPolicyRequest request, AsyncHandler<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse> handler) {
        LOG.trace("Called async deleteWaasPolicy");
        DeleteWaasPolicyRequest interceptedRequest = DeleteWaasPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteWaasPolicyResponse> transformer = DeleteWaasPolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteWaasPolicyRequest, DeleteWaasPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAddressListResponse> getAddressList(GetAddressListRequest request, AsyncHandler<GetAddressListRequest, GetAddressListResponse> handler) {
        LOG.trace("Called async getAddressList");
        GetAddressListRequest interceptedRequest = GetAddressListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAddressListConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetAddressListResponse> transformer = GetAddressListConverter.fromResponse();
        AsyncHandler<GetAddressListRequest, GetAddressListResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAddressListRequest, GetAddressListResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCertificateResponse> getCertificate(GetCertificateRequest request, AsyncHandler<GetCertificateRequest, GetCertificateResponse> handler) {
        LOG.trace("Called async getCertificate");
        GetCertificateRequest interceptedRequest = GetCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCertificateConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCertificateResponse> transformer = GetCertificateConverter.fromResponse();
        AsyncHandler<GetCertificateRequest, GetCertificateResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCertificateRequest, GetCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCustomProtectionRuleResponse> getCustomProtectionRule(GetCustomProtectionRuleRequest request, AsyncHandler<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> handler) {
        LOG.trace("Called async getCustomProtectionRule");
        GetCustomProtectionRuleRequest interceptedRequest = GetCustomProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCustomProtectionRuleResponse> transformer = GetCustomProtectionRuleConverter.fromResponse();
        AsyncHandler<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCustomProtectionRuleRequest, GetCustomProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeviceFingerprintChallengeResponse> getDeviceFingerprintChallenge(GetDeviceFingerprintChallengeRequest request, AsyncHandler<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse> handler) {
        LOG.trace("Called async getDeviceFingerprintChallenge");
        GetDeviceFingerprintChallengeRequest interceptedRequest = GetDeviceFingerprintChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeviceFingerprintChallengeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDeviceFingerprintChallengeResponse> transformer = GetDeviceFingerprintChallengeConverter.fromResponse();
        AsyncHandler<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeviceFingerprintChallengeRequest, GetDeviceFingerprintChallengeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetHumanInteractionChallengeResponse> getHumanInteractionChallenge(GetHumanInteractionChallengeRequest request, AsyncHandler<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse> handler) {
        LOG.trace("Called async getHumanInteractionChallenge");
        GetHumanInteractionChallengeRequest interceptedRequest = GetHumanInteractionChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHumanInteractionChallengeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetHumanInteractionChallengeResponse> transformer = GetHumanInteractionChallengeConverter.fromResponse();
        AsyncHandler<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetHumanInteractionChallengeRequest, GetHumanInteractionChallengeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJsChallengeResponse> getJsChallenge(GetJsChallengeRequest request, AsyncHandler<GetJsChallengeRequest, GetJsChallengeResponse> handler) {
        LOG.trace("Called async getJsChallenge");
        GetJsChallengeRequest interceptedRequest = GetJsChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJsChallengeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetJsChallengeResponse> transformer = GetJsChallengeConverter.fromResponse();
        AsyncHandler<GetJsChallengeRequest, GetJsChallengeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJsChallengeRequest, GetJsChallengeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPolicyConfigResponse> getPolicyConfig(GetPolicyConfigRequest request, AsyncHandler<GetPolicyConfigRequest, GetPolicyConfigResponse> handler) {
        LOG.trace("Called async getPolicyConfig");
        GetPolicyConfigRequest interceptedRequest = GetPolicyConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPolicyConfigConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetPolicyConfigResponse> transformer = GetPolicyConfigConverter.fromResponse();
        AsyncHandler<GetPolicyConfigRequest, GetPolicyConfigResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPolicyConfigRequest, GetPolicyConfigResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProtectionRuleResponse> getProtectionRule(GetProtectionRuleRequest request, AsyncHandler<GetProtectionRuleRequest, GetProtectionRuleResponse> handler) {
        LOG.trace("Called async getProtectionRule");
        GetProtectionRuleRequest interceptedRequest = GetProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetProtectionRuleResponse> transformer = GetProtectionRuleConverter.fromResponse();
        AsyncHandler<GetProtectionRuleRequest, GetProtectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProtectionRuleRequest, GetProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProtectionSettingsResponse> getProtectionSettings(GetProtectionSettingsRequest request, AsyncHandler<GetProtectionSettingsRequest, GetProtectionSettingsResponse> handler) {
        LOG.trace("Called async getProtectionSettings");
        GetProtectionSettingsRequest interceptedRequest = GetProtectionSettingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProtectionSettingsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetProtectionSettingsResponse> transformer = GetProtectionSettingsConverter.fromResponse();
        AsyncHandler<GetProtectionSettingsRequest, GetProtectionSettingsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProtectionSettingsRequest, GetProtectionSettingsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWaasPolicyResponse> getWaasPolicy(GetWaasPolicyRequest request, AsyncHandler<GetWaasPolicyRequest, GetWaasPolicyResponse> handler) {
        LOG.trace("Called async getWaasPolicy");
        GetWaasPolicyRequest interceptedRequest = GetWaasPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWaasPolicyResponse> transformer = GetWaasPolicyConverter.fromResponse();
        AsyncHandler<GetWaasPolicyRequest, GetWaasPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWaasPolicyRequest, GetWaasPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWafAddressRateLimitingResponse> getWafAddressRateLimiting(GetWafAddressRateLimitingRequest request, AsyncHandler<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse> handler) {
        LOG.trace("Called async getWafAddressRateLimiting");
        GetWafAddressRateLimitingRequest interceptedRequest = GetWafAddressRateLimitingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWafAddressRateLimitingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWafAddressRateLimitingResponse> transformer = GetWafAddressRateLimitingConverter.fromResponse();
        AsyncHandler<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWafAddressRateLimitingRequest, GetWafAddressRateLimitingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWafConfigResponse> getWafConfig(GetWafConfigRequest request, AsyncHandler<GetWafConfigRequest, GetWafConfigResponse> handler) {
        LOG.trace("Called async getWafConfig");
        GetWafConfigRequest interceptedRequest = GetWafConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWafConfigConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWafConfigResponse> transformer = GetWafConfigConverter.fromResponse();
        AsyncHandler<GetWafConfigRequest, GetWafConfigResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWafConfigRequest, GetWafConfigResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAccessRulesResponse> listAccessRules(ListAccessRulesRequest request, AsyncHandler<ListAccessRulesRequest, ListAccessRulesResponse> handler) {
        LOG.trace("Called async listAccessRules");
        ListAccessRulesRequest interceptedRequest = ListAccessRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAccessRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAccessRulesResponse> transformer = ListAccessRulesConverter.fromResponse();
        AsyncHandler<ListAccessRulesRequest, ListAccessRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAccessRulesRequest, ListAccessRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAddressListsResponse> listAddressLists(ListAddressListsRequest request, AsyncHandler<ListAddressListsRequest, ListAddressListsResponse> handler) {
        LOG.trace("Called async listAddressLists");
        ListAddressListsRequest interceptedRequest = ListAddressListsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAddressListsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAddressListsResponse> transformer = ListAddressListsConverter.fromResponse();
        AsyncHandler<ListAddressListsRequest, ListAddressListsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAddressListsRequest, ListAddressListsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCachingRulesResponse> listCachingRules(ListCachingRulesRequest request, AsyncHandler<ListCachingRulesRequest, ListCachingRulesResponse> handler) {
        LOG.trace("Called async listCachingRules");
        ListCachingRulesRequest interceptedRequest = ListCachingRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCachingRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCachingRulesResponse> transformer = ListCachingRulesConverter.fromResponse();
        AsyncHandler<ListCachingRulesRequest, ListCachingRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCachingRulesRequest, ListCachingRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCaptchasResponse> listCaptchas(ListCaptchasRequest request, AsyncHandler<ListCaptchasRequest, ListCaptchasResponse> handler) {
        LOG.trace("Called async listCaptchas");
        ListCaptchasRequest interceptedRequest = ListCaptchasConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCaptchasConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCaptchasResponse> transformer = ListCaptchasConverter.fromResponse();
        AsyncHandler<ListCaptchasRequest, ListCaptchasResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCaptchasRequest, ListCaptchasResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCertificatesResponse> listCertificates(ListCertificatesRequest request, AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handler) {
        LOG.trace("Called async listCertificates");
        ListCertificatesRequest interceptedRequest = ListCertificatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCertificatesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCertificatesResponse> transformer = ListCertificatesConverter.fromResponse();
        AsyncHandler<ListCertificatesRequest, ListCertificatesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCertificatesRequest, ListCertificatesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCustomProtectionRulesResponse> listCustomProtectionRules(ListCustomProtectionRulesRequest request, AsyncHandler<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse> handler) {
        LOG.trace("Called async listCustomProtectionRules");
        ListCustomProtectionRulesRequest interceptedRequest = ListCustomProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCustomProtectionRulesResponse> transformer = ListCustomProtectionRulesConverter.fromResponse();
        AsyncHandler<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCustomProtectionRulesRequest, ListCustomProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEdgeSubnetsResponse> listEdgeSubnets(ListEdgeSubnetsRequest request, AsyncHandler<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse> handler) {
        LOG.trace("Called async listEdgeSubnets");
        ListEdgeSubnetsRequest interceptedRequest = ListEdgeSubnetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEdgeSubnetsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListEdgeSubnetsResponse> transformer = ListEdgeSubnetsConverter.fromResponse();
        AsyncHandler<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEdgeSubnetsRequest, ListEdgeSubnetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListGoodBotsResponse> listGoodBots(ListGoodBotsRequest request, AsyncHandler<ListGoodBotsRequest, ListGoodBotsResponse> handler) {
        LOG.trace("Called async listGoodBots");
        ListGoodBotsRequest interceptedRequest = ListGoodBotsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListGoodBotsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListGoodBotsResponse> transformer = ListGoodBotsConverter.fromResponse();
        AsyncHandler<ListGoodBotsRequest, ListGoodBotsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListGoodBotsRequest, ListGoodBotsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProtectionRulesResponse> listProtectionRules(ListProtectionRulesRequest request, AsyncHandler<ListProtectionRulesRequest, ListProtectionRulesResponse> handler) {
        LOG.trace("Called async listProtectionRules");
        ListProtectionRulesRequest interceptedRequest = ListProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListProtectionRulesResponse> transformer = ListProtectionRulesConverter.fromResponse();
        AsyncHandler<ListProtectionRulesRequest, ListProtectionRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProtectionRulesRequest, ListProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRecommendationsResponse> listRecommendations(ListRecommendationsRequest request, AsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse> handler) {
        LOG.trace("Called async listRecommendations");
        ListRecommendationsRequest interceptedRequest = ListRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRecommendationsResponse> transformer = ListRecommendationsConverter.fromResponse();
        AsyncHandler<ListRecommendationsRequest, ListRecommendationsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRecommendationsRequest, ListRecommendationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListThreatFeedsResponse> listThreatFeeds(ListThreatFeedsRequest request, AsyncHandler<ListThreatFeedsRequest, ListThreatFeedsResponse> handler) {
        LOG.trace("Called async listThreatFeeds");
        ListThreatFeedsRequest interceptedRequest = ListThreatFeedsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListThreatFeedsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListThreatFeedsResponse> transformer = ListThreatFeedsConverter.fromResponse();
        AsyncHandler<ListThreatFeedsRequest, ListThreatFeedsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListThreatFeedsRequest, ListThreatFeedsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWaasPoliciesResponse> listWaasPolicies(ListWaasPoliciesRequest request, AsyncHandler<ListWaasPoliciesRequest, ListWaasPoliciesResponse> handler) {
        LOG.trace("Called async listWaasPolicies");
        ListWaasPoliciesRequest interceptedRequest = ListWaasPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWaasPoliciesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWaasPoliciesResponse> transformer = ListWaasPoliciesConverter.fromResponse();
        AsyncHandler<ListWaasPoliciesRequest, ListWaasPoliciesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWaasPoliciesRequest, ListWaasPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWaasPolicyCustomProtectionRulesResponse> listWaasPolicyCustomProtectionRules(ListWaasPolicyCustomProtectionRulesRequest request, AsyncHandler<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse> handler) {
        LOG.trace("Called async listWaasPolicyCustomProtectionRules");
        ListWaasPolicyCustomProtectionRulesRequest interceptedRequest = ListWaasPolicyCustomProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWaasPolicyCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWaasPolicyCustomProtectionRulesResponse> transformer = ListWaasPolicyCustomProtectionRulesConverter.fromResponse();
        AsyncHandler<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWaasPolicyCustomProtectionRulesRequest, ListWaasPolicyCustomProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWafBlockedRequestsResponse> listWafBlockedRequests(ListWafBlockedRequestsRequest request, AsyncHandler<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse> handler) {
        LOG.trace("Called async listWafBlockedRequests");
        ListWafBlockedRequestsRequest interceptedRequest = ListWafBlockedRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWafBlockedRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWafBlockedRequestsResponse> transformer = ListWafBlockedRequestsConverter.fromResponse();
        AsyncHandler<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWafBlockedRequestsRequest, ListWafBlockedRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWafLogsResponse> listWafLogs(ListWafLogsRequest request, AsyncHandler<ListWafLogsRequest, ListWafLogsResponse> handler) {
        LOG.trace("Called async listWafLogs");
        ListWafLogsRequest interceptedRequest = ListWafLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWafLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWafLogsResponse> transformer = ListWafLogsConverter.fromResponse();
        AsyncHandler<ListWafLogsRequest, ListWafLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWafLogsRequest, ListWafLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWafRequestsResponse> listWafRequests(ListWafRequestsRequest request, AsyncHandler<ListWafRequestsRequest, ListWafRequestsResponse> handler) {
        LOG.trace("Called async listWafRequests");
        ListWafRequestsRequest interceptedRequest = ListWafRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWafRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWafRequestsResponse> transformer = ListWafRequestsConverter.fromResponse();
        AsyncHandler<ListWafRequestsRequest, ListWafRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWafRequestsRequest, ListWafRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWafTrafficResponse> listWafTraffic(ListWafTrafficRequest request, AsyncHandler<ListWafTrafficRequest, ListWafTrafficResponse> handler) {
        LOG.trace("Called async listWafTraffic");
        ListWafTrafficRequest interceptedRequest = ListWafTrafficConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWafTrafficConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWafTrafficResponse> transformer = ListWafTrafficConverter.fromResponse();
        AsyncHandler<ListWafTrafficRequest, ListWafTrafficResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWafTrafficRequest, ListWafTrafficResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWhitelistsResponse> listWhitelists(ListWhitelistsRequest request, AsyncHandler<ListWhitelistsRequest, ListWhitelistsResponse> handler) {
        LOG.trace("Called async listWhitelists");
        ListWhitelistsRequest interceptedRequest = ListWhitelistsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWhitelistsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWhitelistsResponse> transformer = ListWhitelistsConverter.fromResponse();
        AsyncHandler<ListWhitelistsRequest, ListWhitelistsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWhitelistsRequest, ListWhitelistsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PurgeCacheResponse> purgeCache(PurgeCacheRequest request, AsyncHandler<PurgeCacheRequest, PurgeCacheResponse> handler) {
        LOG.trace("Called async purgeCache");
        PurgeCacheRequest interceptedRequest = PurgeCacheConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PurgeCacheConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, PurgeCacheResponse> transformer = PurgeCacheConverter.fromResponse();
        AsyncHandler<PurgeCacheRequest, PurgeCacheResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PurgeCacheRequest, PurgeCacheResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAccessRulesResponse> updateAccessRules(UpdateAccessRulesRequest request, AsyncHandler<UpdateAccessRulesRequest, UpdateAccessRulesResponse> handler) {
        LOG.trace("Called async updateAccessRules");
        UpdateAccessRulesRequest interceptedRequest = UpdateAccessRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAccessRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateAccessRulesResponse> transformer = UpdateAccessRulesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateAccessRulesRequest, UpdateAccessRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAccessRulesRequest, UpdateAccessRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAddressListResponse> updateAddressList(UpdateAddressListRequest request, AsyncHandler<UpdateAddressListRequest, UpdateAddressListResponse> handler) {
        LOG.trace("Called async updateAddressList");
        UpdateAddressListRequest interceptedRequest = UpdateAddressListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAddressListConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateAddressListResponse> transformer = UpdateAddressListConverter.fromResponse();
        AsyncHandler<UpdateAddressListRequest, UpdateAddressListResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAddressListRequest, UpdateAddressListResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCachingRulesResponse> updateCachingRules(UpdateCachingRulesRequest request, AsyncHandler<UpdateCachingRulesRequest, UpdateCachingRulesResponse> handler) {
        LOG.trace("Called async updateCachingRules");
        UpdateCachingRulesRequest interceptedRequest = UpdateCachingRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCachingRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCachingRulesResponse> transformer = UpdateCachingRulesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateCachingRulesRequest, UpdateCachingRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCachingRulesRequest, UpdateCachingRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCaptchasResponse> updateCaptchas(UpdateCaptchasRequest request, AsyncHandler<UpdateCaptchasRequest, UpdateCaptchasResponse> handler) {
        LOG.trace("Called async updateCaptchas");
        UpdateCaptchasRequest interceptedRequest = UpdateCaptchasConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCaptchasConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCaptchasResponse> transformer = UpdateCaptchasConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateCaptchasRequest, UpdateCaptchasResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCaptchasRequest, UpdateCaptchasResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest request, AsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse> handler) {
        LOG.trace("Called async updateCertificate");
        UpdateCertificateRequest interceptedRequest = UpdateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCertificateConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCertificateResponse> transformer = UpdateCertificateConverter.fromResponse();
        AsyncHandler<UpdateCertificateRequest, UpdateCertificateResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCertificateRequest, UpdateCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateCustomProtectionRuleResponse> updateCustomProtectionRule(UpdateCustomProtectionRuleRequest request, AsyncHandler<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse> handler) {
        LOG.trace("Called async updateCustomProtectionRule");
        UpdateCustomProtectionRuleRequest interceptedRequest = UpdateCustomProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateCustomProtectionRuleResponse> transformer = UpdateCustomProtectionRuleConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateCustomProtectionRuleRequest, UpdateCustomProtectionRuleResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeviceFingerprintChallengeResponse> updateDeviceFingerprintChallenge(UpdateDeviceFingerprintChallengeRequest request, AsyncHandler<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse> handler) {
        LOG.trace("Called async updateDeviceFingerprintChallenge");
        UpdateDeviceFingerprintChallengeRequest interceptedRequest = UpdateDeviceFingerprintChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeviceFingerprintChallengeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDeviceFingerprintChallengeResponse> transformer = UpdateDeviceFingerprintChallengeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeviceFingerprintChallengeRequest, UpdateDeviceFingerprintChallengeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateGoodBotsResponse> updateGoodBots(UpdateGoodBotsRequest request, AsyncHandler<UpdateGoodBotsRequest, UpdateGoodBotsResponse> handler) {
        LOG.trace("Called async updateGoodBots");
        UpdateGoodBotsRequest interceptedRequest = UpdateGoodBotsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateGoodBotsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateGoodBotsResponse> transformer = UpdateGoodBotsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateGoodBotsRequest, UpdateGoodBotsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateGoodBotsRequest, UpdateGoodBotsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateHumanInteractionChallengeResponse> updateHumanInteractionChallenge(UpdateHumanInteractionChallengeRequest request, AsyncHandler<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse> handler) {
        LOG.trace("Called async updateHumanInteractionChallenge");
        UpdateHumanInteractionChallengeRequest interceptedRequest = UpdateHumanInteractionChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHumanInteractionChallengeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateHumanInteractionChallengeResponse> transformer = UpdateHumanInteractionChallengeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateHumanInteractionChallengeRequest, UpdateHumanInteractionChallengeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateJsChallengeResponse> updateJsChallenge(UpdateJsChallengeRequest request, AsyncHandler<UpdateJsChallengeRequest, UpdateJsChallengeResponse> handler) {
        LOG.trace("Called async updateJsChallenge");
        UpdateJsChallengeRequest interceptedRequest = UpdateJsChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJsChallengeConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateJsChallengeResponse> transformer = UpdateJsChallengeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateJsChallengeRequest, UpdateJsChallengeResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateJsChallengeRequest, UpdateJsChallengeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePolicyConfigResponse> updatePolicyConfig(UpdatePolicyConfigRequest request, AsyncHandler<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse> handler) {
        LOG.trace("Called async updatePolicyConfig");
        UpdatePolicyConfigRequest interceptedRequest = UpdatePolicyConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePolicyConfigConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdatePolicyConfigResponse> transformer = UpdatePolicyConfigConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePolicyConfigRequest, UpdatePolicyConfigResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProtectionRulesResponse> updateProtectionRules(UpdateProtectionRulesRequest request, AsyncHandler<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse> handler) {
        LOG.trace("Called async updateProtectionRules");
        UpdateProtectionRulesRequest interceptedRequest = UpdateProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateProtectionRulesResponse> transformer = UpdateProtectionRulesConverter.fromResponse();
        AsyncHandler<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProtectionRulesRequest, UpdateProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProtectionSettingsResponse> updateProtectionSettings(UpdateProtectionSettingsRequest request, AsyncHandler<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse> handler) {
        LOG.trace("Called async updateProtectionSettings");
        UpdateProtectionSettingsRequest interceptedRequest = UpdateProtectionSettingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProtectionSettingsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateProtectionSettingsResponse> transformer = UpdateProtectionSettingsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProtectionSettingsRequest, UpdateProtectionSettingsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateThreatFeedsResponse> updateThreatFeeds(UpdateThreatFeedsRequest request, AsyncHandler<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse> handler) {
        LOG.trace("Called async updateThreatFeeds");
        UpdateThreatFeedsRequest interceptedRequest = UpdateThreatFeedsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateThreatFeedsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateThreatFeedsResponse> transformer = UpdateThreatFeedsConverter.fromResponse();
        AsyncHandler<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateThreatFeedsRequest, UpdateThreatFeedsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateWaasPolicyResponse> updateWaasPolicy(UpdateWaasPolicyRequest request, AsyncHandler<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse> handler) {
        LOG.trace("Called async updateWaasPolicy");
        UpdateWaasPolicyRequest interceptedRequest = UpdateWaasPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateWaasPolicyResponse> transformer = UpdateWaasPolicyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateWaasPolicyRequest, UpdateWaasPolicyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateWaasPolicyCustomProtectionRulesResponse> updateWaasPolicyCustomProtectionRules(UpdateWaasPolicyCustomProtectionRulesRequest request, AsyncHandler<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse> handler) {
        LOG.trace("Called async updateWaasPolicyCustomProtectionRules");
        UpdateWaasPolicyCustomProtectionRulesRequest interceptedRequest = UpdateWaasPolicyCustomProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWaasPolicyCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateWaasPolicyCustomProtectionRulesResponse> transformer = UpdateWaasPolicyCustomProtectionRulesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateWaasPolicyCustomProtectionRulesRequest, UpdateWaasPolicyCustomProtectionRulesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateWafAddressRateLimitingResponse> updateWafAddressRateLimiting(UpdateWafAddressRateLimitingRequest request, AsyncHandler<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse> handler) {
        LOG.trace("Called async updateWafAddressRateLimiting");
        UpdateWafAddressRateLimitingRequest interceptedRequest = UpdateWafAddressRateLimitingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWafAddressRateLimitingConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateWafAddressRateLimitingResponse> transformer = UpdateWafAddressRateLimitingConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateWafAddressRateLimitingRequest, UpdateWafAddressRateLimitingResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateWafConfigResponse> updateWafConfig(UpdateWafConfigRequest request, AsyncHandler<UpdateWafConfigRequest, UpdateWafConfigResponse> handler) {
        LOG.trace("Called async updateWafConfig");
        UpdateWafConfigRequest interceptedRequest = UpdateWafConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWafConfigConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateWafConfigResponse> transformer = UpdateWafConfigConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateWafConfigRequest, UpdateWafConfigResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateWafConfigRequest, UpdateWafConfigResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateWhitelistsResponse> updateWhitelists(UpdateWhitelistsRequest request, AsyncHandler<UpdateWhitelistsRequest, UpdateWhitelistsResponse> handler) {
        LOG.trace("Called async updateWhitelists");
        UpdateWhitelistsRequest interceptedRequest = UpdateWhitelistsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWhitelistsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateWhitelistsResponse> transformer = UpdateWhitelistsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateWhitelistsRequest, UpdateWhitelistsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateWhitelistsRequest, UpdateWhitelistsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, WaasAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public WaasAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new WaasAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

